/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor;

import java.io.ByteArrayInputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.fusesource.ide.camel.editor.CamelDesignEditor;
import org.fusesource.ide.camel.editor.GoToMarkerForCamelEditor;
import org.fusesource.ide.camel.editor.commands.DiagramOperations;
import org.fusesource.ide.camel.editor.commands.ImportCamelContextElementsCommand;
import org.fusesource.ide.camel.editor.globalconfiguration.CamelGlobalConfigEditor;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.editor.internal.UIMessages;
import org.fusesource.ide.camel.editor.utils.DiagramUtils;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.foundation.ui.io.CamelContextNodeEditorInput;
import org.fusesource.ide.foundation.ui.io.CamelXMLEditorInput;
import org.fusesource.ide.foundation.ui.util.Selections;
import org.fusesource.ide.preferences.PreferenceManager;

public class CamelEditor
extends MultiPageEditorPart
implements IResourceChangeListener,
ITabbedPropertySheetPageContributor,
IDocumentListener,
IPropertyChangeListener {
    public static final String INTEGRATION_PERSPECTIVE_ID = "org.fusesource.ide.branding.perspective";
    public static final int DESIGN_PAGE_INDEX = 0;
    public static final int SOURCE_PAGE_INDEX = 1;
    public static final int GLOBAL_CONF_INDEX = 2;
    private StructuredTextEditor sourceEditor;
    private CamelDesignEditor designEditor;
    private CamelGlobalConfigEditor globalConfigEditor;
    private ISelection savedSelection;
    private int lastActivePageIdx = 0;
    private CamelXMLEditorInput editorInput;
    private String lastError = "";
    private boolean dirtyFlag = false;
    private boolean disableDirtyFlag = false;
    private boolean rollBackActive = false;

    public CamelEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        PreferenceManager.getInstance().getUnderlyingStorage().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                this.closeEditorsWithoutValidInput();
                break;
            }
            case 4: {
                this.closeEditorsWithoutValidInput();
                break;
            }
            case 2: {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchPage[] pages = CamelEditor.this.getSite().getWorkbenchWindow().getPages();
                        int i = 0;
                        while (i < pages.length) {
                            IEditorInput editorInput = CamelEditor.this.sourceEditor.getEditorInput();
                            if (editorInput instanceof FileEditorInput && ((FileEditorInput)editorInput).getFile().getProject().equals((Object)event.getResource())) {
                                IWorkbenchPage page = pages[i];
                                IEditorPart editorPart = page.findEditor(editorInput);
                                page.closeEditor(editorPart, true);
                            }
                            ++i;
                        }
                    }
                });
            }
        }
    }

    public void setFocus() {
        super.setFocus();
        if (this.designEditor != null) {
            DiagramOperations.layoutDiagram(this.designEditor);
        }
    }

    protected void closeEditorsWithoutValidInput() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page;
                IWorkbenchPartSite site = CamelEditor.this.getSite();
                if (site != null && (page = site.getPage()) != null) {
                    IEditorReference[] eds;
                    IEditorReference[] iEditorReferenceArray = eds = page.getEditorReferences();
                    int n = eds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEditorInput editorInput;
                        IEditorReference er = iEditorReferenceArray[n2];
                        IEditorPart editor = er.getEditor(false);
                        if (editor != null && (editorInput = editor.getEditorInput()) instanceof CamelXMLEditorInput && !((CamelXMLEditorInput)editorInput).getCamelContextFile().exists()) {
                            page.closeEditor(er.getEditor(false), false);
                            if (er != null && er.getEditor(false) != null) {
                                er.getEditor(false).dispose();
                            }
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    protected void createPages() {
        this.stopDirtyListener();
        this.createDesignPage(0);
        this.createSourcePage(1);
        this.createGlobalConfPage(2);
        IDocument document = this.getDocument();
        if (document == null) {
            throw new IllegalStateException("No Document available!");
        }
        document.addDocumentListener((IDocumentListener)this);
    }

    public IEditorPart getActiveEditor() {
        return super.getActiveEditor();
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        if (this.getActivePage() == 1) {
            this.setDirtyFlag(true);
        }
    }

    public boolean isDirty() {
        return this.dirtyFlag;
    }

    public void setDirtyFlag(boolean dirtyFlag) {
        if (!this.disableDirtyFlag) {
            this.dirtyFlag = dirtyFlag;
            this.firePropertyChange(257);
        }
    }

    public void stopDirtyListener() {
        this.disableDirtyFlag = true;
    }

    public void startDirtyListener() {
        this.disableDirtyFlag = false;
    }

    private void createSourcePage(int index) {
        try {
            this.sourceEditor = new StructuredTextEditor();
            IFileEditorInput editorInput = this.designEditor.asFileEditorInput(this.getEditorInput());
            this.addPage(index, (IEditorPart)this.sourceEditor, (IEditorInput)editorInput);
            this.setPageText(index, UIMessages.editorSourcePageTitle);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    private void createDesignPage(int index) {
        try {
            this.designEditor = new CamelDesignEditor(this);
            IEditorInput editorInput = this.getEditorInput();
            this.addPage(index, (IEditorPart)this.designEditor, editorInput);
            this.setPageText(index, UIMessages.editorDesignPageTitle);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested design editor", null, (IStatus)e.getStatus());
        }
    }

    private void createGlobalConfPage(int index) {
        try {
            this.globalConfigEditor = new CamelGlobalConfigEditor(this);
            IEditorInput editorInput = this.getEditorInput();
            this.addPage(index, (IEditorPart)this.globalConfigEditor, editorInput);
            this.setPageText(index, UIMessages.editorGlobalConfigurationPageTitle);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested global configuration page", null, (IStatus)e.getStatus());
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            if (this.getActivePage() == 0 || this.getActivePage() == 2) {
                this.updateSourceFromModel(false);
                this.sourceEditor.doSave(monitor);
            } else if (this.getActivePage() == 1) {
                this.sourceEditor.doSave(monitor);
            }
            if (this.getEditorInput() instanceof CamelXMLEditorInput) {
                ((CamelXMLEditorInput)this.getEditorInput()).onEditorInputSave();
            }
            this.setDirtyFlag(false);
        }
        finally {
            this.refreshProject(monitor);
        }
    }

    public void doSaveAs() {
        try {
            if (this.getActivePage() == 0 || this.getActivePage() == 2) {
                this.updateSourceFromModel(false);
                this.sourceEditor.doSaveAs();
            } else if (this.getActivePage() == 1) {
                this.sourceEditor.doSaveAs();
            }
            this.setDirtyFlag(false);
        }
        finally {
            this.refreshProject((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public String getTitle() {
        return this.editorInput != null ? this.editorInput.getName() : "";
    }

    private void refreshProject(IProgressMonitor monitor) {
        IProject prj = this.editorInput.getCamelContextFile().getProject();
        try {
            prj.refreshLocal(2, monitor);
        }
        catch (CoreException ex) {
            CamelEditorUIActivator.pluginLog().logError("Unable to refresh project after saving...", (Throwable)ex);
        }
    }

    protected void saveSelection() {
        this.savedSelection = this.getActiveEditor().getEditorSite().getSelectionProvider().getSelection();
    }

    protected void restoreSelection() {
        this.getActiveEditor().getEditorSite().getSelectionProvider().setSelection(this.savedSelection);
    }

    public void onFileLoading(String fileName) {
        this.setPartName(this.editorInput != null ? this.editorInput.getName() : "");
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        PreferenceManager.getInstance().getUnderlyingStorage().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    protected void pageChange(int newPageIndex) {
        if (newPageIndex == 1) {
            if (this.sourceEditor == null) {
                this.sourceEditor = new StructuredTextEditor();
            }
            if (!this.rollBackActive) {
                this.updateSourceFromModel();
            } else {
                this.rollBackActive = false;
            }
            this.lastActivePageIdx = newPageIndex;
            super.pageChange(newPageIndex);
        } else if (newPageIndex == 0 || newPageIndex == 2) {
            if (this.lastActivePageIdx == 1) {
                IDocument document = this.getDocument();
                if (document != null) {
                    String text = document.get();
                    boolean ignoreError = true;
                    if (!this.isValidXML(text)) {
                        ignoreError = MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)UIMessages.failedXMLValidationTitle, (String)NLS.bind((String)UIMessages.failedXMLValidationText, (Object)this.lastError));
                    }
                    if (ignoreError) {
                        this.updateModelFromSource();
                        this.lastError = "";
                        if (newPageIndex == 2) {
                            this.globalConfigEditor.reload();
                        }
                        if (newPageIndex == 0) {
                            this.designEditor.refreshOutlineView();
                        }
                        this.lastActivePageIdx = newPageIndex;
                        super.pageChange(newPageIndex);
                    } else {
                        this.rollBackActive = true;
                        newPageIndex = 1;
                        this.setActivePage(1);
                        super.pageChange(newPageIndex);
                        this.getDocument().set(text);
                    }
                }
            } else if (newPageIndex == 2) {
                this.globalConfigEditor.reload();
            } else {
                this.designEditor.update();
                this.designEditor.refreshOutlineView();
            }
        }
    }

    private boolean continueWithUnconnectedFigures() {
        boolean unconnectedNodeFound = false;
        unconnectedNodeFound = this.findUnconnectedNode(this.designEditor.getModel().getChildElements());
        if (!unconnectedNodeFound) {
            return true;
        }
        return MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)UIMessages.unconnectedNodeFoundTitle, (String)UIMessages.unconnectedNodeFoundText);
    }

    private boolean findUnconnectedNode(List<AbstractCamelModelElement> nodes) {
        boolean unconnected = false;
        int nodesWithoutInput = 0;
        int nodesWithoutOutput = 0;
        for (AbstractCamelModelElement node : nodes) {
            if (!node.getChildElements().isEmpty() && (unconnected = this.findUnconnectedNode(node.getChildElements()))) {
                return true;
            }
            if (node.getInputElement() == null) {
                ++nodesWithoutInput;
            }
            if (node.getOutputElement() != null) continue;
            ++nodesWithoutOutput;
        }
        return nodesWithoutInput > 1 || nodesWithoutOutput > 1;
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    void updateSourceFromModel() {
        this.updateSourceFromModel(true);
    }

    void updateSourceFromModel(boolean async) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    CamelEditor.this.stopDirtyListener();
                    IDocument document = CamelEditor.this.getDocument();
                    if (document != null) {
                        String newText;
                        String text = document.get();
                        CamelFile model = CamelEditor.this.designEditor.getModel();
                        if (model != null && !text.equals(newText = model.getDocumentAsXML())) {
                            boolean designEditorWasDirty = CamelEditor.this.designEditor.isDirty();
                            document.set(newText);
                            if (!designEditorWasDirty) {
                                CamelEditor.this.doSave((IProgressMonitor)new NullProgressMonitor());
                            }
                        }
                    }
                }
                finally {
                    CamelEditor.this.startDirtyListener();
                }
            }
        };
        if (async) {
            Display.getDefault().asyncExec(r);
        } else {
            Display.getDefault().syncExec(r);
        }
    }

    void updateModelFromSource() {
        this.updateModelFromSource(true);
    }

    private void updateModelFromSource(boolean async) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                CamelEditor.this.stopDirtyListener();
                String text = CamelEditor.this.getDocument().get();
                if (CamelEditor.this.designEditor != null) {
                    CamelEditor.this.designEditor.clearCache();
                    CamelEditor.this.designEditor.setModel(CamelEditor.this.designEditor.getModel().reloadModelFromXML(text));
                    ImportCamelContextElementsCommand importCommand = new ImportCamelContextElementsCommand(CamelEditor.this.designEditor, CamelEditor.this.designEditor.getEditingDomain(), (AbstractCamelModelElement)(CamelEditor.this.getDesignEditor().getSelectedContainer() != null ? CamelEditor.this.getDesignEditor().getSelectedContainer() : CamelEditor.this.designEditor.getModel()), null);
                    CamelEditor.this.designEditor.getEditingDomain().getCommandStack().execute((Command)importCommand);
                    CamelEditor.this.designEditor.initializeDiagram(importCommand.getDiagram());
                    CamelEditor.this.designEditor.refreshDiagramContents(null);
                }
            }
        };
        if (async) {
            Display.getDefault().asyncExec(r);
        } else {
            Display.getDefault().syncExec(r);
        }
    }

    private boolean isValidXML(String text) {
        try {
            this.lastError = "";
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.parse(new ByteArrayInputStream(text.getBytes()));
        }
        catch (Exception ex) {
            String error;
            this.lastError = error = ex.getMessage();
            return false;
        }
        return true;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == TextEditor.class) {
            return this.sourceEditor;
        }
        if (adapter == CamelFile.class) {
            return this.designEditor.getModel();
        }
        if (adapter == CamelDesignEditor.class) {
            return this.designEditor;
        }
        if (adapter == CamelGlobalConfigEditor.class) {
            return this.globalConfigEditor;
        }
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        if (adapter == IDocumentProvider.class) {
            Object answer;
            IEditorInput editorInput = this.getEditorInput();
            if (editorInput != null && (answer = editorInput.getAdapter(adapter)) != null) {
                return answer;
            }
        } else if (adapter == IGotoMarker.class) {
            return new GoToMarkerForCamelEditor(this);
        }
        return super.getAdapter(adapter);
    }

    public StructuredTextEditor getSourceEditor() {
        return this.sourceEditor;
    }

    public CamelDesignEditor getDesignEditor() {
        return this.designEditor;
    }

    public CamelGlobalConfigEditor getGlobalConfigEditor() {
        return this.globalConfigEditor;
    }

    public IDocument getDocument() {
        IEditorInput element = this.sourceEditor.getEditorInput();
        IDocumentProvider documentProvider = this.sourceEditor.getDocumentProvider();
        if (documentProvider != null) {
            IDocument document = documentProvider.getDocument((Object)element);
            return document;
        }
        return null;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.editorInput = null;
        if (input instanceof IFileEditorInput) {
            this.editorInput = new CamelXMLEditorInput(((IFileEditorInput)input).getFile(), null);
        } else if (input instanceof DiagramEditorInput) {
            IFile f = (IFile)((DiagramEditorInput)input).getAdapter(IFile.class);
            this.editorInput = new CamelXMLEditorInput(f, null);
        } else if (input instanceof CamelContextNodeEditorInput) {
            this.editorInput = (CamelContextNodeEditorInput)input;
        } else if (input instanceof CamelXMLEditorInput) {
            this.editorInput = (CamelXMLEditorInput)input;
        } else {
            throw new PartInitException("Unknown input type: " + input.getClass().getName());
        }
        super.init(site, (IEditorInput)this.editorInput);
    }

    protected void handlePropertyChange(int propertyId) {
        IResource res;
        ISelectionProvider selProvider;
        Object o;
        super.handlePropertyChange(propertyId);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart viewPart = page.findView("org.eclipse.ui.navigator.ProjectExplorer");
        if (viewPart != null && (o = Selections.getFirstSelection((ISelection)(selProvider = viewPart.getSite().getSelectionProvider()).getSelection())) != null && o instanceof IResource && (res = (IResource)o).getLocationURI().getPath().equals(this.editorInput.getCamelContextFile().getLocationURI().getPath()) && this.editorInput.getSelectedContainerId() != null && !this.editorInput.getSelectedContainerId().equals(this.getDesignEditor().getModel().getCamelContext().getId())) {
            this.editorInput.setSelectedContainerId(null);
            this.getDesignEditor().setSelectedContainer(null);
        }
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (input instanceof CamelXMLEditorInput && !input.equals(this.editorInput)) {
            this.editorInput = (CamelXMLEditorInput)input;
        }
        this.setPartName(input.getName());
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("preferIdAsLabelPreference")) {
            this.designEditor.update();
        } else if (event.getProperty().equals("diagramLayoutOrientationPreference")) {
            this.designEditor.autoLayoutRoute();
        } else if (event.getProperty().equals("diagramGridVisibilityPreference")) {
            DiagramUtils.setGridVisible((Boolean)event.getNewValue(), this.designEditor);
        } else if (event.getProperty().equals("diagramTextColorPreference") || event.getProperty().equals("diagramConnectionColorPreference") || event.getProperty().equals("diagramFigureBackgroundColorPreference") || event.getProperty().equals("diagramFigureForegroundColorPreference")) {
            this.designEditor.getDiagramBehavior().refresh();
        } else if (event.getProperty().equals("diagramGridColorPreference")) {
            this.designEditor.setupGridVisibilityAsync();
        }
    }

    public void switchToDesignEditor() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CamelEditor.this.setActiveEditor((IEditorPart)CamelEditor.this.getDesignEditor());
                CamelEditor.this.setActivePage(0);
                CamelEditor.this.getDesignEditor().setFocus();
            }
        });
    }

    public CamelXMLEditorInput getCamelXMLInput() {
        return this.editorInput;
    }

    public void updateSelectedContainer(String containerId) {
        this.editorInput.setSelectedContainerId(containerId);
    }
}

