/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.fusesource.ide.camel.editor.CamelDesignEditor;
import org.fusesource.ide.camel.editor.CamelEditor;
import org.fusesource.ide.camel.editor.globalconfiguration.CamelGlobalConfigEditor;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelContextElement;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteElement;

public class GoToMarkerForCamelEditor
implements IGotoMarker {
    private CamelEditor camelEditor;

    public GoToMarkerForCamelEditor(CamelEditor camelEditor) {
        this.camelEditor = camelEditor;
    }

    public void gotoMarker(IMarker marker) {
        int lineNumber;
        try {
            if (marker.exists()) {
                CamelDesignEditor designEditor;
                CamelFile camelFile;
                AbstractCamelModelElement camelModelElement;
                String id = (String)marker.getAttribute("IFuseMarker_CAMEL_ID");
                if (id != null && (camelModelElement = (camelFile = (designEditor = this.camelEditor.getDesignEditor()).getModel()).findNode(id)) != null) {
                    if (this.isGlobalElement(camelModelElement)) {
                        CamelGlobalConfigEditor globalConfigEditor = this.camelEditor.getGlobalConfigEditor();
                        this.camelEditor.setActiveEditor((IEditorPart)globalConfigEditor);
                        globalConfigEditor.setSelection(camelModelElement);
                        return;
                    }
                    this.camelEditor.setActiveEditor((IEditorPart)designEditor);
                    designEditor.setSelectedNode(camelModelElement);
                    return;
                }
            } else {
                System.out.println(marker);
            }
        }
        catch (CoreException e) {
            CamelEditorUIActivator.pluginLog().logError((Throwable)e);
        }
        if ((lineNumber = MarkerUtilities.getLineNumber((IMarker)marker)) != -1) {
            StructuredTextEditor sourceEditor = this.camelEditor.getSourceEditor();
            this.camelEditor.setActiveEditor((IEditorPart)sourceEditor);
            IGotoMarker sourceEditorGoToMarker = (IGotoMarker)sourceEditor.getAdapter(IGotoMarker.class);
            if (sourceEditorGoToMarker != null) {
                sourceEditorGoToMarker.gotoMarker(marker);
            }
        }
    }

    private boolean isGlobalElement(AbstractCamelModelElement camelModelElement) {
        if (camelModelElement instanceof CamelContextElement) {
            return true;
        }
        if (camelModelElement instanceof CamelRouteElement) {
            return false;
        }
        AbstractCamelModelElement parent = camelModelElement.getParent();
        if (parent != null) {
            return this.isGlobalElement(parent);
        }
        return false;
    }
}

