/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.behaviours;

import java.util.ArrayList;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.ui.internal.command.AddModelObjectCommand;
import org.eclipse.graphiti.ui.internal.command.CreateModelObjectCommand;
import org.eclipse.graphiti.ui.internal.parts.ConnectionEditPart;
import org.eclipse.graphiti.ui.internal.policy.DefaultConnectionEditPolicy;
import org.eclipse.graphiti.ui.internal.policy.ShapeXYLayoutEditPolicy;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.graphiti.ui.platform.IConfigurationProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;

final class CamelDefaultConnectionEditPolicy
extends DefaultConnectionEditPolicy {
    CamelDefaultConnectionEditPolicy(IConfigurationProvider configurationProvider) {
        super(configurationProvider);
    }

    protected Command getCreateCommand(CreateRequest request) {
        EditPart findEditPartAt;
        UnexecutableCommand cmd = UnexecutableCommand.INSTANCE;
        GraphicalViewer graphicalViewer = this.getConfigurationProvider().getDiagramContainer().getGraphicalViewer();
        Control control = graphicalViewer.getControl();
        Point searchLocation = request.getLocation().getCopy();
        if (control instanceof FigureCanvas) {
            FreeformViewport viewport = (FreeformViewport)((FigureCanvas)control).getViewport();
            Point viewPortLocation = viewport.getViewLocation();
            searchLocation.translate(viewPortLocation);
        }
        ContainerShape targetContainerShape = (findEditPartAt = GraphitiUiInternal.getGefService().findEditPartAt((EditPartViewer)graphicalViewer, searchLocation, false)) != null && findEditPartAt.getModel() instanceof ContainerShape ? (ContainerShape)findEditPartAt.getModel() : this.getCommonContainerShape();
        Object createdObject = request.getNewObject();
        Rectangle rectangle = new Rectangle();
        if (findEditPartAt != null) {
            Point where = this.createRealLocation(request.getLocation(), findEditPartAt);
            rectangle.setLocation(where);
        } else {
            rectangle.setLocation(request.getLocation());
        }
        if (request.getSize() != null) {
            rectangle.setSize(request.getSize());
        }
        Connection connection = (Connection)this.getHost().getModel();
        if (request.getNewObjectType() == ICreateFeature.class) {
            ICreateContext context = ShapeXYLayoutEditPolicy.createCreateContext((ContainerShape)targetContainerShape, (Rectangle)rectangle);
            ((CreateContext)context).setTargetConnection(connection);
            ICreateFeature createFeature = (ICreateFeature)createdObject;
            cmd = new CreateModelObjectCommand(this.getConfigurationProvider(), createFeature, context);
            cmd.setLabel(createFeature.getDescription());
        } else if (request.getNewObjectType() == ISelection.class) {
            cmd = new AddModelObjectCommand(this.getConfigurationProvider(), targetContainerShape, (ISelection)createdObject, rectangle, connection);
        }
        return cmd;
    }

    private Point createRealLocation(Point location, EditPart findEditPartAt) {
        IFigure layoutContainer = ((GraphicalEditPart)findEditPartAt).getContentPane();
        Point where = location.getCopy();
        layoutContainer.translateToRelative((Translatable)where);
        layoutContainer.translateFromParent((Translatable)where);
        Point layoutOrigin = layoutContainer.getClientArea().getLocation();
        where.translate(layoutOrigin.getNegated());
        return where;
    }

    private ContainerShape getCommonContainerShape() {
        ConnectionEditPart connectionEditPart = (ConnectionEditPart)this.getHost();
        EditPart sourceEditPart = connectionEditPart.getSource();
        EditPart targetEditPart = connectionEditPart.getTarget();
        EditPart parent = this.getCommonEditPart(sourceEditPart, targetEditPart);
        return (ContainerShape)parent.getModel();
    }

    private EditPart getCommonEditPart(EditPart source, EditPart target) {
        ArrayList<EditPart> list1 = new ArrayList<EditPart>();
        ArrayList<EditPart> list2 = new ArrayList<EditPart>();
        EditPart editPart = source;
        while (!(editPart instanceof RootEditPart)) {
            list1.add(0, editPart);
            editPart = editPart.getParent();
        }
        editPart = target;
        while (!(editPart instanceof RootEditPart)) {
            list2.add(0, editPart);
            editPart = editPart.getParent();
        }
        int index = 0;
        while (index != list1.size()) {
            if (index == list2.size()) {
                return (EditPart)list1.get(index - 1);
            }
            if (list1.get(index) != list2.get(index)) {
                return (EditPart)list1.get(index - 1);
            }
            ++index;
        }
        return (EditPart)list1.get(index - 1);
    }
}

