/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.behaviours;

import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.ui.editor.DefaultPaletteBehavior;
import org.eclipse.graphiti.ui.editor.DefaultPersistencyBehavior;
import org.eclipse.graphiti.ui.editor.DefaultUpdateBehavior;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.IDiagramContainerUI;
import org.eclipse.graphiti.ui.platform.IConfigurationProvider;
import org.fusesource.ide.camel.editor.CamelDesignEditor;
import org.fusesource.ide.camel.editor.behaviours.CamelConfigurationProvider;
import org.fusesource.ide.camel.editor.behaviours.CamelPaletteBehaviour;
import org.fusesource.ide.camel.editor.behaviours.CamelPersistencyBehaviour;
import org.fusesource.ide.camel.editor.behaviours.CamelUpdateBehaviour;
import org.fusesource.ide.camel.editor.internal.CamelModelChangeListener;
import org.fusesource.ide.camel.editor.internal.UIMessages;
import org.fusesource.ide.camel.editor.provider.CamelDiagramEditorContextMenuProvider;

public class CamelDiagramBehaviour
extends DiagramBehavior {
    private CamelUpdateBehaviour camelUpdateBehaviour;
    private CamelPaletteBehaviour camelPaletteBehaviour;
    private CamelPersistencyBehaviour camelPersistencyBehaviour;
    private CamelModelChangeListener camelModelListener;
    private CamelDesignEditor camelDesignEditor;

    public CamelDiagramBehaviour(IDiagramContainerUI diagramContainer) {
        super(diagramContainer);
        this.camelDesignEditor = (CamelDesignEditor)diagramContainer;
    }

    protected DefaultUpdateBehavior createUpdateBehavior() {
        if (this.camelUpdateBehaviour == null) {
            this.camelUpdateBehaviour = new CamelUpdateBehaviour(this.camelDesignEditor);
        }
        return this.camelUpdateBehaviour;
    }

    protected DefaultPersistencyBehavior createPersistencyBehavior() {
        if (this.camelPersistencyBehaviour == null) {
            this.camelPersistencyBehaviour = new CamelPersistencyBehaviour(this.camelDesignEditor);
        }
        return this.camelPersistencyBehaviour;
    }

    protected DefaultPaletteBehavior createPaletteBehaviour() {
        if (this.camelPaletteBehaviour == null) {
            this.camelPaletteBehaviour = new CamelPaletteBehaviour(this.camelDesignEditor);
        }
        return this.camelPaletteBehaviour;
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.camelUpdateBehaviour != null ? this.camelUpdateBehaviour.getEditingDomain() : null;
    }

    public IConfigurationProvider getConfigurationProvider() {
        return super.getConfigurationProvider();
    }

    protected ContextMenuProvider createContextMenuProvider() {
        return new CamelDiagramEditorContextMenuProvider((EditPartViewer)this.camelDesignEditor.getGraphicalViewer(), this.camelDesignEditor.getActionRegistry(), this.getConfigurationProvider());
    }

    protected void registerBusinessObjectsListener() {
        this.camelModelListener = new CamelModelChangeListener(this.camelDesignEditor);
        TransactionalEditingDomain eDomain = this.getEditingDomain();
        eDomain.addResourceSetListener((ResourceSetListener)this.camelModelListener);
    }

    public String getEditorInitializationError() {
        return super.getEditorInitializationError();
    }

    protected void setEditorInitializationError(String editorInitializationError) {
        super.setEditorInitializationError(UIMessages.CamelDiagramBehaviour_messageOnErrorEditorInitialization);
    }

    protected IConfigurationProvider createConfigurationProvider(IDiagramTypeProvider diagramTypeProvider) {
        return new CamelConfigurationProvider(this, diagramTypeProvider);
    }
}

