/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.commands;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.swt.widgets.Display;
import org.fusesource.ide.camel.editor.CamelDesignEditor;
import org.fusesource.ide.camel.editor.commands.ChangeGridColorCommand;
import org.fusesource.ide.camel.editor.commands.DeleteNodeCommand;
import org.fusesource.ide.camel.editor.commands.HighlightNodeCommand;
import org.fusesource.ide.camel.editor.commands.LayoutCommand;
import org.fusesource.ide.camel.editor.commands.UpdateCommand;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;

public class DiagramOperations {
    public static LayoutCommand layoutDiagram(CamelDesignEditor designEditor) {
        return DiagramOperations.layoutDiagram(designEditor, false);
    }

    public static LayoutCommand layoutDiagram(CamelDesignEditor designEditor, boolean modelChanged) {
        if (designEditor == null) {
            return null;
        }
        TransactionalEditingDomain editingDomain = DiagramOperations.createEditingDomain(designEditor);
        LayoutCommand operation = new LayoutCommand(designEditor.getFeatureProvider(), designEditor.getDiagramTypeProvider().getDiagram(), (AbstractCamelModelElement)designEditor.getModel().getCamelContext(), editingDomain);
        DiagramOperations.execute(editingDomain, operation, modelChanged);
        return operation;
    }

    public static LayoutCommand layoutDiagram(TransactionalEditingDomain editingDomain, IFeatureProvider featureProvider, Diagram diagram, AbstractCamelModelElement container) {
        LayoutCommand operation = new LayoutCommand(featureProvider, diagram, container, editingDomain);
        DiagramOperations.execute(editingDomain, operation, false);
        return operation;
    }

    public static UpdateCommand updateSelectedNode(CamelDesignEditor designEditor) {
        TransactionalEditingDomain editingDomain = DiagramOperations.createEditingDomain(designEditor);
        UpdateCommand operation = new UpdateCommand(designEditor, editingDomain, designEditor.getSelectedNode());
        DiagramOperations.execute(editingDomain, operation, true);
        return operation;
    }

    public static UpdateCommand updateDiagram(CamelDesignEditor designEditor) {
        CamelFile designEditorModel = designEditor.getModel();
        if (designEditorModel != null) {
            TransactionalEditingDomain editingDomain = DiagramOperations.createEditingDomain(designEditor);
            UpdateCommand operation = new UpdateCommand(designEditor, editingDomain, (AbstractCamelModelElement)designEditorModel.getCamelContext());
            DiagramOperations.execute(editingDomain, operation, true);
            return operation;
        }
        return null;
    }

    public static DeleteNodeCommand deleteNode(CamelDesignEditor designEditor, AbstractCamelModelElement selectedNode) {
        TransactionalEditingDomain editingDomain = DiagramOperations.createEditingDomain(designEditor);
        DeleteNodeCommand operation = new DeleteNodeCommand(designEditor, editingDomain, selectedNode);
        DiagramOperations.execute(editingDomain, operation, true);
        return operation;
    }

    public static void execute(TransactionalEditingDomain editingDomain, RecordingCommand operation, boolean modelChanged) {
        editingDomain.getCommandStack().execute((Command)operation);
        if (!modelChanged) {
            editingDomain.getCommandStack().flush();
        }
    }

    protected static synchronized TransactionalEditingDomain createEditingDomain(CamelDesignEditor designEditor) {
        IDiagramBehavior diagramBehavior;
        TransactionalEditingDomain editingDomain = designEditor.getEditingDomain();
        IDiagramTypeProvider diagramTypeProvider = designEditor.getDiagramTypeProvider();
        if (diagramTypeProvider == null) {
            return null;
        }
        Diagram diagram = diagramTypeProvider.getDiagram();
        if (diagram == null) {
            return null;
        }
        if (editingDomain == null && (diagramBehavior = diagramTypeProvider.getDiagramBehavior()) != null) {
            editingDomain = diagramBehavior.getEditingDomain();
        }
        if (editingDomain == null) {
            ResourceSet resourceSet = null;
            Resource eResource = diagram.eResource();
            if (eResource != null) {
                resourceSet = eResource.getResourceSet();
            }
            if (resourceSet == null) {
                resourceSet = new ResourceSetImpl();
            }
            if ((editingDomain = TransactionUtil.getEditingDomain((ResourceSet)resourceSet)) == null) {
                editingDomain = GraphitiUi.getEmfService().createResourceSetAndEditingDomain();
            }
        }
        return editingDomain;
    }

    public static ChangeGridColorCommand updateGridColor(CamelDesignEditor designEditor) {
        TransactionalEditingDomain editingDomain = DiagramOperations.createEditingDomain(designEditor);
        ChangeGridColorCommand operation = new ChangeGridColorCommand(designEditor, editingDomain);
        DiagramOperations.execute(editingDomain, operation, false);
        return operation;
    }

    public static void highlightNode(final CamelDesignEditor designEditor, final AbstractCamelModelElement node, final boolean highlight) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TransactionalEditingDomain editingDomain = DiagramOperations.createEditingDomain(designEditor);
                if (editingDomain != null) {
                    HighlightNodeCommand operation = new HighlightNodeCommand(designEditor, editingDomain, node, highlight);
                    DiagramOperations.execute(editingDomain, operation, false);
                }
            }
        });
    }
}

