/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.commands;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.fusesource.ide.camel.editor.CamelDesignEditor;
import org.fusesource.ide.camel.editor.internal.CamelDiagramLoader;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelContextElement;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;

public class ImportCamelContextElementsCommand
extends RecordingCommand {
    private TransactionalEditingDomain editingDomain;
    private CamelDesignEditor designEditor;
    private AbstractCamelModelElement container;
    private Resource createdResource;
    private Diagram diagram;
    private IFeatureProvider featureProvider;
    private CamelFile camelContextFile;

    public ImportCamelContextElementsCommand(CamelDesignEditor designEditor, TransactionalEditingDomain editingDomain, CamelFile camelContextFile) {
        this(designEditor, editingDomain, camelContextFile, null);
    }

    public ImportCamelContextElementsCommand(CamelDesignEditor designEditor, TransactionalEditingDomain editingDomain, CamelFile camelContextFile, Diagram diagram) {
        super(editingDomain);
        this.designEditor = designEditor;
        this.editingDomain = editingDomain;
        this.camelContextFile = camelContextFile;
        this.diagram = diagram;
    }

    public ImportCamelContextElementsCommand(CamelDesignEditor designEditor, TransactionalEditingDomain editingDomain, AbstractCamelModelElement container, Diagram diagram) {
        super(editingDomain);
        this.designEditor = designEditor;
        this.editingDomain = editingDomain;
        this.camelContextFile = container.getCamelFile();
        this.diagram = diagram;
        this.container = container;
    }

    protected void doExecute() {
        block17: {
            CamelContextElement context = null;
            try {
                try {
                    this.designEditor.getParent().stopDirtyListener();
                    if (this.designEditor.getModel() != null) {
                        this.designEditor.getModel().unregisterDOMListener();
                    }
                    String diagramName = "CamelContext";
                    this.diagram = Graphiti.getPeCreateService().createDiagram("CamelContext", diagramName, true);
                    java.net.URI camelContextlocationURI = this.camelContextFile.getResource().getLocationURI();
                    URI uri = URI.createPlatformResourceURI((String)(camelContextlocationURI != null ? camelContextlocationURI.getPath() : this.camelContextFile.getResource().getFullPath().toOSString()), (boolean)true);
                    this.createdResource = this.editingDomain.getResourceSet().createResource(uri);
                    this.createdResource.getContents().add((Object)this.diagram);
                    IDiagramTypeProvider dtp = GraphitiUi.getExtensionManager().createDiagramTypeProvider(this.diagram, "org.fusesource.ide.camel.editor.dtp.id");
                    IFeatureProvider featureProvider = dtp.getFeatureProvider();
                    CamelDiagramLoader diagramReader = new CamelDiagramLoader(this.diagram, featureProvider);
                    try {
                        context = this.camelContextFile.getChildElements().isEmpty() ? null : (CamelContextElement)this.camelContextFile.getChildElements().get(0);
                        diagramReader.loadModel(this.editingDomain, (AbstractCamelModelElement)(this.container != null && !(this.container instanceof CamelFile) ? this.container : context));
                    }
                    catch (Exception e) {
                        CamelEditorUIActivator.pluginLog().logError("Failed to load model: " + e, (Throwable)e);
                    }
                }
                catch (Exception ex) {
                    CamelEditorUIActivator.pluginLog().logError((Throwable)ex);
                    if (this.designEditor.getDiagramTypeProvider() != null) {
                        this.designEditor.getDiagramTypeProvider().resourceReloaded(this.diagram);
                    }
                    this.designEditor.getParent().startDirtyListener();
                    if (this.designEditor.getModel() != null) {
                        this.designEditor.getModel().registerDOMListener();
                    }
                    if (context != null) {
                        context.ensureUniqueID(context);
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (this.designEditor.getDiagramTypeProvider() != null) {
                    this.designEditor.getDiagramTypeProvider().resourceReloaded(this.diagram);
                }
                this.designEditor.getParent().startDirtyListener();
                if (this.designEditor.getModel() != null) {
                    this.designEditor.getModel().registerDOMListener();
                }
                if (context != null) {
                    context.ensureUniqueID(context);
                }
                throw throwable;
            }
            if (this.designEditor.getDiagramTypeProvider() != null) {
                this.designEditor.getDiagramTypeProvider().resourceReloaded(this.diagram);
            }
            this.designEditor.getParent().startDirtyListener();
            if (this.designEditor.getModel() != null) {
                this.designEditor.getModel().registerDOMListener();
            }
            if (context != null) {
                context.ensureUniqueID((AbstractCamelModelElement)context);
            }
        }
    }

    public IFeatureProvider getFeatureProvider() {
        return this.featureProvider;
    }

    public Resource getCreatedResource() {
        return this.createdResource;
    }

    public Diagram getDiagram() {
        return this.diagram;
    }
}

