/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.commands;

import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.fusesource.ide.camel.editor.CamelDesignEditor;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelContextElement;

public class UpdateCommand
extends RecordingCommand {
    private final CamelDesignEditor designEditor;
    private AbstractCamelModelElement node;

    public UpdateCommand(CamelDesignEditor designEditor, TransactionalEditingDomain editingDomain, AbstractCamelModelElement node) {
        super(editingDomain);
        this.designEditor = designEditor;
        this.node = node;
    }

    protected void doExecute() {
        AbstractCamelModelElement selectedNode;
        AbstractCamelModelElement abstractCamelModelElement = selectedNode = this.node == null ? this.designEditor.getSelectedNode() : this.node;
        if (selectedNode == null) {
            selectedNode = this.designEditor.getModel().getCamelContext();
        }
        this.updateFigure(selectedNode);
    }

    private void updateFigure(AbstractCamelModelElement node) {
        Diagram pe;
        if (node == null) {
            return;
        }
        Object object = pe = node instanceof CamelContextElement ? this.designEditor.getDiagramTypeProvider().getDiagram() : this.designEditor.getFeatureProvider().getPictogramElementForBusinessObject((Object)node);
        if (pe == null) {
            return;
        }
        AbstractCamelModelElement bo2 = this.designEditor.getModel().findNode(node.getId());
        if (pe != null && bo2 != null && !bo2.getXmlNode().isEqualNode(node.getXmlNode())) {
            this.designEditor.getFeatureProvider().link((PictogramElement)pe, (Object)bo2);
        }
        UpdateContext ctx = new UpdateContext((PictogramElement)pe);
        IUpdateFeature updateFeature = this.designEditor.getFeatureProvider().getUpdateFeature((IUpdateContext)ctx);
        updateFeature.update((IUpdateContext)ctx);
        for (AbstractCamelModelElement elem : node.getChildElements()) {
            this.updateFigure(elem);
        }
    }
}

