/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.dialogs;

import java.util.Arrays;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.fusesource.ide.camel.editor.dialogs.GlobalConfigCategoryItem;
import org.fusesource.ide.camel.editor.dialogs.GlobalConfigElementItem;
import org.fusesource.ide.camel.editor.globalconfiguration.CamelGlobalConfigEditor;
import org.fusesource.ide.foundation.ui.util.Selections;

public class GlobalConfigElementsSelectionDialog
extends SelectionDialog {
    private Object inputElement;
    private CamelGlobalConfigEditor parentEditor;
    private StyledCellLabelProvider labelProvider;
    private IStructuredContentProvider contentProvider;
    private TreeViewer listViewer;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;

    public GlobalConfigElementsSelectionDialog(Shell parentShell, CamelGlobalConfigEditor parentEditor, Object input, IStructuredContentProvider contentProvider, StyledCellLabelProvider labelProvider, String title, String message) {
        super(parentShell);
        this.parentEditor = parentEditor;
        this.setTitle(title);
        this.setMessage(message);
        this.inputElement = input;
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        this.createMessageArea(composite);
        this.listViewer = new TreeViewer(composite, 2052);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 300;
        this.listViewer.getTree().setLayoutData((Object)data);
        this.listViewer.setAutoExpandLevel(-1);
        this.listViewer.getTree().setHeaderVisible(false);
        this.listViewer.getTree().setLinesVisible(false);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.listViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.listViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof GlobalConfigCategoryItem) {
                    return !((GlobalConfigCategoryItem)element).getChildren().isEmpty();
                }
                return true;
            }
        });
        this.initializeViewer();
        this.listViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)GlobalConfigElementsSelectionDialog.this.listViewer.getSelection();
                if (selection.isEmpty() || !(selection.getFirstElement() instanceof GlobalConfigElementItem)) {
                    GlobalConfigElementsSelectionDialog.this.getButton(0).setEnabled(false);
                    GlobalConfigElementsSelectionDialog.this.setMessage("Please select a global type");
                } else {
                    GlobalConfigElementsSelectionDialog.this.getButton(0).setEnabled(true);
                    GlobalConfigElementsSelectionDialog.this.setMessage(null);
                }
            }
        });
        this.listViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (GlobalConfigElementsSelectionDialog.this.getButton(0).isEnabled()) {
                    GlobalConfigElementsSelectionDialog.this.okPressed();
                }
            }
        });
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected TreeViewer getViewer() {
        return this.listViewer;
    }

    private void initializeViewer() {
        this.listViewer.setInput(this.inputElement);
    }

    protected void okPressed() {
        this.setResult(Arrays.asList(Selections.getFirstSelection((ISelection)this.listViewer.getSelection())));
        super.okPressed();
    }
}

