/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.add;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ManhattanConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.fusesource.ide.camel.editor.commands.DiagramOperations;
import org.fusesource.ide.camel.editor.utils.CamelUtils;
import org.fusesource.ide.camel.editor.utils.StyleUtil;
import org.fusesource.ide.camel.model.service.core.model.CamelElementConnection;
import org.fusesource.ide.preferences.PreferenceManager;

public class AddFlowFeature
extends AbstractAddFeature {
    public static final String DEACTIVATE_LAYOUT = "deactivateLayout";

    public AddFlowFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        return context instanceof IAddConnectionContext && context.getNewObject() instanceof CamelElementConnection;
    }

    public PictogramElement add(IAddContext context) {
        IAddConnectionContext addConContext = (IAddConnectionContext)context;
        CamelElementConnection addedEReference = (CamelElementConnection)context.getNewObject();
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        ManhattanConnection connection = peCreateService.createManhattanConnection(this.getDiagram());
        connection.setStart(addConContext.getSourceAnchor());
        connection.setEnd(addConContext.getTargetAnchor());
        IGaService gaService = Graphiti.getGaService();
        Polyline polyline = gaService.createPolyline((GraphicsAlgorithmContainer)connection);
        polyline.setStyle(StyleUtil.getStyleForEClass(this.getDiagram()));
        polyline.setForeground(this.manageColor(StyleUtil.getColorConstant(PreferenceManager.getInstance().loadPreferenceAsString("diagramConnectionColorPreference"))));
        this.link((PictogramElement)connection, addedEReference);
        ConnectionDecorator textDecorator = peCreateService.createConnectionDecorator((Connection)connection, true, 0.5, true);
        Text text = gaService.createDefaultText(this.getDiagram(), (GraphicsAlgorithmContainer)this.getDiagram().getGraphicsAlgorithm());
        textDecorator.setConnection((Connection)connection);
        text.setStyle(StyleUtil.getStyleForCamelText(this.getDiagram()));
        gaService.setLocation((GraphicsAlgorithm)text, 10, 0);
        CamelElementConnection cfr_ignored_0 = (CamelElementConnection)context.getNewObject();
        ConnectionDecorator cd = peCreateService.createConnectionDecorator((Connection)connection, false, 1.0, true);
        this.createArrow((GraphicsAlgorithmContainer)cd);
        Object deactivateLayout = context.getProperty((Object)DEACTIVATE_LAYOUT);
        if (!Boolean.TRUE.equals(deactivateLayout)) {
            DiagramOperations.layoutDiagram(CamelUtils.getDiagramEditor());
        }
        return connection;
    }

    private Polyline createArrow(GraphicsAlgorithmContainer gaContainer) {
        int[] nArray = new int[8];
        nArray[0] = -10;
        nArray[1] = -5;
        nArray[4] = -10;
        nArray[5] = 5;
        nArray[6] = -8;
        int[] xy = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 3;
        nArray2[1] = 3;
        nArray2[4] = 3;
        nArray2[5] = 3;
        nArray2[6] = 3;
        nArray2[7] = 3;
        int[] beforeAfter = nArray2;
        Polygon polyline = Graphiti.getGaCreateService().createPolygon(gaContainer, xy, beforeAfter);
        polyline.setStyle(StyleUtil.getStyleForPolygon(this.getDiagram()));
        return polyline;
    }
}

