/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.add;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramContainer;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.internal.editor.DiagramEditorDummy;
import org.fusesource.ide.camel.editor.CamelDesignEditor;
import org.fusesource.ide.camel.editor.commands.DiagramOperations;
import org.fusesource.ide.camel.editor.utils.CamelUtils;
import org.fusesource.ide.camel.editor.utils.FigureUIFactory;
import org.fusesource.ide.camel.editor.utils.NodeUtils;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;

public class AddNodeFeature
extends AbstractAddShapeFeature {
    public static final String DEACTIVATE_LAYOUT = "deactivateLayout";

    public AddNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        Object newObject = context.getNewObject();
        if (newObject instanceof AbstractCamelModelElement) {
            if (context.getTargetContainer() instanceof Diagram) {
                String nodeTypeId = ((AbstractCamelModelElement)newObject).getNodeTypeId();
                return "route".equalsIgnoreCase(nodeTypeId) || "rest".equalsIgnoreCase(nodeTypeId) || "restConfiguration".equalsIgnoreCase(nodeTypeId);
            }
            if (this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer()) instanceof AbstractCamelModelElement) {
                AbstractCamelModelElement child;
                AbstractCamelModelElement container = (AbstractCamelModelElement)this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer());
                if (NodeUtils.isValidChild(container, child = (AbstractCamelModelElement)newObject)) {
                    return true;
                }
                AbstractCamelModelElement sourceNode = (AbstractCamelModelElement)this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer());
                AbstractCamelModelElement newNode = (AbstractCamelModelElement)newObject;
                if (sourceNode.getOutputElement() != null) {
                    AbstractCamelModelElement targetNode = sourceNode.getOutputElement();
                    return sourceNode.hasSameParent(newNode) && newNode.hasSameParent(targetNode);
                }
                return sourceNode.hasSameParent(newNode);
            }
        }
        return false;
    }

    public PictogramElement add(IAddContext context) {
        AbstractCamelModelElement addedClass = (AbstractCamelModelElement)context.getNewObject();
        ContainerShape targetContainer = context.getTargetContainer();
        Diagram diagram = Graphiti.getPeService().getDiagramForPictogramElement((PictogramElement)targetContainer);
        String label = addedClass.getDisplayText();
        ContainerShape containerShape = Graphiti.getPeCreateService().createContainerShape(targetContainer, true);
        FigureUIFactory.createFigureUI(context, this.getFeatureProvider(), containerShape, addedClass, diagram, label);
        this.link((PictogramElement)containerShape, addedClass);
        this.layoutPictogramElement((PictogramElement)containerShape);
        Object deactivateLayout = context.getProperty((Object)DEACTIVATE_LAYOUT);
        if (!Boolean.TRUE.equals(deactivateLayout)) {
            IDiagramContainer o_editor = this.getFeatureProvider().getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer();
            CamelDesignEditor editor = null;
            editor = o_editor == null || o_editor instanceof DiagramEditorDummy ? CamelUtils.getDiagramEditor() : (CamelDesignEditor)o_editor;
            DiagramOperations.layoutDiagram(editor);
        }
        return containerShape;
    }

    public boolean hasDoneChanges() {
        return true;
    }
}

