/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.create.ext;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.fusesource.ide.camel.editor.features.create.ext.CreateFigureFeature;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.model.service.core.catalog.components.Component;
import org.fusesource.ide.camel.model.service.core.catalog.eips.Eip;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelEndpoint;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AbstractComponentBasedCreateFigurefeature
extends CreateFigureFeature {
    protected Component component;

    public AbstractComponentBasedCreateFigurefeature(IFeatureProvider fp, String name, String description) {
        super(fp, name, description, (Eip)null);
        this.setEip(this.getEipByName("to"));
    }

    protected void setComponent(Component component) {
        this.component = component;
    }

    @Override
    protected AbstractCamelModelElement createNode(AbstractCamelModelElement parent, boolean createDOMNode) {
        CamelFile camelFile;
        if (this.getEip() != null && (camelFile = parent.getCamelFile()) != null) {
            Element newNode = null;
            Eip determinedEIP = this.determineEIP(parent);
            if (createDOMNode) {
                String prefixNS = parent.getXmlNode() != null ? parent.getXmlNode().getPrefix() : null;
                newNode = camelFile.createElement(determinedEIP.getName(), prefixNS);
            }
            String uri = this.component.getSyntax() != null ? this.component.getSyntax() : String.format("%s:", this.component.getScheme());
            CamelEndpoint ep = new CamelEndpoint(uri);
            ep.setParent(parent);
            ep.setUnderlyingMetaModelObject(determinedEIP);
            if (createDOMNode) {
                ep.setXmlNode((Node)newNode);
                ep.updateXMLNode();
            }
            try {
                this.updateMavenDependencies(this.component.getDependencies());
            }
            catch (CoreException ex) {
                CamelEditorUIActivator.pluginLog().logError("Unable to add the component dependency to the project maven configuration file.", (Throwable)ex);
            }
            return ep;
        }
        return null;
    }
}

