/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.create.ext;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.fusesource.ide.camel.editor.CamelDesignEditor;
import org.fusesource.ide.camel.editor.features.create.ext.CreateFigureFeature;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.model.service.core.catalog.Dependency;
import org.fusesource.ide.camel.model.service.core.catalog.eips.Eip;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelEndpoint;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CreateEndpointFigureFeature
extends CreateFigureFeature {
    private String endpointUri;
    private List<Dependency> deps;

    public CreateEndpointFigureFeature(IFeatureProvider fp, String name, String description, String endpointUri, List<Dependency> deps) {
        super(fp, name, description, (Class<? extends AbstractCamelModelElement>)null);
        this.endpointUri = endpointUri;
        this.deps = deps;
        this.setEip(this.getEipByName("to"));
    }

    @Override
    protected AbstractCamelModelElement createNode(AbstractCamelModelElement parent, boolean createDOMNode) {
        CamelDesignEditor editor = (CamelDesignEditor)this.getDiagramBehavior().getDiagramContainer();
        if (editor.getModel() != null) {
            Element newNode = null;
            Eip determinedEIP = this.determineEIP(parent);
            if (createDOMNode) {
                newNode = editor.getModel().createElement(determinedEIP.getName(), parent != null && parent.getXmlNode() != null ? parent.getXmlNode().getPrefix() : null);
            }
            CamelEndpoint ep = new CamelEndpoint(this.endpointUri);
            ep.setParent(parent);
            ep.setUnderlyingMetaModelObject(determinedEIP);
            if (createDOMNode) {
                ep.setXmlNode((Node)newNode);
                ep.updateXMLNode();
            }
            return ep;
        }
        return null;
    }

    @Override
    protected String getIconName() {
        return new CamelEndpoint(this.endpointUri).getIconName();
    }

    @Override
    public Object[] create(ICreateContext context) {
        if (this.deps != null && !this.deps.isEmpty()) {
            try {
                this.updateMavenDependencies(this.deps);
            }
            catch (CoreException ex) {
                CamelEditorUIActivator.pluginLog().logError("Unable to add the component dependency to the project maven configuration file.", (Throwable)ex);
            }
        }
        return super.create(context);
    }
}

