/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.create.ext;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.features.impl.AbstractCreateFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.fusesource.ide.camel.editor.CamelDesignEditor;
import org.fusesource.ide.camel.editor.features.create.CreateFlowFeature;
import org.fusesource.ide.camel.editor.features.misc.ReconnectNodesFeature;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.editor.provider.ImageProvider;
import org.fusesource.ide.camel.editor.provider.ProviderHelper;
import org.fusesource.ide.camel.editor.provider.ext.PaletteCategoryItemProvider;
import org.fusesource.ide.camel.editor.utils.CamelUtils;
import org.fusesource.ide.camel.editor.utils.DiagramUtils;
import org.fusesource.ide.camel.editor.utils.MavenUtils;
import org.fusesource.ide.camel.editor.utils.NodeUtils;
import org.fusesource.ide.camel.model.service.core.catalog.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.CamelModelFactory;
import org.fusesource.ide.camel.model.service.core.catalog.Dependency;
import org.fusesource.ide.camel.model.service.core.catalog.eips.Eip;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelBasicModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelContextElement;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteElement;
import org.fusesource.ide.foundation.core.util.Strings;
import org.w3c.dom.Element;

public class CreateFigureFeature
extends AbstractCreateFeature
implements PaletteCategoryItemProvider {
    private Eip eip;
    private Class<? extends AbstractCamelModelElement> clazz;

    public CreateFigureFeature(IFeatureProvider fp, String name, String description, Eip eip) {
        super(fp, name, description);
        this.eip = eip;
    }

    public CreateFigureFeature(IFeatureProvider fp, String name, String description, Class<? extends AbstractCamelModelElement> clazz) {
        super(fp, name, description);
        this.clazz = clazz;
    }

    public Eip getEip() {
        return this.eip;
    }

    public void setEip(Eip eip) {
        this.eip = eip;
    }

    public Class<? extends AbstractCamelModelElement> getClazz() {
        return this.clazz;
    }

    @Override
    public String getCategoryName() {
        if (this.eip != null) {
            return ProviderHelper.getCategoryFromEip(this.eip);
        }
        return null;
    }

    @Override
    public PaletteCategoryItemProvider.CATEGORY_TYPE getCategoryType() {
        return PaletteCategoryItemProvider.CATEGORY_TYPE.getCategoryType(this.getCategoryName());
    }

    public boolean canCreate(ICreateContext context) {
        boolean validChoiceDrop;
        AbstractCamelModelElement containerNode;
        ContainerShape container = context.getTargetContainer();
        Object containerBO = this.getBusinessObjectForPictogramElement((PictogramElement)container);
        if (container instanceof Diagram) {
            CamelFile cf = ((CamelDesignEditor)this.getDiagramBehavior().getDiagramContainer()).getModel();
            if (cf.isEmpty()) {
                cf.addChildElement((AbstractCamelModelElement)new CamelContextElement(cf, null));
            }
            if (this.eip != null) {
                return this.eip.canBeAddedToCamelContextDirectly();
            }
            if (this.clazz != null) {
                Object obj = this.newInstance(this.clazz);
                if (obj instanceof AbstractCamelModelElement) {
                    return ((AbstractCamelModelElement)obj).canBeAddedToCamelContextDirectly();
                }
                return false;
            }
        }
        AbstractCamelModelElement abstractCamelModelElement = containerNode = containerBO instanceof AbstractCamelModelElement ? (AbstractCamelModelElement)containerBO : null;
        if (containerNode != null && "choice".equalsIgnoreCase(containerNode.getNodeTypeId()) && !(validChoiceDrop = this.isValidChoiceDrop(containerNode))) {
            return false;
        }
        if (this.isInvalidAction(containerNode)) {
            return false;
        }
        if (containerBO instanceof AbstractCamelModelElement) {
            AbstractCamelModelElement sourceNode = (AbstractCamelModelElement)containerBO;
            if (NodeUtils.isValidChild(sourceNode, this.eip)) {
                return true;
            }
            return sourceNode.getOutputElement() == null || sourceNode.getInputElement() == null;
        }
        return false;
    }

    public String getCreateImageId() {
        String iconName = this.getIconName();
        if (iconName != null) {
            iconName = ImageProvider.getKeyForDiagramIcon(this.getCategoryType().equals((Object)PaletteCategoryItemProvider.CATEGORY_TYPE.COMPONENTS), iconName);
        }
        return iconName;
    }

    public String getCreateLargeImageId() {
        String iconName = this.getIconName();
        if (iconName != null) {
            iconName = ImageProvider.getKeyForDiagramIcon(this.getCategoryType().equals((Object)PaletteCategoryItemProvider.CATEGORY_TYPE.COMPONENTS), iconName);
        }
        return iconName;
    }

    private boolean isValidChoiceDrop(AbstractCamelModelElement choice) {
        Object obj;
        if (this.eip != null) {
            if ("otherwise".equalsIgnoreCase(this.eip.getName()) && choice.getParameter("otherwise") != null) {
                return false;
            }
            return "when".equalsIgnoreCase(this.eip.getName()) || "otherwise".equalsIgnoreCase(this.eip.getName());
        }
        return this.clazz == null || !((obj = this.newInstance(this.clazz)) instanceof AbstractCamelModelElement) || !"otherwise".equalsIgnoreCase(((AbstractCamelModelElement)obj).getNodeTypeId()) || choice.getParameter("otherwise") == null;
    }

    private boolean isInvalidAction(AbstractCamelModelElement containerBO) {
        return this.isOtherwiseDropOnNonChoice(containerBO) || this.isInvalidRouteDrop(containerBO);
    }

    private boolean isInvalidRouteDrop(AbstractCamelModelElement containerBO) {
        return "route".equalsIgnoreCase(this.eip.getName()) && containerBO != null && !"camelContext".equalsIgnoreCase(containerBO.getNodeTypeId());
    }

    private boolean isOtherwiseDropOnNonChoice(AbstractCamelModelElement containerBO) {
        return "otherwise".equalsIgnoreCase(this.eip.getName()) && containerBO != null && !"choice".equalsIgnoreCase(containerBO.getNodeTypeId());
    }

    protected String getIconName() {
        AbstractCamelModelElement node;
        String ret = null;
        if (this.eip != null) {
            ret = this.eip.getName();
        }
        if (ret == null && (node = this.createNode(null, false)) != null) {
            ret = node.getIconName();
        }
        return ret != null ? ret : "generic";
    }

    public Object[] create(ICreateContext context) {
        ContainerShape container = context.getTargetContainer();
        CreateContext ctxNew = null;
        AbstractCamelModelElement node = null;
        AbstractCamelModelElement selectedContainerElement = this.determineContainerElement(container);
        if (this.isAttemptToCreateWiredFigure(selectedContainerElement, context)) {
            node = this.createNode(selectedContainerElement instanceof CamelRouteElement ? selectedContainerElement : selectedContainerElement.getParent(), true);
            if (context.getTargetConnection() == null) {
                selectedContainerElement = selectedContainerElement.getParent();
            }
            ctxNew = new CreateContext();
            ctxNew.setTargetContainer((ContainerShape)this.getFeatureProvider().getAllPictogramElementsForBusinessObject((Object)selectedContainerElement)[0]);
            ctxNew.setTargetConnection(context.getTargetConnection());
            ctxNew.setLocation(context.getX(), context.getY());
        } else {
            node = this.createNode(selectedContainerElement, selectedContainerElement != null);
        }
        if (selectedContainerElement != null && node != null) {
            selectedContainerElement.addChildElement(node);
            node.setParent(selectedContainerElement);
            if (Strings.isBlank((String)node.getId())) {
                node.ensureUniqueID(node);
            }
            this.addNodeToDiagram((ICreateContext)(ctxNew != null ? ctxNew : context), ctxNew != null, node, container);
            NodeUtils.setSelectedNode(node, this.getFeatureProvider());
            return new Object[]{node};
        }
        return new Object[0];
    }

    private void addNodeToDiagram(ICreateContext context, boolean isCreationWithConnections, AbstractCamelModelElement node, ContainerShape container) {
        this.addGraphicalRepresentation((IAreaContext)context, node);
        if (isCreationWithConnections) {
            AbstractCamelModelElement srcNode = (AbstractCamelModelElement)this.getBusinessObjectForPictogramElement((PictogramElement)container);
            if (context.getTargetConnection() != null) {
                this.insertNode(node, context.getTargetConnection());
            } else if (srcNode.getInputElement() == null && srcNode.getOutputElement() != null) {
                this.prependNode(srcNode, node);
            } else {
                this.appendNode(srcNode, node);
            }
        }
        this.getFeatureProvider().getDirectEditingInfo().setActive(true);
    }

    private AbstractCamelModelElement determineContainerElement(ContainerShape container) {
        CamelDesignEditor editor = (CamelDesignEditor)this.getDiagramBehavior().getDiagramContainer();
        if (container instanceof Diagram) {
            return editor.getModel().getCamelContext();
        }
        return (AbstractCamelModelElement)this.getBusinessObjectForPictogramElement((PictogramElement)container);
    }

    private boolean isAttemptToCreateWiredFigure(AbstractCamelModelElement selectedContainer, ICreateContext context) {
        if (selectedContainer != null) {
            Eip underlyingMetaModelObject = selectedContainer.getUnderlyingMetaModelObject();
            return underlyingMetaModelObject != null && !underlyingMetaModelObject.canHaveChildren() || context.getTargetConnection() != null;
        }
        return false;
    }

    private void insertNode(AbstractCamelModelElement newNode, Connection dropTarget) {
        ReconnectionContext reconContext;
        ReconnectNodesFeature reconnectFeature;
        AbstractCamelModelElement srcNode = NodeUtils.getNode(this.getFeatureProvider(), dropTarget.getStart());
        AbstractCamelModelElement destNode = newNode;
        AbstractCamelModelElement oldNode = srcNode.getOutputElement();
        PictogramElement destState = this.getFeatureProvider().getPictogramElementForBusinessObject((Object)destNode);
        PictogramElement oldState = this.getFeatureProvider().getPictogramElementForBusinessObject((Object)oldNode);
        Anchor oldAnchor = DiagramUtils.getAnchor(oldState);
        Anchor destAnchor = DiagramUtils.getAnchor(destState);
        if (oldNode != null && (reconnectFeature = new ReconnectNodesFeature(this.getFeatureProvider())).canExecute((IContext)(reconContext = new ReconnectionContext(dropTarget, oldAnchor, destAnchor, null)))) {
            reconnectFeature.execute((IContext)reconContext);
            this.appendNode(newNode, oldNode);
        }
    }

    private void prependNode(AbstractCamelModelElement dropTarget, AbstractCamelModelElement newNode) {
        this.appendNode(newNode, dropTarget);
    }

    private void appendNode(AbstractCamelModelElement dropTarget, AbstractCamelModelElement newNode) {
        PictogramElement srcState = this.getFeatureProvider().getPictogramElementForBusinessObject((Object)dropTarget);
        PictogramElement destState = this.getFeatureProvider().getPictogramElementForBusinessObject((Object)newNode);
        Anchor srcAnchor = DiagramUtils.getAnchor(srcState);
        Anchor destAnchor = DiagramUtils.getAnchor(destState);
        CreateFlowFeature createFeature = new CreateFlowFeature(this.getFeatureProvider());
        CreateConnectionContext connectContext = new CreateConnectionContext();
        connectContext.setSourcePictogramElement(srcState);
        connectContext.setTargetPictogramElement(destState);
        if (destAnchor != null) {
            connectContext.setSourceAnchor(srcAnchor);
            connectContext.setTargetAnchor(destAnchor);
            if (createFeature.canCreate((ICreateConnectionContext)connectContext)) {
                createFeature.execute((IContext)connectContext);
            }
        }
    }

    protected AbstractCamelModelElement createNode(AbstractCamelModelElement parent, boolean createDOMNode) {
        Object o;
        CamelDesignEditor editor;
        if (this.eip != null && (editor = (CamelDesignEditor)this.getDiagramBehavior().getDiagramContainer()).getModel() != null) {
            Element newNode = null;
            if (createDOMNode) {
                String nodeTypeId = this.getEip().getName();
                String namespace = parent != null && parent.getXmlNode() != null ? parent.getXmlNode().getPrefix() : null;
                newNode = editor.getModel().createElement(nodeTypeId, namespace);
            }
            if (this.eip.getName().equalsIgnoreCase("route")) {
                return new CamelRouteElement(parent, newNode);
            }
            return new CamelBasicModelElement(parent, newNode);
        }
        if (this.clazz != null && (o = this.newInstance(this.clazz)) instanceof AbstractCamelModelElement) {
            AbstractCamelModelElement e = (AbstractCamelModelElement)o;
            e.setParent(parent);
            return e;
        }
        return null;
    }

    protected Object newInstance(Class<?> aClass) {
        try {
            return aClass.newInstance();
        }
        catch (Exception e) {
            CamelEditorUIActivator.pluginLog().logWarning("Failed to create instance of " + aClass.getName() + ". " + e, (Throwable)e);
            return null;
        }
    }

    public void updateMavenDependencies(List<Dependency> compDeps) throws CoreException {
        String facetVersion;
        String m2CamelVersion;
        CamelDesignEditor editor = (CamelDesignEditor)this.getDiagramBehavior().getDiagramContainer();
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)editor.getWorkspaceProject());
        IProjectFacet camelFacet = ProjectFacetsManager.getProjectFacet((String)"jst.camel");
        if (fproj != null && fproj.hasProjectFacet(camelFacet) && (m2CamelVersion = CamelModelFactory.getCompatibleCamelVersion((String)(facetVersion = fproj.getInstalledVersion(camelFacet).getVersionString()))) != null) {
            this.updateDepsVersion(compDeps, m2CamelVersion);
            new MavenUtils().updateMavenDependencies(compDeps);
        }
    }

    private void updateDepsVersion(List<Dependency> compDeps, String newCamelVersion) {
        for (Dependency dep : compDeps) {
            if (!dep.getGroupId().equalsIgnoreCase("org.apache.camel") || !dep.getArtifactId().toLowerCase().startsWith("camel-")) continue;
            dep.setVersion(newCamelVersion);
        }
    }

    public Eip getEipByName(String name) {
        String prjCamelVersion = CamelUtils.getCurrentProjectCamelVersion();
        CamelModel model = CamelModelFactory.getModelForVersion((String)prjCamelVersion);
        if (model == null) {
            return null;
        }
        Eip eip = model.getEipModel().getEIPByName(name);
        return eip;
    }

    protected Eip determineEIP(AbstractCamelModelElement parent) {
        if (this.eip == null || "to".equals(this.eip.getName()) && parent instanceof CamelRouteElement && parent.getChildElements().isEmpty()) {
            return this.getEipByName("from");
        }
        return this.getEip();
    }
}

