/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.custom;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.fusesource.ide.camel.editor.CamelDesignEditor;
import org.fusesource.ide.camel.editor.utils.CamelUtils;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelContextElement;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteElement;

public class GoIntoContainerFeature
extends AbstractCustomFeature {
    private PictogramElement lastPE;

    public GoIntoContainerFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean isAvailable(IContext context) {
        if (context instanceof ICustomContext) {
            this.lastPE = ((ICustomContext)context).getPictogramElements()[0];
        }
        return super.isAvailable(context);
    }

    public boolean canExecute(ICustomContext context) {
        Object bo;
        boolean ret = false;
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof AbstractCamelModelElement) {
            AbstractCamelModelElement cme = (AbstractCamelModelElement)bo;
            return this.isAllowedToExecute(cme);
        }
        return ret;
    }

    private boolean isAllowedToExecute(AbstractCamelModelElement cme) {
        CamelDesignEditor editor = (CamelDesignEditor)this.getDiagramBehavior().getDiagramContainer();
        return editor != null && (this.isGoInto(cme, editor) || this.isGoUp(cme, editor));
    }

    private boolean isGoUp(AbstractCamelModelElement cme, CamelDesignEditor editor) {
        return cme instanceof CamelRouteElement && cme.equals(editor.getSelectedContainer());
    }

    private boolean isGoInto(AbstractCamelModelElement cme, CamelDesignEditor editor) {
        return "route".equalsIgnoreCase(cme.getNodeTypeId()) && editor.getSelectedContainer() instanceof CamelContextElement && cme.getCamelContext().getChildElements().size() > 1;
    }

    public void execute(ICustomContext context) {
        Object bo;
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof AbstractCamelModelElement) {
            AbstractCamelModelElement cme = (AbstractCamelModelElement)bo;
            CamelDesignEditor editor = CamelUtils.getDiagramEditor();
            if (this.isGoInto(cme, editor)) {
                editor.setSelectedContainer(cme);
            } else {
                editor.setSelectedContainer((AbstractCamelModelElement)cme.getCamelContext());
            }
        }
    }

    public String getName() {
        AbstractCamelModelElement cme;
        Object bo;
        if (this.lastPE != null && (bo = this.getBusinessObjectForPictogramElement(this.lastPE)) instanceof AbstractCamelModelElement && !this.isGoInto(cme = (AbstractCamelModelElement)bo, CamelUtils.getDiagramEditor())) {
            return "Show Camel Context";
        }
        return "Go Into";
    }

    public String getDescription() {
        AbstractCamelModelElement cme;
        Object bo;
        if (this.lastPE != null && (bo = this.getBusinessObjectForPictogramElement(this.lastPE)) instanceof AbstractCamelModelElement && !this.isGoInto(cme = (AbstractCamelModelElement)bo, CamelUtils.getDiagramEditor())) {
            return "Show the whole Camel Context";
        }
        return "Drills into the selected container node...";
    }

    public String getImageId() {
        AbstractCamelModelElement cme;
        Object bo;
        if (this.lastPE != null && (bo = this.getBusinessObjectForPictogramElement(this.lastPE)) instanceof AbstractCamelModelElement && !this.isGoInto(cme = (AbstractCamelModelElement)bo, CamelUtils.getDiagramEditor())) {
            return "org.fusesource.ide.icons.up_nav";
        }
        return "org.fusesource.ide.icons.outline.tree";
    }
}

