/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.custom;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.CompoundDirectedGraphLayout;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.graphics.Rectangle;
import org.fusesource.ide.camel.editor.features.custom.CollapseFeature;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.preferences.PreferenceManager;

public class LayoutDiagramFeature
extends AbstractCustomFeature {
    private static final int PADDING_H = 10;
    private static final int PADDING_V = 10;
    private static final int SPACING_H = 10;
    private static final int SPACING_V = 40;

    public LayoutDiagramFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getDescription() {
        return "Layout diagram with GEF Layouter";
    }

    public String getName() {
        return "&Layout Diagram";
    }

    public boolean canExecute(ICustomContext context) {
        return true;
    }

    public boolean isAvailable(IContext context) {
        ICustomContext cc = (ICustomContext)context;
        Object _pe = cc.getPictogramElements()[0] instanceof Connection ? ((Connection)cc.getPictogramElements()[0]).getStart().getParent() : cc.getPictogramElements()[0];
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)_pe);
        return bo != null && bo instanceof AbstractCamelModelElement && ((AbstractCamelModelElement)bo).getUnderlyingMetaModelObject().canHaveChildren();
    }

    public void execute(ICustomContext context) {
        this.doLayout(context.getPictogramElements()[0]);
    }

    private void doLayout(PictogramElement selectedContainer) {
        CompoundDirectedGraph graph = this.mapDiagramToGraph(selectedContainer);
        graph.setDefaultPadding(new Insets(10, 10, 10, 10));
        CompoundDirectedGraphLayout layout = new CompoundDirectedGraphLayout();
        int direction = PreferenceManager.getInstance().loadPreferenceAsInt("diagramLayoutOrientationPreference");
        graph.setDirection(direction);
        layout.visit((DirectedGraph)graph);
        this.mapGraphCoordinatesToDiagram(graph);
        this.resizeContainer(selectedContainer);
    }

    private CompoundDirectedGraph mapDiagramToGraph(PictogramElement container) {
        HashMap<Shape, Node> shapeToNode = new HashMap<Shape, Node>();
        EdgeList edgeList = new EdgeList();
        NodeList nodeList = new NodeList();
        CompoundDirectedGraph dg = new CompoundDirectedGraph();
        if (container == null) {
            return dg;
        }
        if (this.isExpanded(container)) {
            EList children = ((ContainerShape)container).getChildren();
            for (Shape shape : children) {
                Node node = new Node();
                GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
                node.x = ga.getX();
                node.y = ga.getY();
                node.width = ga.getWidth();
                node.height = ga.getHeight();
                node.data = shape;
                shapeToNode.put(shape, node);
                nodeList.add((Object)node);
            }
        }
        EList connections = this.getDiagram().getConnections();
        for (Connection connection : connections) {
            AnchorContainer source = connection.getStart().getParent();
            AnchorContainer target = connection.getEnd().getParent();
            if (!shapeToNode.containsKey(source) || !shapeToNode.containsKey(target)) continue;
            Edge edge = new Edge((Node)shapeToNode.get(source), (Node)shapeToNode.get(target));
            edge.data = connection;
            edgeList.add((Object)edge);
        }
        dg.nodes = nodeList;
        dg.edges = edgeList;
        return dg;
    }

    private boolean isExpanded(PictogramElement container) {
        String collapsedPropertyValue = Graphiti.getPeService().getPropertyValue((PropertyContainer)container, CollapseFeature.PROP_COLLAPSED_STATE);
        return collapsedPropertyValue == null || "false".equals(collapsedPropertyValue);
    }

    private void resizeContainer(PictogramElement containerPE) {
        if (containerPE == null || containerPE.getGraphicsAlgorithm() == null) {
            return;
        }
        Rectangle maxContentArea = new Rectangle(containerPE.getGraphicsAlgorithm().getX(), containerPE.getGraphicsAlgorithm().getY(), containerPE.getGraphicsAlgorithm().getWidth(), containerPE.getGraphicsAlgorithm().getHeight());
        EList children = ((ContainerShape)containerPE).getChildren();
        if (this.isExpanded(containerPE) && children.size() > 0) {
            int newWidth = 0;
            int newHeight = 0;
            for (Shape shape : children) {
                if (this.isExpanded((PictogramElement)shape)) {
                    this.resizeContainer((PictogramElement)shape);
                }
                GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
                int w = ga.getX() + ga.getWidth() + 10 + 10;
                int h = ga.getY() + ga.getHeight() + 10 + 10;
                if (w > newWidth) {
                    newWidth = w;
                }
                if (h <= newHeight) continue;
                newHeight = h;
            }
            maxContentArea.width = newWidth;
            maxContentArea.height = newHeight;
        } else {
            maxContentArea.height = 34;
        }
        ResizeShapeContext cc = new ResizeShapeContext((Shape)((ContainerShape)containerPE));
        cc.setX(maxContentArea.x);
        cc.setY(maxContentArea.y);
        cc.setWidth(maxContentArea.width);
        cc.setHeight(maxContentArea.height);
        this.getFeatureProvider().getResizeShapeFeature((IResizeShapeContext)cc).execute((IContext)cc);
    }

    private Diagram mapGraphCoordinatesToDiagram(CompoundDirectedGraph graph) {
        NodeList myNodes = new NodeList();
        myNodes.addAll((Collection)graph.nodes);
        myNodes.addAll((Collection)graph.subgraphs);
        for (Object object : myNodes) {
            Node node = (Node)object;
            Shape shape = (Shape)node.data;
            shape.getGraphicsAlgorithm().setX(node.x + 10);
            shape.getGraphicsAlgorithm().setY(node.y + 40);
            shape.getGraphicsAlgorithm().setWidth(node.width);
            shape.getGraphicsAlgorithm().setHeight(node.height);
        }
        return null;
    }
}

