/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.custom;

import java.util.UUID;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramContainer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fusesource.ide.camel.editor.CamelDesignEditor;
import org.fusesource.ide.camel.editor.utils.CamelUtils;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.launcher.debug.util.CamelDebugUtils;

public class SetEndpointBreakpointFeature
extends AbstractCustomFeature {
    public SetEndpointBreakpointFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void execute(ICustomContext context) {
        PictogramElement _pe = context.getPictogramElements()[0] instanceof Connection ? ((Connection)context.getPictogramElements()[0]).getStart().getParent() : context.getPictogramElements()[0];
        Object bo = this.getBusinessObjectForPictogramElement(_pe);
        IResource resource = this.getResource();
        if (bo instanceof AbstractCamelModelElement) {
            AbstractCamelModelElement _ep = (AbstractCamelModelElement)bo;
            try {
                Boolean userWantsUpdate = null;
                IFile contextFile = this.getContextFile();
                String fileName = contextFile.getName();
                String projectName = contextFile.getProject().getName();
                if ((Strings.isBlank((String)_ep.getCamelContext().getId()) || Strings.isBlank((String)_ep.getId())) && (userWantsUpdate = Boolean.valueOf(this.askForIDUpdate(_ep))).booleanValue()) {
                    if (Strings.isBlank((String)_ep.getCamelContext().getId())) {
                        String newContextId = "context-" + UUID.randomUUID().toString();
                        _ep.getCamelContext().setId(newContextId);
                    }
                    boolean foundUniqueId = false;
                    if (Strings.isBlank((String)_ep.getId())) {
                        String newNodeId = null;
                        while (!foundUniqueId) {
                            newNodeId = _ep.getNewID();
                            if (((CamelDesignEditor)this.getDiagramBehavior().getDiagramContainer()).getModel().findNode(newNodeId) != null) continue;
                            foundUniqueId = true;
                        }
                        if (!Strings.isBlank(newNodeId)) {
                            _ep.setId(newNodeId);
                        } else {
                            throw new CoreException((IStatus)new Status(4, "org.fusesource.ide.camel.editor", "Unable to determine a unique ID for node " + _ep));
                        }
                    }
                }
                if (userWantsUpdate == null || userWantsUpdate.booleanValue()) {
                    CamelDebugUtils.createAndRegisterEndpointBreakpoint((IResource)resource, (AbstractCamelModelElement)_ep, (String)projectName, (String)fileName);
                }
            }
            catch (CoreException e) {
                IDiagramContainer container = this.getDiagramBehavior().getDiagramContainer();
                Shell shell = container instanceof CamelDesignEditor ? ((CamelDesignEditor)container).getEditorSite().getShell() : Display.getCurrent().getActiveShell();
                MessageDialog.openError((Shell)shell, (String)"Error on adding breakpoint", (String)e.getStatus().getMessage());
                return;
            }
        }
        this.getDiagramBehavior().refresh();
        this.getDiagramBehavior().refreshRenderingDecorators(_pe);
    }

    public String getName() {
        return "Set Breakpoint";
    }

    public String getDescription() {
        return "Sets a breakpoint on the selected endpoint node";
    }

    public String getImageId() {
        return "org.fusesource.ide.icons.reddot";
    }

    public boolean isAvailable(IContext context) {
        ICustomContext cc = (ICustomContext)context;
        Object _pe = cc.getPictogramElements()[0] instanceof Connection ? ((Connection)cc.getPictogramElements()[0]).getStart().getParent() : cc.getPictogramElements()[0];
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)_pe);
        if (bo instanceof AbstractCamelModelElement) {
            AbstractCamelModelElement _ep = (AbstractCamelModelElement)bo;
            IFile contextFile = this.getContextFile();
            String fileName = contextFile.getName();
            String projectName = contextFile.getProject().getName();
            return _ep.supportsBreakpoint() && CamelDebugUtils.getBreakpointForSelection((String)_ep.getId(), (String)fileName, (String)projectName) == null;
        }
        return false;
    }

    public boolean canExecute(ICustomContext context) {
        return this.isAvailable((IContext)context);
    }

    protected IResource getResource() {
        IDiagramContainer container = this.getDiagramBehavior().getDiagramContainer();
        if (container instanceof CamelDesignEditor) {
            return ((CamelDesignEditor)container).getModel().getResource();
        }
        return null;
    }

    protected PictogramElement getPEFromContext(ICustomContext context) {
        return context.getPictogramElements()[0] instanceof Connection ? ((Connection)context.getPictogramElements()[0]).getStart().getParent() : context.getPictogramElements()[0];
    }

    protected IFile getContextFile() {
        return CamelUtils.getDiagramEditor().asFileEditorInput(CamelUtils.getDiagramEditor().getEditorInput()).getFile();
    }

    protected boolean askForIDUpdate(AbstractCamelModelElement node) {
        IDiagramContainer container = this.getDiagramBehavior().getDiagramContainer();
        Shell shell = container instanceof CamelDesignEditor ? ((CamelDesignEditor)container).getEditorSite().getShell() : Display.getCurrent().getActiveShell();
        return MessageDialog.openConfirm((Shell)shell, (String)"Please confirm...", (String)"Debugging is only possible if the context and the nodes which have breakpoints have a unique ID set. Do you want to generate the ID values now?\n\n(Warning: All changes in the editor will be written to the context file!)");
    }

    public boolean hasDoneChanges() {
        return false;
    }

    protected void saveEditor() throws CoreException {
        IDiagramContainer container = this.getDiagramBehavior().getDiagramContainer();
        CamelDesignEditor editor = null;
        if (!(container instanceof CamelDesignEditor)) {
            throw new CoreException((IStatus)new Status(4, "org.fusesource.ide.camel.editor", "Can't find the editor to set the breakpoint!"));
        }
        editor = (CamelDesignEditor)container;
        editor.getParent().doSave((IProgressMonitor)new NullProgressMonitor());
    }
}

