/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.globalconfiguration;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.fusesource.ide.camel.editor.CamelEditor;
import org.fusesource.ide.camel.editor.commands.ShowPropertiesViewHandler;
import org.fusesource.ide.camel.editor.dialogs.GlobalConfigCategoryItem;
import org.fusesource.ide.camel.editor.dialogs.GlobalConfigElementItem;
import org.fusesource.ide.camel.editor.dialogs.GlobalConfigElementsSelectionDialog;
import org.fusesource.ide.camel.editor.dialogs.GlobalConfigSupport;
import org.fusesource.ide.camel.editor.dialogs.provider.GlobalConfigElementsDialogContentProvider;
import org.fusesource.ide.camel.editor.dialogs.provider.GlobalConfigElementsDialogLabelProvider;
import org.fusesource.ide.camel.editor.globalconfiguration.GlobalConfigContentProvider;
import org.fusesource.ide.camel.editor.globalconfiguration.GlobalConfigLabelProvider;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.editor.internal.UIMessages;
import org.fusesource.ide.camel.editor.provider.ext.GlobalConfigurationTypeWizard;
import org.fusesource.ide.camel.editor.provider.ext.ICustomGlobalConfigElementContribution;
import org.fusesource.ide.camel.editor.utils.MavenUtils;
import org.fusesource.ide.camel.model.service.core.catalog.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.CamelModelFactory;
import org.fusesource.ide.camel.model.service.core.catalog.Dependency;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelBasicModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelEndpoint;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.camel.model.service.core.model.GlobalDefinitionCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.ICamelModelListener;
import org.fusesource.ide.camel.validation.ValidationFactory;
import org.fusesource.ide.camel.validation.diagram.BasicNodeValidator;
import org.fusesource.ide.foundation.core.util.CamelUtils;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.foundation.ui.util.Selections;
import org.fusesource.ide.foundation.ui.util.Widgets;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CamelGlobalConfigEditor
extends EditorPart
implements ICamelModelListener {
    public static final String GLOBAL_ELEMENTS_PROVIDER_EXT_POINT_ID = "org.fusesource.ide.editor.globalConfigContributor";
    public static final String CATEGORY_ELEMENT = "GlobalConfigCategory";
    public static final String TYPE_ELEMENT = "GlobalConfigElement";
    public static final String FUSE_CAT_ID = "org.fusesource.ide.camel.editor.globalconfig.FUSE_CATEGORY";
    public static final String DEFAULT_CAT_ID = "org.fusesource.ide.camel.editor.globalconfig.DEFAULT_CATEGORY";
    public static final String GLOBAL_ELEMENTS_ICON_ATTR = "icon";
    public static final String GLOBAL_ELEMENTS_ID_ATTR = "id";
    public static final String GLOBAL_ELEMENTS_NAME_ATTR = "name";
    public static final String GLOBAL_ELEMENTS_CATEGORY_ATTR = "category";
    private CamelEditor parentEditor;
    private Composite parent;
    private TreeViewer treeViewer;
    private Button btnAdd;
    private Button btnModify;
    private Button btnDelete;
    private List<GlobalConfigElementItem> elementContributions = new ArrayList<GlobalConfigElementItem>();
    private List<GlobalConfigCategoryItem> categoryContributions = new ArrayList<GlobalConfigCategoryItem>();
    private HashMap<String, ArrayList<Object>> model;
    private Set<Image> extensionPointIcons = new HashSet<Image>();

    public CamelGlobalConfigEditor(CamelEditor parentEditor) {
        this.parentEditor = parentEditor;
    }

    public void doSave(IProgressMonitor monitor) {
        this.parentEditor.doSave(monitor);
    }

    public void doSaveAs() {
        this.parentEditor.doSaveAs();
    }

    public void init(IEditorSite editorSite, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)editorSite);
        this.setInput(input);
        this.determineExtensions();
    }

    public boolean isDirty() {
        return this.parentEditor.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite p) {
        this.parent = new Composite(p, 0x800000);
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 10;
        this.parent.setLayout((Layout)gl);
        this.createTreeViewer();
        this.createRightButtons();
        this.categoryContributions.sort(new Comparator<GlobalConfigCategoryItem>(){

            @Override
            public int compare(GlobalConfigCategoryItem o1, GlobalConfigCategoryItem o2) {
                if (CamelGlobalConfigEditor.DEFAULT_CAT_ID.equals(o1.getId())) {
                    return 1;
                }
                if (CamelGlobalConfigEditor.DEFAULT_CAT_ID.equals(o2.getId())) {
                    return -1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.reload();
        this.treeViewer.setInput(this.getModel());
        CamelFile designEditorModel = this.parentEditor.getDesignEditor().getModel();
        if (designEditorModel != null) {
            designEditorModel.addModelListener((ICamelModelListener)this);
        }
        this.treeViewer.expandAll();
    }

    private void createTreeViewer() {
        this.treeViewer = new TreeViewer(this.parent, 2820);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setContentProvider((IContentProvider)new GlobalConfigContentProvider(this));
        ILabelDecorator labelDecorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        DecoratingStyledCellLabelProvider labelProvider = new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new GlobalConfigLabelProvider(this), labelDecorator, null);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 10));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selObj = Selections.getFirstSelection((ISelection)event.getSelection());
                if (selObj != null) {
                    CamelGlobalConfigEditor.this.btnModify.setEnabled(CamelGlobalConfigEditor.this.supportsEdit(selObj));
                    CamelGlobalConfigEditor.this.btnDelete.setEnabled(CamelGlobalConfigEditor.this.supportsDelete(selObj));
                } else {
                    CamelGlobalConfigEditor.this.btnModify.setEnabled(false);
                    CamelGlobalConfigEditor.this.btnDelete.setEnabled(false);
                }
            }
        });
        this.treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof String) {
                    return !CamelGlobalConfigEditor.this.getModel().get(element).isEmpty();
                }
                return true;
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
    }

    private void createRightButtons() {
        this.createAddButton();
        this.createEditButton();
        this.createDeleteButton();
    }

    private void createDeleteButton() {
        this.btnDelete = new Button(this.parent, 0x800008);
        this.btnDelete.setText(UIMessages.globalElementsTabDeleteButtonLabel);
        this.btnDelete.setToolTipText(UIMessages.globalElementsTabDeleteButtonTooltip);
        this.btnDelete.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CamelGlobalConfigEditor.this.deleteEntries();
            }
        });
    }

    private void createEditButton() {
        this.btnModify = new Button(this.parent, 0x800008);
        this.btnModify.setText(UIMessages.globalElementsTabEditButtonLabel);
        this.btnModify.setToolTipText(UIMessages.globalElementsTabEditButtonTooltip);
        this.btnModify.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        this.btnModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CamelGlobalConfigEditor.this.modifyEntry();
            }
        });
    }

    private void createAddButton() {
        this.btnAdd = new Button(this.parent, 0x800008);
        this.btnAdd.setText(UIMessages.globalElementsTabAddButtonLabel);
        this.btnAdd.setToolTipText(UIMessages.globalElementsTabAddButtonTooltip);
        GridData gd = new GridData(4, 1, false, false, 1, 1);
        gd.minimumWidth = 120;
        gd.widthHint = 120;
        this.btnAdd.setLayoutData((Object)gd);
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CamelGlobalConfigEditor.this.createNewEntry();
            }
        });
        this.btnAdd.setEnabled(!this.getElementContributions().isEmpty());
    }

    public void dispose() {
        if (this.parentEditor != null && this.parentEditor.getDesignEditor() != null && this.parentEditor.getDesignEditor().getModel() != null) {
            this.parentEditor.getDesignEditor().getModel().removeModelListener((ICamelModelListener)this);
        }
        for (Image image : this.extensionPointIcons) {
            image.dispose();
        }
        super.dispose();
    }

    public void setFocus() {
        Display.getDefault().asyncExec(() -> this.reload());
        this.treeViewer.getTree().setFocus();
    }

    public void modelChanged() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (CamelGlobalConfigEditor.this.parentEditor != null && ((Object)((Object)CamelGlobalConfigEditor.this)).equals(CamelGlobalConfigEditor.this.parentEditor.getActiveEditor())) {
                    CamelGlobalConfigEditor.this.reload();
                    CamelGlobalConfigEditor.this.parentEditor.setDirtyFlag(true);
                }
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private void determineExtensions() {
        try {
            var5_2 = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor("org.fusesource.ide.editor.globalConfigContributor");
            var4_3 = extensions.length;
            var3_4 = 0;
            while (var3_4 < var4_3) {
                e = var5_2[var3_4];
                if (e.getName().equals("GlobalConfigCategory")) {
                    this.determineCategoryExtension(e);
                } else if (e.getName().equals("GlobalConfigElement")) {
                    this.determineGlobalConfigExtension(e);
                }
                ++var3_4;
            }
        }
        finally {
            ** for (cat : this.categoryContributions)
        }
lbl-1000:
        // 3 sources

        {
            for (GlobalConfigElementItem elem : this.getElementContributions()) {
                elementCategoryId = elem.getCategoryId();
                categoryId = cat.getId();
                if ((elementCategoryId.trim().length() >= 1 || !categoryId.equals("org.fusesource.ide.camel.editor.globalconfig.FUSE_CATEGORY")) && (!elementCategoryId.equals(categoryId) || cat.getChildren().contains(elem))) continue;
                cat.getChildren().add(elem);
            }
            continue;
        }
lbl25:
        // 1 sources

    }

    private void determineGlobalConfigExtension(IConfigurationElement e) {
        try {
            Object o = e.createExecutableExtension("class");
            if (o instanceof ICustomGlobalConfigElementContribution) {
                ICustomGlobalConfigElementContribution globalElementHandler = (ICustomGlobalConfigElementContribution)o;
                String id = e.getAttribute(GLOBAL_ELEMENTS_ID_ATTR);
                String name = e.getAttribute(GLOBAL_ELEMENTS_NAME_ATTR);
                String catId = e.getAttribute(GLOBAL_ELEMENTS_CATEGORY_ATTR);
                GlobalConfigElementItem item = new GlobalConfigElementItem();
                item.setContributor(globalElementHandler);
                item.setId(id);
                item.setName(name);
                item.setCategoryId(catId);
                this.setIconIfProvided(e, item);
                this.getElementContributions().add(item);
            }
        }
        catch (Exception ex) {
            CamelEditorUIActivator.pluginLog().logError((Throwable)ex);
        }
    }

    private void determineCategoryExtension(IConfigurationElement e) {
        try {
            String id = e.getAttribute(GLOBAL_ELEMENTS_ID_ATTR);
            String name = e.getAttribute(GLOBAL_ELEMENTS_NAME_ATTR);
            GlobalConfigCategoryItem item = new GlobalConfigCategoryItem();
            item.setId(id);
            item.setName(name);
            this.setIconIfProvided(e, item);
            this.categoryContributions.add(item);
        }
        catch (Exception ex) {
            CamelEditorUIActivator.pluginLog().logError((Throwable)ex);
        }
    }

    private void setIconIfProvided(IConfigurationElement e, GlobalConfigSupport item) throws IOException {
        String icon = e.getAttribute(GLOBAL_ELEMENTS_ICON_ATTR);
        if (!Strings.isBlank((String)icon)) {
            String implementorBundle = e.getDeclaringExtension().getContributor().getName();
            Bundle implBundle = Platform.getBundle((String)implementorBundle);
            URL iconUrl = implBundle.getResource(icon);
            Image image = new Image((Device)Display.getCurrent(), iconUrl.openConnection().getInputStream());
            item.setIcon(image);
            this.extensionPointIcons.add(image);
        }
    }

    GlobalConfigCategoryItem getCategoryForId(String catId) {
        for (GlobalConfigCategoryItem cat : this.categoryContributions) {
            if (!cat.getId().equals(catId)) continue;
            return cat;
        }
        return null;
    }

    private ICustomGlobalConfigElementContribution getExtensionForElement(AbstractCamelModelElement cme) {
        IConfigurationElement[] extensions;
        ICustomGlobalConfigElementContribution handler = null;
        IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(GLOBAL_ELEMENTS_PROVIDER_EXT_POINT_ID);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            if (TYPE_ELEMENT.equals(e.getName())) {
                try {
                    ICustomGlobalConfigElementContribution globalElementHandler;
                    Object o = e.createExecutableExtension("class");
                    if (o instanceof ICustomGlobalConfigElementContribution && (globalElementHandler = (ICustomGlobalConfigElementContribution)o).canHandle(cme)) {
                        handler = globalElementHandler;
                        break;
                    }
                }
                catch (Exception ex) {
                    CamelEditorUIActivator.pluginLog().logError((Throwable)ex);
                }
            }
            ++n2;
        }
        return handler;
    }

    public void reload() {
        Object selection;
        this.buildModel();
        if (!Widgets.isDisposed((Viewer)this.treeViewer)) {
            selection = this.treeViewer.getStructuredSelection();
            Object firstElement = selection.getFirstElement();
            String selectedId = null;
            if (firstElement instanceof AbstractCamelModelElement) {
                selectedId = ((AbstractCamelModelElement)firstElement).getId();
            }
            this.treeViewer.setInput(this.getModel());
            this.treeViewer.refresh(true);
            this.treeViewer.expandAll();
            this.restoreSelection((IStructuredSelection)selection, selectedId);
        }
        if (this.treeViewer != null && (selection = this.treeViewer.getStructuredSelection().getFirstElement()) instanceof AbstractCamelModelElement) {
            ValidationFactory.getInstance().validate((AbstractCamelModelElement)selection);
        }
    }

    private void restoreSelection(IStructuredSelection selection, String selectedId) {
        if (selectedId != null) {
            block0: for (List list : this.getModel().values()) {
                for (Object object : list) {
                    if (!(object instanceof AbstractCamelModelElement) || !selectedId.equals(((AbstractCamelModelElement)object).getId())) continue;
                    selection = new StructuredSelection(object);
                    continue block0;
                }
            }
        }
        this.treeViewer.setSelection((ISelection)selection);
    }

    private void buildModel() {
        this.model = new HashMap();
        for (GlobalConfigCategoryItem cat : this.categoryContributions) {
            this.getModel().put(cat.getId(), new ArrayList());
        }
        CamelFile cf = this.parentEditor.getDesignEditor().getModel();
        if (cf != null) {
            String catId;
            boolean foundMatch;
            for (GlobalDefinitionCamelModelElement cme : cf.getGlobalDefinitions().values()) {
                foundMatch = false;
                for (GlobalConfigElementItem item : this.getElementContributions()) {
                    String string = catId = item.getCategoryId() != null && item.getCategoryId().trim().length() > 0 ? item.getCategoryId() : DEFAULT_CAT_ID;
                    if (!item.getContributor().canHandle((AbstractCamelModelElement)cme) || !this.getModel().containsKey(catId)) continue;
                    this.getModel().get(catId).add(cme);
                    foundMatch = true;
                    break;
                }
                if (foundMatch) continue;
                this.getModel().get(DEFAULT_CAT_ID).add(cme);
            }
            if (cf.getCamelContext() != null && cf.getCamelContext().getEndpointDefinitions() != null) {
                for (GlobalDefinitionCamelModelElement cme : cf.getCamelContext().getEndpointDefinitions().values()) {
                    foundMatch = false;
                    for (GlobalConfigElementItem item : this.getElementContributions()) {
                        String string = catId = item.getCategoryId() != null && item.getCategoryId().trim().length() > 0 ? item.getCategoryId() : DEFAULT_CAT_ID;
                        if (!item.getContributor().canHandle((AbstractCamelModelElement)cme) || !this.getModel().containsKey(catId)) continue;
                        this.getModel().get(catId).add(cme);
                        foundMatch = true;
                        break;
                    }
                    if (foundMatch) continue;
                    this.getModel().get(DEFAULT_CAT_ID).add(cme);
                }
            }
            if (cf.getCamelContext() != null && cf.getCamelContext().getDataformats() != null) {
                for (GlobalDefinitionCamelModelElement cme : cf.getCamelContext().getDataformats().values()) {
                    foundMatch = false;
                    for (GlobalConfigElementItem item : this.getElementContributions()) {
                        String string = catId = item.getCategoryId() != null && item.getCategoryId().trim().length() > 0 ? item.getCategoryId() : DEFAULT_CAT_ID;
                        if (!item.getContributor().canHandle((AbstractCamelModelElement)cme) || !this.getModel().containsKey(catId)) continue;
                        this.getModel().get(catId).add(cme);
                        foundMatch = true;
                        break;
                    }
                    if (foundMatch) continue;
                    this.getModel().get(DEFAULT_CAT_ID).add(cme);
                }
            }
        }
    }

    private void createNewEntry() {
        Object selObj;
        Object[] selection;
        GlobalConfigElementsSelectionDialog dlg = new GlobalConfigElementsSelectionDialog(Display.getDefault().getActiveShell(), this, this.categoryContributions, (IStructuredContentProvider)new GlobalConfigElementsDialogContentProvider(), new GlobalConfigElementsDialogLabelProvider(), UIMessages.createGlobalElementDialogTitle, UIMessages.createGlobalElementDiaglogText);
        if (dlg.open() == 0 && (selection = dlg.getResult()) != null && selection.length > 0 && (selObj = selection[0]) instanceof GlobalConfigElementItem) {
            GlobalConfigElementItem item = (GlobalConfigElementItem)selObj;
            CamelFile cf = this.parentEditor.getDesignEditor().getModel();
            GlobalConfigurationTypeWizard wizard = item.getContributor().createGlobalElement(cf);
            if (wizard == null) {
                return;
            }
            WizardDialog wizdlg = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
            wizdlg.setBlockOnOpen(true);
            wizdlg.setTitle(UIMessages.newGlobalConfigurationTypeWizardDialogTitle);
            if (wizdlg.open() == 0) {
                List<Dependency> deps;
                Element newXMLNode = wizard.getGlobalConfigurationElementNode();
                if (newXMLNode != null) {
                    switch (item.getContributor().getGlobalConfigElementType()) {
                        case GLOBAL_ELEMENT: {
                            this.createNewGlobalElement(cf, newXMLNode);
                            break;
                        }
                        case CONTEXT_DATAFORMAT: {
                            this.createNewDataFormat(cf, newXMLNode);
                            break;
                        }
                        case CONTEXT_ENDPOINT: {
                            this.createNewEndpoint(cf, newXMLNode);
                            break;
                        }
                    }
                }
                if ((deps = item.getContributor().getElementDependencies()) != null && !deps.isEmpty()) {
                    try {
                        new MavenUtils().updateMavenDependencies(deps);
                    }
                    catch (CoreException ex) {
                        CamelEditorUIActivator.pluginLog().logError("Unable to update pom dependencies for element " + item.getName(), (Throwable)ex);
                    }
                }
            }
        }
    }

    private void createNewEndpoint(CamelFile cf, Node newXMLNode) {
        CamelEndpoint newEndpoint = this.addEndpointToGlobalContext(cf, (Element)newXMLNode);
        new BasicNodeValidator().validate((AbstractCamelModelElement)newEndpoint);
        this.reload();
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)newEndpoint), true);
    }

    private void createNewDataFormat(CamelFile cf, Node newXMLNode) {
        CamelBasicModelElement newDataFormat = this.addDataFormat(cf, (Element)newXMLNode);
        new BasicNodeValidator().validate((AbstractCamelModelElement)newDataFormat);
        this.reload();
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)newDataFormat), true);
    }

    private void createNewGlobalElement(CamelFile cf, Node newXMLNode) {
        String id = ((Element)newXMLNode).getAttribute(GLOBAL_ELEMENTS_ID_ATTR);
        GlobalDefinitionCamelModelElement newGlobalDef = new GlobalDefinitionCamelModelElement((AbstractCamelModelElement)cf, newXMLNode);
        String settedId = Strings.isBlank((String)id) ? UUID.randomUUID().toString() : id;
        newGlobalDef.setId(settedId);
        newGlobalDef.initialize();
        if (cf.getGlobalDefinitions().containsKey(id)) {
            cf.updateGlobalDefinition(settedId, newGlobalDef);
        } else {
            cf.addGlobalDefinition(settedId, newGlobalDef);
        }
        this.reload();
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)newXMLNode), true);
    }

    public CamelBasicModelElement addDataFormat(CamelFile cf, Element newXMLNode) {
        CamelBasicModelElement elemDF = new CamelBasicModelElement((AbstractCamelModelElement)cf.getCamelContext(), (Node)newXMLNode);
        String eipName = CamelUtils.getTranslatedNodeName((Node)newXMLNode);
        this.configureCamelModelElement(cf, newXMLNode, (AbstractCamelModelElement)elemDF, eipName);
        cf.getCamelContext().addDataFormat((AbstractCamelModelElement)elemDF);
        return elemDF;
    }

    private CamelEndpoint addEndpointToGlobalContext(CamelFile cf, Element newXMLNode) {
        CamelEndpoint elemEP = new CamelEndpoint(newXMLNode.getAttribute("uri"));
        elemEP.setParent((AbstractCamelModelElement)cf.getCamelContext());
        this.configureCamelModelElement(cf, newXMLNode, (AbstractCamelModelElement)elemEP, "to");
        cf.getCamelContext().addEndpointDefinition((AbstractCamelModelElement)elemEP);
        return elemEP;
    }

    private void configureCamelModelElement(CamelFile cf, Element newXMLNode, AbstractCamelModelElement cme, String eipName) {
        cme.setXmlNode((Node)newXMLNode);
        CamelModel camelModel = CamelModelFactory.getModelForVersion((String)CamelModelFactory.getCamelVersion((IProject)cf.getResource().getProject()));
        cme.setUnderlyingMetaModelObject(camelModel.getEipModel().getEIPByName(eipName));
        cme.setId(newXMLNode.getAttribute(GLOBAL_ELEMENTS_ID_ATTR));
        cme.initialize();
    }

    private void modifyEntry() {
        IStructuredSelection sel;
        Object o;
        AbstractCamelModelElement cme;
        ICustomGlobalConfigElementContribution extHandler;
        if (!this.treeViewer.getSelection().isEmpty() && (extHandler = this.getExtensionForElement(cme = (o = Selections.getFirstSelection((ISelection)(sel = (IStructuredSelection)this.treeViewer.getSelection()))) instanceof AbstractCamelModelElement ? (AbstractCamelModelElement)o : null)) != null) {
            GlobalConfigurationTypeWizard wizard = extHandler.modifyGlobalElement(this.parentEditor.getDesignEditor().getModel());
            if (wizard == null) {
                try {
                    new ShowPropertiesViewHandler().execute(null);
                }
                catch (ExecutionException e) {
                    CamelEditorUIActivator.pluginLog().logError((Throwable)e);
                }
            } else {
                wizard.setGlobalConfigurationElementNode((Element)cme.getXmlNode());
                WizardDialog wizdlg = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
                wizdlg.setBlockOnOpen(true);
                wizdlg.setTitle(UIMessages.newGlobalConfigurationTypeWizardDialogTitle);
                wizdlg.setTitleImage(null);
                if (wizdlg.open() == 0) {
                    Element newXMLNode = wizard.getGlobalConfigurationElementNode();
                    if (newXMLNode == null) {
                        return;
                    }
                    switch (extHandler.getGlobalConfigElementType()) {
                        case CONTEXT_DATAFORMAT: {
                            throw new UnsupportedOperationException();
                        }
                        case CONTEXT_ENDPOINT: {
                            throw new UnsupportedOperationException();
                        }
                        case GLOBAL_ELEMENT: {
                            this.modifyGlobalElement(newXMLNode);
                            break;
                        }
                    }
                    this.treeViewer.refresh(o, true);
                }
            }
        }
    }

    private void modifyGlobalElement(Node newXmlNode) {
        String id = ((Element)newXmlNode).getAttribute(GLOBAL_ELEMENTS_ID_ATTR);
        CamelFile cf = this.parentEditor.getDesignEditor().getModel();
        GlobalDefinitionCamelModelElement cme = new GlobalDefinitionCamelModelElement((AbstractCamelModelElement)cf, newXmlNode);
        cme.setId(id);
        cme.initialize();
        cf.updateGlobalDefinition(Strings.isBlank((String)id) ? UUID.randomUUID().toString() : id, cme);
        this.reload();
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)cme), true);
    }

    private void deleteEntries() {
        if (!this.treeViewer.getSelection().isEmpty()) {
            IStructuredSelection sel = (IStructuredSelection)this.treeViewer.getSelection();
            for (Object selObj : sel.toList()) {
                ICustomGlobalConfigElementContribution extHandler = null;
                if (!(selObj instanceof AbstractCamelModelElement)) continue;
                AbstractCamelModelElement cme = (AbstractCamelModelElement)selObj;
                try {
                    extHandler = this.getExtensionForElement(cme);
                    if (cme.isEndpointElement()) {
                        cme.getCamelContext().removeEndpointDefinition(cme);
                        continue;
                    }
                    if (cme instanceof GlobalDefinitionCamelModelElement) {
                        cme.getCamelFile().removeGlobalDefinition(cme.getId());
                        continue;
                    }
                    cme.getCamelContext().removeDataFormat(cme);
                }
                finally {
                    if (extHandler != null) {
                        extHandler.onGlobalElementDeleted(cme);
                    }
                    this.treeViewer.remove(selObj);
                }
            }
        }
    }

    private boolean supportsEdit(Object element) {
        if (element instanceof AbstractCamelModelElement) {
            ICustomGlobalConfigElementContribution handler = this.getExtensionForElement((AbstractCamelModelElement)element);
            return handler != null;
        }
        return false;
    }

    private boolean supportsDelete(Object selObj) {
        return selObj instanceof AbstractCamelModelElement || selObj instanceof Element;
    }

    public Map<String, ArrayList<Object>> getModel() {
        return this.model;
    }

    public List<GlobalConfigElementItem> getElementContributions() {
        return this.elementContributions;
    }

    public void setSelection(AbstractCamelModelElement camelModelElement) {
        if (camelModelElement != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)camelModelElement), true);
        }
    }
}

