/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.globalconfiguration;

import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.camel.editor.dialogs.GlobalConfigCategoryItem;
import org.fusesource.ide.camel.editor.dialogs.GlobalConfigElementItem;
import org.fusesource.ide.camel.editor.globalconfiguration.CamelGlobalConfigEditor;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.GlobalDefinitionCamelModelElement;
import org.fusesource.ide.foundation.core.util.CamelUtils;
import org.fusesource.ide.foundation.core.util.Strings;
import org.w3c.dom.Node;

class GlobalConfigLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private final CamelGlobalConfigEditor camelGlobalConfigEditor;

    GlobalConfigLabelProvider(CamelGlobalConfigEditor camelGlobalConfigEditor) {
        this.camelGlobalConfigEditor = camelGlobalConfigEditor;
    }

    private StyledString getStyledTextForCamelModelElement(AbstractCamelModelElement cme) {
        StyledString text = new StyledString();
        String type = this.getTypeFromExtensionPoint(cme);
        text.append(cme.getId());
        if (!Strings.isEmpty((String)type)) {
            text.append(" (" + type + ")", StyledString.COUNTER_STYLER);
        }
        return text;
    }

    private String getTypeFromExtensionPoint(AbstractCamelModelElement cme) {
        for (GlobalConfigElementItem item : this.camelGlobalConfigEditor.getElementContributions()) {
            if (!item.getContributor().canHandle(cme)) continue;
            return item.getName();
        }
        return Strings.capitalize((String)CamelUtils.getTranslatedNodeName((Node)cme.getXmlNode()));
    }

    private StyledString getStyledTextForCategory(String element) {
        GlobalConfigCategoryItem cat = this.camelGlobalConfigEditor.getCategoryForId(element);
        return new StyledString(cat.getName());
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof String) {
            return this.getStyledTextForCategory((String)element);
        }
        if (element instanceof AbstractCamelModelElement) {
            return this.getStyledTextForCamelModelElement((AbstractCamelModelElement)element);
        }
        return new StyledString();
    }

    public Image getImage(Object element) {
        if (element instanceof GlobalDefinitionCamelModelElement) {
            return CamelEditorUIActivator.getDefault().getImage("beandef.gif");
        }
        if (element instanceof AbstractCamelModelElement) {
            return this.getImageForCamelModelElement((AbstractCamelModelElement)element);
        }
        if (element instanceof String) {
            GlobalConfigCategoryItem cat = this.camelGlobalConfigEditor.getCategoryForId((String)element);
            return cat.getIcon();
        }
        return null;
    }

    private Image getImageForCamelModelElement(AbstractCamelModelElement cme) {
        Node xmlNode = cme.getXmlNode();
        Image res = this.getIconFromExtensionPoint(cme);
        if (res == null) {
            Node parentNode;
            if ("endpoint".equalsIgnoreCase(cme.getTranslatedNodeName())) {
                res = CamelEditorUIActivator.getDefault().getImage("endpointdef.png");
            } else if (xmlNode != null && "dataFormats".equalsIgnoreCase(CamelUtils.getTranslatedNodeName((Node)(parentNode = xmlNode.getParentNode())))) {
                res = CamelEditorUIActivator.getDefault().getImage("dataformat.gif");
            }
        }
        return res;
    }

    private Image getIconFromExtensionPoint(AbstractCamelModelElement cme) {
        for (GlobalConfigElementItem item : this.camelGlobalConfigEditor.getElementContributions()) {
            if (!item.getContributor().canHandle(cme)) continue;
            return item.getIcon();
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

