/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.globalconfiguration.dataformat.provider;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.fusesource.ide.camel.editor.globalconfiguration.dataformat.wizards.NewDataFormatWizard;
import org.fusesource.ide.camel.editor.provider.ext.GlobalConfigElementType;
import org.fusesource.ide.camel.editor.provider.ext.GlobalConfigurationTypeWizard;
import org.fusesource.ide.camel.editor.provider.ext.ICustomGlobalConfigElementContribution;
import org.fusesource.ide.camel.model.service.core.catalog.CamelModelFactory;
import org.fusesource.ide.camel.model.service.core.catalog.Dependency;
import org.fusesource.ide.camel.model.service.core.catalog.dataformats.DataFormatModel;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.foundation.core.util.CamelUtils;
import org.w3c.dom.Node;

public class DataFormatContributor
implements ICustomGlobalConfigElementContribution {
    @Override
    public GlobalConfigurationTypeWizard createGlobalElement(CamelFile camelFile) {
        String camelVersion = CamelModelFactory.getCamelVersion((IProject)camelFile.getResource().getProject());
        DataFormatModel dataformatModel = CamelModelFactory.getModelForVersion((String)camelVersion).getDataformatModel();
        return new NewDataFormatWizard(camelFile, dataformatModel);
    }

    @Override
    public GlobalConfigurationTypeWizard modifyGlobalElement(CamelFile camelFile) {
        return null;
    }

    @Override
    public List<Dependency> getElementDependencies() {
        return Collections.emptyList();
    }

    @Override
    public void onGlobalElementDeleted(AbstractCamelModelElement cme) {
    }

    @Override
    public boolean canHandle(AbstractCamelModelElement camelModelElementToHandle) {
        Node nodeToHandle = camelModelElementToHandle.getXmlNode();
        if ("dataformats".equalsIgnoreCase(CamelUtils.getTranslatedNodeName((Node)nodeToHandle.getParentNode()))) {
            String nodeName = CamelUtils.getTranslatedNodeName((Node)nodeToHandle);
            String camelVersion = CamelModelFactory.getCamelVersion((IProject)camelModelElementToHandle.getCamelFile().getResource().getProject());
            DataFormatModel dfModel = CamelModelFactory.getModelForVersion((String)camelVersion).getDataformatModel();
            return !dfModel.getDataFormatsByModelName(nodeName).isEmpty();
        }
        return false;
    }

    @Override
    public GlobalConfigElementType getGlobalConfigElementType() {
        return GlobalConfigElementType.CONTEXT_DATAFORMAT;
    }
}

