/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.globalconfiguration.dataformat.wizards;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.fusesource.ide.camel.editor.globalconfiguration.dataformat.wizards.pages.DataFormatSelectionPage;
import org.fusesource.ide.camel.editor.internal.UIMessages;
import org.fusesource.ide.camel.editor.provider.ext.GlobalConfigurationTypeWizard;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.catalog.dataformats.DataFormat;
import org.fusesource.ide.camel.model.service.core.catalog.dataformats.DataFormatModel;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.w3c.dom.Element;

public class NewDataFormatWizard
extends Wizard
implements GlobalConfigurationTypeWizard {
    private DataFormatModel dfModel;
    private Element dataformatNode;
    private DataFormatSelectionPage dataFormatSelectionPage;
    private DataFormat dataformatSelected;
    private CamelFile camelFile;

    public NewDataFormatWizard(CamelFile camelFile, DataFormatModel dfModel) {
        this.dfModel = dfModel;
        this.camelFile = camelFile;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.setWindowTitle(UIMessages.newGlobalConfigurationTypeDataFormatWizardDialogTitle);
    }

    public void addPages() {
        super.addPages();
        this.dataFormatSelectionPage = new DataFormatSelectionPage(this.dfModel);
        this.addPage((IWizardPage)this.dataFormatSelectionPage);
    }

    public boolean performCancel() {
        this.dataformatNode = null;
        return super.performCancel();
    }

    public boolean performFinish() {
        this.dataformatSelected = this.dataFormatSelectionPage.getDataFormatSelected();
        this.dataformatNode = this.createDataFormatNode(this.dataformatSelected, this.dataFormatSelectionPage.getId());
        return true;
    }

    public Element createDataFormatNode(DataFormat dataformat, String id) {
        String prefixNS = this.camelFile.getCamelContext().getXmlNode().getPrefix();
        Element newDataformatNode = this.camelFile.createElement(dataformat.getModelName(), prefixNS);
        newDataformatNode.setAttribute("id", id);
        for (Parameter parameter : dataformat.getParameters()) {
            String defaultValue = parameter.getDefaultValue();
            if (defaultValue == null) continue;
            newDataformatNode.setAttribute(parameter.getName(), defaultValue);
        }
        return newDataformatNode;
    }

    @Override
    public Element getGlobalConfigurationElementNode() {
        return this.dataformatNode;
    }

    @Override
    public void setGlobalConfigurationElementNode(Element node) {
        this.dataformatNode = node;
    }
}

