/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.fusesource.ide.camel.editor.commands.DiagramOperations;
import org.fusesource.ide.camel.editor.features.create.CreateFlowFeature;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteElement;
import org.fusesource.ide.preferences.PreferenceManager;

public class CamelDiagramLoader {
    private Diagram diagram;
    private IFeatureProvider featureProvider;
    private int orientation = 16;

    public CamelDiagramLoader(Diagram diagram, IFeatureProvider featureProvider) {
        this.diagram = diagram;
        this.featureProvider = featureProvider;
        if (PreferenceManager.getInstance().containsPreference("diagramLayoutOrientationPreference")) {
            this.orientation = PreferenceManager.getInstance().loadPreferenceAsInt("diagramLayoutOrientationPreference");
        }
    }

    public void loadModel(TransactionalEditingDomain editingDomain, AbstractCamelModelElement container) {
        if (container == null) {
            return;
        }
        ArrayList<AbstractCamelModelElement> processedNodes = new ArrayList<AbstractCamelModelElement>();
        List<AbstractCamelModelElement> children = container instanceof CamelRouteElement ? Arrays.asList(container) : container.getChildElements();
        int x = 40;
        int y = 40;
        AbstractCamelModelElement lastElem = container;
        for (AbstractCamelModelElement node : children) {
            int res = this.addProcessor(lastElem, node, x, y, processedNodes, (ContainerShape)this.diagram);
            if (this.orientation == 16) {
                x = res;
            } else {
                y = res;
            }
            lastElem = node;
        }
        DiagramOperations.layoutDiagram(editingDomain, this.featureProvider, this.diagram, container);
    }

    private int addProcessor(AbstractCamelModelElement lastElement, AbstractCamelModelElement node, int x, int y, List<AbstractCamelModelElement> processedNodes, ContainerShape container) {
        AddContext addContext = new AddContext();
        addContext.setNewObject((Object)node);
        addContext.setTargetContainer(container);
        addContext.setX(x);
        addContext.setY(y);
        addContext.putProperty((Object)"deactivateLayout", (Object)true);
        int retVal = this.orientation == 16 ? x : y;
        IAddFeature addFeature = this.featureProvider.getAddFeature((IAddContext)addContext);
        if (addFeature.canAdd((IAddContext)addContext)) {
            boolean createConnection;
            PictogramElement destState = null;
            if (!processedNodes.contains(node)) {
                destState = addFeature.add((IAddContext)addContext);
                processedNodes.add(node);
            } else {
                destState = this.featureProvider.getPictogramElementForBusinessObject((Object)node);
            }
            boolean bl = createConnection = lastElement != null && lastElement.equals(node.getInputElement());
            if (createConnection) {
                lastElement.setOutputElement(null);
                node.setInputElement(null);
                CreateFlowFeature createFeature = new CreateFlowFeature(this.featureProvider);
                CreateConnectionContext connectContext = new CreateConnectionContext();
                PictogramElement srcState = this.featureProvider.getPictogramElementForBusinessObject((Object)lastElement);
                if (srcState == destState) {
                    CamelEditorUIActivator.pluginLog().logWarning("Should not be the same element for different nodes: " + lastElement + " and " + node);
                }
                connectContext.setSourcePictogramElement(srcState);
                connectContext.setTargetPictogramElement(destState);
                connectContext.putProperty((Object)"deactivateLayout", (Object)true);
                Anchor srcAnchor = this.getAnchor(srcState);
                Anchor destAnchor = this.getAnchor(destState);
                if (srcAnchor != null && destAnchor != null) {
                    connectContext.setSourceAnchor(srcAnchor);
                    connectContext.setTargetAnchor(destAnchor);
                    if (createFeature.canCreate((ICreateConnectionContext)connectContext)) {
                        createFeature.execute((IContext)connectContext);
                    }
                }
            }
            if (node.getChildElements().size() > 0) {
                int subX = 40;
                int subY = 40;
                AbstractCamelModelElement lastSub = null;
                for (AbstractCamelModelElement subNode : node.getChildElements()) {
                    int res = this.addProcessor(lastSub, subNode, subX, subY, processedNodes, this.getContainerShape(destState));
                    if (this.orientation == 16) {
                        subX = res;
                    } else {
                        subY = res;
                    }
                    lastSub = subNode;
                }
            }
            retVal = this.orientation == 16 ? (retVal += 220) : (retVal += 98);
        } else {
            CamelEditorUIActivator.pluginLog().logWarning("Cannot add node: " + node);
        }
        return retVal;
    }

    private ContainerShape getContainerShape(PictogramElement pe) {
        return (ContainerShape)pe;
    }

    private Anchor getAnchor(PictogramElement element) {
        AnchorContainer container;
        EList anchors;
        if (element instanceof AnchorContainer && (anchors = (container = (AnchorContainer)element).getAnchors()) != null && anchors.size() > 0) {
            Anchor answer = (Anchor)anchors.get(0);
            return answer;
        }
        return null;
    }
}

