/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.internal;

import java.net.URL;
import java.util.Enumeration;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.camel.editor.internal.PreferredPerspectivePartListener;
import org.fusesource.ide.camel.editor.internal.Trace;
import org.jboss.tools.foundation.core.plugin.log.IPluginLog;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;
import org.jboss.tools.foundation.ui.plugin.BaseUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class CamelEditorUIActivator
extends BaseUIPlugin {
    public static final String PLUGIN_ID = "org.fusesource.ide.camel.editor";
    private static CamelEditorUIActivator instance;
    private static BundleContext myContext;
    private PreferredPerspectivePartListener perspectiveListener;

    public CamelEditorUIActivator() {
        instance = this;
    }

    public static CamelEditorUIActivator getDefault() {
        return instance;
    }

    public static BundleContext getBundleContext() {
        return myContext;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        myContext = context;
        this.registerDebugOptionsListener(PLUGIN_ID, new Trace(this), context);
        this.perspectiveListener = new PreferredPerspectivePartListener();
        this.perspectiveListener.earlyStartup();
    }

    public void stop(BundleContext context) throws Exception {
        myContext = null;
        super.stop(context);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        String prefix = "/icons/";
        Enumeration enu = this.getBundle().findEntries(prefix, "*", true);
        while (enu.hasMoreElements()) {
            String file;
            URL u = (URL)enu.nextElement();
            String fileName = file = u.getFile();
            if (!file.startsWith(prefix)) {
                CamelEditorUIActivator.pluginLog().logWarning("Warning: image: " + fileName + " does not start with prefix: " + prefix);
            }
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
            this.registerImage(reg, fileName, file);
        }
    }

    private void registerImage(ImageRegistry reg, String key, String filePath) {
        reg.put(key, CamelEditorUIActivator.imageDescriptorFromPlugin((String)this.getBundle().getSymbolicName(), (String)filePath));
    }

    public Image getImage(String key) {
        return this.getImageRegistry().get(key);
    }

    public ImageDescriptor getImageDescriptor(String key) {
        return this.getImageRegistry().getDescriptor(key);
    }

    public static String getMessage(String key) {
        return Platform.getResourceString((Bundle)instance.getBundle(), (String)key);
    }

    public static IPluginLog pluginLog() {
        return CamelEditorUIActivator.getDefault().pluginLogInternal();
    }

    public static StatusFactory statusFactory() {
        return CamelEditorUIActivator.getDefault().statusFactoryInternal();
    }
}

