/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.fusesource.ide.camel.editor.CamelDesignEditor;
import org.fusesource.ide.camel.editor.CamelEditor;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.editor.navigator.CamelCtxNavRouteNode;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteElement;

public class CamelCtxNavActionProvider
extends CommonActionProvider {
    private Action mOpenEditorAction;

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (this.mOpenEditorAction != null && this.mOpenEditorAction.isEnabled()) {
            menu.appendToGroup("group.open", (IAction)this.mOpenEditorAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        if (this.mOpenEditorAction != null && this.mOpenEditorAction.isEnabled()) {
            actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.mOpenEditorAction);
        }
    }

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        if (aSite.getViewSite() instanceof ICommonViewerWorkbenchSite && ((ICommonViewerWorkbenchSite)aSite.getViewSite()).getPart() instanceof IViewPart) {
            final IWorkbenchPage page = ((IViewPart)((ICommonViewerWorkbenchSite)aSite.getViewSite()).getPart()).getViewSite().getPage();
            this.mOpenEditorAction = new Action("Open"){

                public void run() {
                    Object o;
                    Object object = o = CamelCtxNavActionProvider.this.getActionSite() != null && CamelCtxNavActionProvider.this.getActionSite().getStructuredViewer() != null && CamelCtxNavActionProvider.this.getActionSite().getStructuredViewer().getStructuredSelection() != null ? CamelCtxNavActionProvider.this.getActionSite().getStructuredViewer().getStructuredSelection().getFirstElement() : null;
                    if (o instanceof CamelCtxNavRouteNode) {
                        CamelCtxNavRouteNode route = (CamelCtxNavRouteNode)o;
                        try {
                            CamelEditor camelEditor;
                            IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)route.getCamelContextFile(), (boolean)OpenStrategy.activateOnOpen());
                            if (editorPart instanceof CamelEditor && (camelEditor = (CamelEditor)editorPart).getActiveEditor() instanceof CamelDesignEditor) {
                                CamelDesignEditor designEditor = (CamelDesignEditor)camelEditor.getActiveEditor();
                                CamelRouteElement selectedRoute = route.getMatchingRouteFromEditorModel(camelEditor.getDesignEditor().getModel().getCamelContext());
                                if (selectedRoute != null && selectedRoute != designEditor.getSelectedContainer()) {
                                    boolean wasDirty = designEditor.isDirty();
                                    designEditor.setSelectedContainer((AbstractCamelModelElement)selectedRoute);
                                    if (!wasDirty && designEditor.isDirty()) {
                                        camelEditor.setDirtyFlag(false);
                                    }
                                }
                            }
                        }
                        catch (PartInitException e) {
                            CamelEditorUIActivator.pluginLog().logError("Unable to load the file into camel editor.", (Throwable)e);
                        }
                    }
                }
            };
        }
    }
}

