/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.navigator;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.fusesource.ide.camel.editor.navigator.CamelCtxNavRouteNode;
import org.fusesource.ide.camel.model.service.core.io.CamelIOHandler;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteElement;
import org.fusesource.ide.foundation.ui.util.Widgets;

public class CamelCtxNavContentProvider
implements ICommonContentProvider {
    private AbstractTreeViewer mViewer;

    public Object[] getChildren(Object parent) {
        if (parent instanceof IFile) {
            return this.getRoutes((IFile)parent, true);
        }
        return new Object[0];
    }

    private Object[] getRoutes(IFile camelFile, boolean deferred) {
        if (deferred) {
            LoadingPlaceHolder placeHolder = new LoadingPlaceHolder();
            this.doDeferredLoad(camelFile, placeHolder);
            return new Object[]{placeHolder};
        }
        return this.getRoutes(camelFile);
    }

    private CamelCtxNavRouteNode[] getRoutes(IFile camelFile) {
        CamelIOHandler ioHandler = new CamelIOHandler();
        CamelFile rc = ioHandler.loadCamelModel((IResource)camelFile, (IProgressMonitor)new NullProgressMonitor());
        if (rc != null && rc.getCamelContext() != null) {
            ArrayList<CamelCtxNavRouteNode> routes = new ArrayList<CamelCtxNavRouteNode>();
            for (AbstractCamelModelElement node : rc.getCamelContext().getChildElements()) {
                if (!(node instanceof CamelRouteElement)) continue;
                routes.add(new CamelCtxNavRouteNode((CamelRouteElement)node, camelFile));
            }
            return routes.toArray(new CamelCtxNavRouteNode[routes.size()]);
        }
        return new CamelCtxNavRouteNode[0];
    }

    private void doDeferredLoad(final IFile camelFile, final LoadingPlaceHolder placeHolder) {
        Job job = new Job("Loading " + camelFile.getName()){

            protected IStatus run(IProgressMonitor monitor) {
                final CamelCtxNavRouteNode[] routes = CamelCtxNavContentProvider.this.getRoutes(camelFile);
                if (routes != null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!Widgets.isDisposed((Viewer)CamelCtxNavContentProvider.this.mViewer)) {
                                CamelCtxNavContentProvider.this.mViewer.add((Object)camelFile, (Object[])routes);
                            }
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!Widgets.isDisposed((Viewer)CamelCtxNavContentProvider.this.mViewer)) {
                            CamelCtxNavContentProvider.this.mViewer.remove((Object)camelFile, new Object[]{placeHolder});
                        }
                    }
                });
            }
        });
        job.schedule();
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || element instanceof CamelCtxNavRouteNode && this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof AbstractTreeViewer) {
            this.mViewer = (AbstractTreeViewer)viewer;
        }
    }

    public void dispose() {
        this.mViewer = null;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        return null;
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    private static class LoadingPlaceHolder {
        private final String loadingMsg = "Pending ...";

        private LoadingPlaceHolder() {
        }

        public String toString() {
            return "Pending ...";
        }
    }
}

