/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.navigator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelContextElement;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteElement;

public class CamelCtxNavRouteNode {
    private final CamelRouteElement mRouteSupport;
    private final IFile mFile;

    public CamelCtxNavRouteNode(CamelRouteElement routeSupport, IFile file) {
        this.mRouteSupport = routeSupport;
        this.mFile = file;
    }

    public CamelRouteElement getCamelRoute() {
        return this.mRouteSupport;
    }

    public IFile getCamelContextFile() {
        return this.mFile;
    }

    public String toString() {
        return this.mRouteSupport.toString();
    }

    private static List<String> getChildNodesDisplayText(AbstractCamelModelElement routeSupport) {
        ArrayList<String> nodeKeys = new ArrayList<String>();
        for (AbstractCamelModelElement childNode : routeSupport.getChildElements()) {
            nodeKeys.add(childNode.getDisplayText());
        }
        return nodeKeys;
    }

    public CamelRouteElement getMatchingRouteFromEditorModel(CamelContextElement model) {
        if (model != null) {
            List<String> nodeKeys = CamelCtxNavRouteNode.getChildNodesDisplayText((AbstractCamelModelElement)this.mRouteSupport);
            String nodeDisplayText = this.mRouteSupport.getDisplayText();
            if (nodeDisplayText != null) {
                for (AbstractCamelModelElement node : model.getChildElements()) {
                    List<String> editorNodeKeys;
                    if (!(node instanceof CamelRouteElement) || !nodeDisplayText.equals(node.getDisplayText())) continue;
                    List editorNodeChildren = node.getChildElements();
                    if (nodeKeys.size() != editorNodeChildren.size() || !(editorNodeKeys = CamelCtxNavRouteNode.getChildNodesDisplayText(node)).containsAll(nodeKeys)) continue;
                    return (CamelRouteElement)node;
                }
            }
        }
        return null;
    }
}

