/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.outline;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.fusesource.ide.camel.editor.CamelDesignEditor;
import org.fusesource.ide.camel.editor.outline.CamelModelOutlineContentProvider;
import org.fusesource.ide.camel.editor.outline.CamelModelOutlineLabelProvider;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelContextElement;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.camel.model.service.core.model.ICamelModelListener;
import org.fusesource.ide.foundation.ui.util.Widgets;

public class CamelModelOutlinePage
extends ContentOutlinePage
implements ICamelModelListener {
    private CamelDesignEditor designEditor;

    public CamelModelOutlinePage(CamelDesignEditor designEditor) {
        this.designEditor = designEditor;
        this.designEditor.getModel().addModelListener((ICamelModelListener)this);
    }

    public void dispose() {
        this.designEditor.getModel().removeModelListener((ICamelModelListener)this);
        super.dispose();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new CamelModelOutlineContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new CamelModelOutlineLabelProvider());
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        viewer.setInput((Object)this.computeInput());
        viewer.expandAll();
    }

    private AbstractCamelModelElement[] computeInput() {
        AbstractCamelModelElement selectedContainer = this.designEditor.getSelectedContainer();
        if (selectedContainer == null) {
            selectedContainer = this.designEditor.getModel().getCamelContext();
        }
        return this.getModelRoots(selectedContainer);
    }

    public void setOutlineSelection(AbstractCamelModelElement cme) {
        if (cme == null || cme.getId() == null || Widgets.isDisposed((Viewer)this.getTreeViewer())) {
            return;
        }
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)cme), true);
        }
        if (this.getTreeViewer() != null && this.getTreeViewer().getSelection().isEmpty()) {
            this.getTreeViewer().expandAll();
            TreeItem ti = this.findTreeItemForElement(cme, this.getTreeViewer().getTree().getItems());
            if (ti != null) {
                this.getTreeViewer().setSelection((ISelection)new StructuredSelection(ti.getData()), true);
            }
        }
    }

    private TreeItem findTreeItemForElement(AbstractCamelModelElement cme, TreeItem[] treeItems) {
        TreeItem tRes = null;
        TreeItem[] treeItemArray = treeItems;
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti = treeItemArray[n2];
            if (tRes != null) break;
            Object o = ti.getData();
            if (o instanceof AbstractCamelModelElement) {
                AbstractCamelModelElement cme2 = (AbstractCamelModelElement)o;
                if (cme.getId().equals(cme2.getId())) {
                    tRes = ti;
                    break;
                }
                tRes = this.findTreeItemForElement(cme, ti.getItems());
            }
            ++n2;
        }
        return tRes;
    }

    public void modelChanged() {
        if (this.getTreeViewer() != null && !this.getTreeViewer().getTree().isDisposed()) {
            this.getTreeViewer().refresh(true);
            this.getTreeViewer().expandAll();
        }
    }

    public void changeInput(AbstractCamelModelElement container) {
        if (this.getTreeViewer() != null && !this.getTreeViewer().getTree().isDisposed()) {
            this.getTreeViewer().setInput((Object)this.getModelRoots(container));
            this.modelChanged();
        }
    }

    private AbstractCamelModelElement[] getModelRoots(AbstractCamelModelElement selectedContainer) {
        AbstractCamelModelElement[] container = selectedContainer instanceof CamelFile ? ((AbstractCamelModelElement)selectedContainer.getChildElements().get(0)).getChildElements().toArray(new AbstractCamelModelElement[selectedContainer.getChildElements().size()]) : (selectedContainer instanceof CamelContextElement ? selectedContainer.getChildElements().toArray(new AbstractCamelModelElement[selectedContainer.getChildElements().size()]) : (selectedContainer == null ? new AbstractCamelModelElement[]{} : new AbstractCamelModelElement[]{selectedContainer}));
        return container;
    }
}

