/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.internal.forms.widgets.FormsResources;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fusesource.ide.camel.editor.properties.FusePropertySection;
import org.fusesource.ide.camel.editor.properties.ParameterPriorityComparator;
import org.fusesource.ide.camel.editor.properties.creators.advanced.BooleanParameterPropertyUICreatorForAdvanced;
import org.fusesource.ide.camel.editor.properties.creators.advanced.ClassBasedParameterPropertyUICreatorForAdvanced;
import org.fusesource.ide.camel.editor.properties.creators.advanced.FileParameterPropertyUICreatorForAdvanced;
import org.fusesource.ide.camel.editor.properties.creators.advanced.NumberParameterPropertyUICreatorForAdvanced;
import org.fusesource.ide.camel.editor.properties.creators.advanced.UnsupportedParameterPropertyUICreatorForAdvanced;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.catalog.UriParameterKind;
import org.fusesource.ide.camel.model.service.core.catalog.components.Component;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.util.CamelComponentUtils;
import org.fusesource.ide.camel.model.service.core.util.PropertiesUtils;
import org.fusesource.ide.foundation.core.util.Strings;

public class AdvancedEndpointPropertiesSection
extends FusePropertySection {
    @Override
    protected void createContentTabs(CTabFolder folder) {
        List props = PropertiesUtils.getComponentPropertiesFor((AbstractCamelModelElement)this.selectedEP);
        if (props.isEmpty()) {
            return;
        }
        boolean createCommonsTab = false;
        List commonProps = PropertiesUtils.getPropertiesFor((AbstractCamelModelElement)this.selectedEP, (UriParameterKind)UriParameterKind.BOTH);
        for (Parameter p : commonProps) {
            if (p.getGroup() != null && p.getGroup().trim().length() >= 1) continue;
            createCommonsTab = true;
            break;
        }
        boolean createConsumerTab = false;
        List consumerProps = PropertiesUtils.getPropertiesFor((AbstractCamelModelElement)this.selectedEP, (UriParameterKind)UriParameterKind.CONSUMER);
        for (Parameter p : consumerProps) {
            if (p.getGroup() != null && p.getGroup().trim().length() >= 1) continue;
            createConsumerTab = true;
            break;
        }
        boolean createProducerTab = false;
        List producerProps = PropertiesUtils.getPropertiesFor((AbstractCamelModelElement)this.selectedEP, (UriParameterKind)UriParameterKind.PRODUCER);
        for (Parameter p : producerProps) {
            if (p.getGroup() != null && p.getGroup().trim().length() >= 1) continue;
            createProducerTab = true;
            break;
        }
        ArrayList<String> tabsToCreate = new ArrayList<String>();
        tabsToCreate.add("Path");
        if (createCommonsTab) {
            tabsToCreate.add("Common");
        }
        if (createConsumerTab) {
            tabsToCreate.add("Consumer");
        }
        if (createProducerTab) {
            tabsToCreate.add("Producer");
        }
        for (Parameter p : props) {
            if (p.getGroup() == null || p.getGroup().trim().length() <= 0 || tabsToCreate.contains(p.getGroup())) continue;
            tabsToCreate.add(p.getGroup());
        }
        props.sort(new ParameterPriorityComparator());
        for (String group : tabsToCreate) {
            CTabItem contentTab = new CTabItem(this.tabFolder, 0);
            contentTab.setText(Strings.humanize((String)group));
            Composite page = this.toolkit.createComposite((Composite)folder);
            page.setLayout((Layout)new GridLayout(4, false));
            if (group.equalsIgnoreCase("Path")) {
                this.generateTabContents(PropertiesUtils.getPathProperties((AbstractCamelModelElement)this.selectedEP), page, false, group);
            } else {
                this.generateTabContents(props, page, true, group);
            }
            contentTab.setControl((Control)page);
            this.tabs.add(contentTab);
        }
    }

    protected void generateTabContents(List<Parameter> props, Composite page, boolean ignorePathProperties, String group) {
        props.sort(new ParameterPriorityComparator());
        Iterator<Parameter> iterator = props.iterator();
        while (iterator.hasNext()) {
            Text txtField;
            Parameter p;
            final Parameter prop = p = iterator.next();
            if (ignorePathProperties && p.getKind() != null && p.getKind().equalsIgnoreCase("path") || (p.getGroup() != null && p.getGroup().trim().length() > 0 ? !group.equalsIgnoreCase(p.getGroup()) && !p.getKind().equalsIgnoreCase("Path") : (!prop.getKind().equalsIgnoreCase("Path") || !group.equalsIgnoreCase("Path")) && (prop.getLabel() != null && !PropertiesUtils.containsLabel((String)group, (Parameter)prop) || prop.getLabel() == null && !group.equalsIgnoreCase("Common")))) continue;
            ISWTObservableValue uiObservable = null;
            IObservableValue modelObservable = null;
            Object validator = null;
            this.createPropertyLabel(this.toolkit, page, p);
            Text c = null;
            if (CamelComponentUtils.isBooleanProperty((Parameter)prop)) {
                new BooleanParameterPropertyUICreatorForAdvanced(this.dbc, this.modelMap, this.eip, this.selectedEP, p, page, this.getWidgetFactory()).create();
            } else if (CamelComponentUtils.isTextProperty((Parameter)prop)) {
                txtField = this.toolkit.createText(page, PropertiesUtils.getPropertyFromUri((AbstractCamelModelElement)this.selectedEP, (Parameter)prop, (Component)this.component), 18436);
                txtField.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        Text txt = (Text)e.getSource();
                        PropertiesUtils.updateURIParams((AbstractCamelModelElement)AdvancedEndpointPropertiesSection.this.selectedEP, (Parameter)prop, (Object)txt.getText(), (Component)AdvancedEndpointPropertiesSection.this.component, (IObservableMap)AdvancedEndpointPropertiesSection.this.modelMap);
                    }
                });
                txtField.setLayoutData((Object)this.createPropertyFieldLayoutData());
                c = txtField;
                this.modelMap.put((Object)p.getName(), (Object)txtField.getText());
                uiObservable = WidgetProperties.text((int)24).observe((Widget)txtField);
                if (PropertiesUtils.isRequired((Parameter)p) || p.getName().equalsIgnoreCase("id")) {
                    validator = new IValidator(){

                        public IStatus validate(Object value) {
                            if (((String)AdvancedEndpointPropertiesSection.this.selectedEP.getParameter("uri")).startsWith("ref:")) {
                                String refId;
                                String string = refId = ((String)AdvancedEndpointPropertiesSection.this.selectedEP.getParameter("uri")).trim().length() > "ref:".length() ? ((String)AdvancedEndpointPropertiesSection.this.selectedEP.getParameter("uri")).substring("ref:".length()) : null;
                                if (refId == null || refId.trim().length() < 1 || AdvancedEndpointPropertiesSection.this.selectedEP.getCamelContext().getEndpointDefinitions().get(refId) == null) {
                                    return ValidationStatus.warning((String)"The entered reference does not exist in your context!");
                                }
                            }
                            if (value != null && value instanceof String && value.toString().trim().length() > 0) {
                                return ValidationStatus.ok();
                            }
                            return ValidationStatus.error((String)("Parameter " + prop.getName() + " is a mandatory field and cannot be empty."));
                        }
                    };
                }
            } else if (CamelComponentUtils.isNumberProperty((Parameter)prop)) {
                new NumberParameterPropertyUICreatorForAdvanced(this.dbc, this.modelMap, this.eip, this.selectedEP, prop, page, this.getWidgetFactory()).create();
            } else if (CamelComponentUtils.isChoiceProperty((Parameter)prop)) {
                CCombo choiceCombo = new CCombo(page, 0x80080C);
                this.toolkit.adapt((Control)choiceCombo, true, true);
                choiceCombo.setEditable(false);
                choiceCombo.setItems(CamelComponentUtils.getChoices((Parameter)prop));
                String selectedValue = PropertiesUtils.getPropertyFromUri((AbstractCamelModelElement)this.selectedEP, (Parameter)prop, (Component)this.component);
                int i = 0;
                while (i < choiceCombo.getItems().length) {
                    if (selectedValue != null && choiceCombo.getItem(i).equalsIgnoreCase(selectedValue)) {
                        choiceCombo.select(i);
                        break;
                    }
                    if (selectedValue == null && p.getDefaultValue() != null && choiceCombo.getItem(i).equalsIgnoreCase(p.getDefaultValue())) {
                        choiceCombo.select(i);
                        break;
                    }
                    ++i;
                }
                choiceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        CCombo choice = (CCombo)e.getSource();
                        PropertiesUtils.updateURIParams((AbstractCamelModelElement)AdvancedEndpointPropertiesSection.this.selectedEP, (Parameter)prop, (Object)choice.getText(), (Component)AdvancedEndpointPropertiesSection.this.component, (IObservableMap)AdvancedEndpointPropertiesSection.this.modelMap);
                    }
                });
                choiceCombo.setLayoutData((Object)this.createPropertyFieldLayoutData());
                c = choiceCombo;
                this.modelMap.put((Object)p.getName(), (Object)choiceCombo.getText());
                uiObservable = WidgetProperties.selection().observe((Widget)choiceCombo);
                if (PropertiesUtils.isRequired((Parameter)p)) {
                    validator = new IValidator(){

                        public IStatus validate(Object value) {
                            if (value != null && value instanceof String && value.toString().trim().length() > 0) {
                                return ValidationStatus.ok();
                            }
                            return ValidationStatus.error((String)("Parameter " + prop.getName() + " is a mandatory field and cannot be empty."));
                        }
                    };
                }
            } else if (CamelComponentUtils.isFileProperty((Parameter)prop)) {
                new FileParameterPropertyUICreatorForAdvanced(this.dbc, this.modelMap, this.eip, this.selectedEP, p, page, this.getWidgetFactory()).create();
            } else if (CamelComponentUtils.isExpressionProperty((Parameter)prop)) {
                txtField = this.toolkit.createText(page, PropertiesUtils.getPropertyFromUri((AbstractCamelModelElement)this.selectedEP, (Parameter)prop, (Component)this.component), 18436);
                txtField.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        Text txt = (Text)e.getSource();
                        PropertiesUtils.updateURIParams((AbstractCamelModelElement)AdvancedEndpointPropertiesSection.this.selectedEP, (Parameter)prop, (Object)txt.getText(), (Component)AdvancedEndpointPropertiesSection.this.component, (IObservableMap)AdvancedEndpointPropertiesSection.this.modelMap);
                    }
                });
                txtField.setLayoutData((Object)this.createPropertyFieldLayoutData());
                c = txtField;
                if (PropertiesUtils.isRequired((Parameter)p)) {
                    validator = new IValidator(){

                        public IStatus validate(Object value) {
                            if (value != null && value instanceof String && value.toString().trim().length() > 0) {
                                return ValidationStatus.ok();
                            }
                            return ValidationStatus.error((String)("Parameter " + prop.getName() + " is a mandatory field and cannot be empty."));
                        }
                    };
                }
                this.modelMap.put((Object)p.getName(), (Object)txtField.getText());
                uiObservable = WidgetProperties.text((int)24).observe((Widget)txtField);
            } else if (CamelComponentUtils.isDataFormatProperty((Parameter)prop)) {
                txtField = this.toolkit.createText(page, PropertiesUtils.getPropertyFromUri((AbstractCamelModelElement)this.selectedEP, (Parameter)prop, (Component)this.component), 18436);
                txtField.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        Text txt = (Text)e.getSource();
                        PropertiesUtils.updateURIParams((AbstractCamelModelElement)AdvancedEndpointPropertiesSection.this.selectedEP, (Parameter)prop, (Object)txt.getText(), (Component)AdvancedEndpointPropertiesSection.this.component, (IObservableMap)AdvancedEndpointPropertiesSection.this.modelMap);
                    }
                });
                txtField.setLayoutData((Object)this.createPropertyFieldLayoutData());
                c = txtField;
                if (PropertiesUtils.isRequired((Parameter)p)) {
                    validator = new IValidator(){

                        public IStatus validate(Object value) {
                            if (value != null && value instanceof String && value.toString().trim().length() > 0) {
                                return ValidationStatus.ok();
                            }
                            return ValidationStatus.error((String)("Parameter " + prop.getName() + " is a mandatory field and cannot be empty."));
                        }
                    };
                }
                this.modelMap.put((Object)p.getName(), (Object)txtField.getText());
                uiObservable = WidgetProperties.text((int)24).observe((Widget)txtField);
            } else if (CamelComponentUtils.isUnsupportedProperty((Parameter)prop)) {
                new UnsupportedParameterPropertyUICreatorForAdvanced(this.dbc, this.modelMap, this.eip, this.selectedEP, p, page, this.getWidgetFactory()).create();
            } else {
                new ClassBasedParameterPropertyUICreatorForAdvanced(this.dbc, this.modelMap, this.eip, this.selectedEP, prop, page, this.getWidgetFactory()).create();
            }
            if (uiObservable == null) continue;
            UpdateValueStrategy strategy = new UpdateValueStrategy();
            strategy.setBeforeSetValidator(validator);
            modelObservable = Observables.observeMapEntry((IObservableMap)this.modelMap, (Object)p.getName());
            Binding bindValue = this.dbc.bindValue(uiObservable, modelObservable, strategy, null);
            ControlDecorationSupport.create((ValidationStatusProvider)bindValue, (int)16512);
            if (p.getDescription() == null) continue;
            c.setToolTipText(p.getDescription());
        }
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        super.createControls(parent, aTabbedPropertySheetPage);
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(1808));
        this.form = this.toolkit.createForm(parent);
        this.form.setLayoutData((Object)new GridData(1808));
        this.form.getBody().setLayout((Layout)new GridLayout(1, false));
        Composite sbody = this.form.getBody();
        this.tabFolder = new CTabFolder(sbody, 0x800080);
        this.toolkit.adapt((Control)this.tabFolder, true, true);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        Color selectedColor = this.toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR");
        this.tabFolder.setSelectionBackground(new Color[]{selectedColor, this.toolkit.getColors().getBackground()}, new int[]{20}, true);
        this.tabFolder.setCursor(FormsResources.getHandCursor());
        this.toolkit.paintBordersFor((Composite)this.tabFolder);
        this.form.setText("Advanced Properties");
        this.toolkit.decorateFormHeading(this.form);
        this.form.layout();
        this.tabFolder.setSelection(0);
    }
}

