/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.internal.forms.widgets.FormsResources;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fusesource.ide.camel.editor.properties.ParameterPriorityComparator;
import org.fusesource.ide.camel.editor.utils.NodeUtils;
import org.fusesource.ide.camel.model.service.core.catalog.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.CamelModelFactory;
import org.fusesource.ide.camel.model.service.core.catalog.IParameterContainer;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.catalog.components.Component;
import org.fusesource.ide.camel.model.service.core.catalog.dataformats.DataFormat;
import org.fusesource.ide.camel.model.service.core.catalog.eips.Eip;
import org.fusesource.ide.camel.model.service.core.catalog.languages.Language;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelBasicModelElement;
import org.fusesource.ide.camel.model.service.core.util.CamelComponentUtils;
import org.fusesource.ide.camel.model.service.core.util.PropertiesUtils;
import org.fusesource.ide.foundation.core.util.CamelUtils;
import org.fusesource.ide.foundation.core.util.Strings;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class FusePropertySection
extends AbstractPropertySection {
    public static final String DEFAULT_GROUP = "General";
    public static final String GROUP_PATH = "Path";
    public static final String GROUP_COMMON = "Common";
    public static final String GROUP_CONSUMER = "Consumer";
    public static final String GROUP_PRODUCER = "Producer";
    protected FormToolkit toolkit;
    protected Form form;
    protected CTabFolder tabFolder;
    protected List<CTabItem> tabs = new ArrayList<CTabItem>();
    protected AbstractCamelModelElement selectedEP;
    protected DataBindingContext dbc;
    protected IObservableMap modelMap = new WritableMap();
    protected Composite parent;
    protected TabbedPropertySheetPage aTabbedPropertySheetPage;
    protected Component component;
    protected Eip eip;

    public void dispose() {
        if (this.form != null) {
            this.form.dispose();
        }
        if (!this.tabs.isEmpty()) {
            for (CTabItem tab : this.tabs) {
                if (tab.isDisposed()) continue;
                tab.dispose();
            }
            this.tabs.clear();
        }
        if (this.tabFolder != null) {
            this.tabFolder.dispose();
        }
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        this.aTabbedPropertySheetPage = null;
        this.component = null;
        this.eip = null;
        super.dispose();
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.dbc = new DataBindingContext();
        AbstractCamelModelElement n = NodeUtils.getSelectedNode(selection);
        this.createTabFolder();
        if (n.getUnderlyingMetaModelObject() != null) {
            this.selectedEP = n;
            this.eip = PropertiesUtils.getEipFor((AbstractCamelModelElement)this.selectedEP);
            String headerText = this.selectedEP.getDisplayText();
            this.form.setText(headerText);
            if (this.selectedEP.isEndpointElement()) {
                this.component = PropertiesUtils.getComponentFor((AbstractCamelModelElement)this.selectedEP);
            }
        } else {
            this.selectedEP = null;
            this.form.setText("");
        }
        int idx = Math.max(this.tabFolder.getSelectionIndex(), 0);
        if (!this.tabs.isEmpty()) {
            for (CTabItem tab : this.tabs) {
                if (tab.isDisposed()) continue;
                tab.dispose();
            }
            this.tabs.clear();
        }
        this.createContentTabs(this.tabFolder);
        this.tabFolder.setSingle(this.tabFolder.getItemCount() == 1);
        this.tabFolder.setSelection(idx >= this.tabFolder.getItemCount() ? 0 : idx);
        this.form.redraw();
        this.form.layout();
        this.form.update();
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.parent = parent;
        this.aTabbedPropertySheetPage = aTabbedPropertySheetPage;
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(1808));
    }

    private void createTabFolder() {
        if (this.form != null) {
            this.form.dispose();
        }
        this.form = this.toolkit.createForm(this.parent);
        this.form.setLayoutData((Object)new GridData(1808));
        this.form.getBody().setLayout((Layout)new GridLayout(1, false));
        if (this.tabFolder != null) {
            this.tabFolder.dispose();
        }
        this.tabFolder = new CTabFolder(this.form.getBody(), 0x800080);
        this.toolkit.adapt((Control)this.tabFolder, true, true);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        Color selectedColor = this.toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR");
        this.tabFolder.setSelectionBackground(new Color[]{selectedColor, this.toolkit.getColors().getBackground()}, new int[]{20}, true);
        this.tabFolder.setCursor(FormsResources.getHandCursor());
        this.toolkit.paintBordersFor((Composite)this.tabFolder);
        this.toolkit.decorateFormHeading(this.form);
        this.form.layout();
        this.parent.layout(true);
        this.tabFolder.setSelection(0);
    }

    protected abstract void createContentTabs(CTabFolder var1);

    public void createPropertyLabel(FormToolkit toolkit, Composite page, Parameter p) {
        String s = this.computePropertyDisplayName(p);
        Label l = toolkit.createLabel(page, s);
        l.setLayoutData((Object)new GridData());
        this.addDescriptionAsTooltip(p, l);
    }

    protected Display getDisplay() {
        return Display.getDefault();
    }

    protected String computePropertyDisplayName(Parameter parameter) {
        String s = Strings.humanize((String)parameter.getName());
        if (CamelComponentUtils.isExpressionProperty((Parameter)parameter)) {
            s = "Language";
        }
        if (PropertiesUtils.isRequired((Parameter)parameter)) {
            s = String.valueOf(s) + " *";
        }
        if (PropertiesUtils.isDeprecated((Parameter)parameter)) {
            s = String.valueOf(s) + " (deprecated)";
        }
        return s;
    }

    private void addDescriptionAsTooltip(Parameter parameter, Label label) {
        String description = parameter.getDescription();
        if (description != null) {
            label.setToolTipText(description);
        }
    }

    protected CamelModel getCamelModel(AbstractCamelModelElement modelElement) {
        String prjCamelVersion = org.fusesource.ide.camel.editor.utils.CamelUtils.getCurrentProjectCamelVersion();
        CamelModel model = CamelModelFactory.getModelForVersion((String)prjCamelVersion);
        if (model == null) {
            return null;
        }
        return model;
    }

    protected void languageChanged(String language, Composite eform, AbstractCamelModelElement expressionElement, Composite page, Parameter prop) {
        Control[] controlArray = eform.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control co = controlArray[n2];
            if (co.getData("fuseExpressionClient") != null) {
                co.dispose();
            }
            ++n2;
        }
        Composite client = this.getWidgetFactory().createComposite(eform);
        client.setData("fuseExpressionClient", (Object)true);
        client.setLayoutData((Object)new GridData(1808));
        client.setLayout((Layout)new GridLayout(4, false));
        AbstractCamelModelElement uiExpressionElement = null;
        if (prop.getName().equalsIgnoreCase("expression")) {
            if (expressionElement != null && !expressionElement.getTranslatedNodeName().equals(language)) {
                Node oldExpNode = null;
                int i = 0;
                while (i < this.selectedEP.getXmlNode().getChildNodes().getLength()) {
                    if (CamelUtils.getTranslatedNodeName((Node)this.selectedEP.getXmlNode().getChildNodes().item(i)).equals(expressionElement.getTranslatedNodeName())) {
                        oldExpNode = this.selectedEP.getXmlNode().getChildNodes().item(i);
                        break;
                    }
                    ++i;
                }
                if (language.trim().length() > 0) {
                    Element expNode = this.selectedEP.createElement(language, this.selectedEP != null && this.selectedEP.getXmlNode() != null ? this.selectedEP.getXmlNode().getPrefix() : null);
                    expressionElement = new CamelBasicModelElement(this.selectedEP, (Node)expNode);
                    this.selectedEP.setParameter(prop.getName(), (Object)expressionElement);
                    this.selectedEP.getXmlNode().replaceChild(expNode, oldExpNode);
                } else {
                    this.selectedEP.getXmlNode().removeChild(oldExpNode);
                    this.selectedEP.removeParameter(prop.getName());
                }
            } else if (expressionElement == null && language.trim().length() > 0) {
                Element expNode = this.selectedEP.createElement(language, this.selectedEP != null && this.selectedEP.getXmlNode() != null ? this.selectedEP.getXmlNode().getPrefix() : null);
                expressionElement = new CamelBasicModelElement(this.selectedEP, (Node)expNode);
                this.selectedEP.getXmlNode().insertBefore(expNode, this.selectedEP.getXmlNode().getFirstChild());
                this.selectedEP.setParameter(prop.getName(), (Object)expressionElement);
            }
            uiExpressionElement = expressionElement;
        } else if (expressionElement != null && expressionElement.getParameter("expression") != null) {
            Node oldExpNode = null;
            List<String> langs = Arrays.asList(CamelComponentUtils.getOneOfList((Parameter)prop));
            int i = 0;
            while (i < expressionElement.getXmlNode().getChildNodes().getLength()) {
                Node n3 = expressionElement.getXmlNode().getChildNodes().item(i);
                if (langs.contains(CamelUtils.getTranslatedNodeName((Node)n3))) {
                    oldExpNode = n3;
                    break;
                }
                ++i;
            }
            AbstractCamelModelElement expElement = (AbstractCamelModelElement)expressionElement.getParameter("expression");
            if (!expElement.getTranslatedNodeName().equals(language)) {
                if (language.trim().length() > 0) {
                    Element expNode = this.selectedEP.createElement(language, this.selectedEP != null && this.selectedEP.getXmlNode() != null ? this.selectedEP.getXmlNode().getPrefix() : null);
                    uiExpressionElement = new CamelBasicModelElement(expressionElement, (Node)expNode);
                    expressionElement.getXmlNode().replaceChild(expNode, oldExpNode);
                    expressionElement.setParameter("expression", (Object)uiExpressionElement);
                } else {
                    this.selectedEP.getXmlNode().removeChild(expressionElement.getXmlNode());
                    this.selectedEP.removeParameter(prop.getName());
                }
            } else {
                uiExpressionElement = expElement;
            }
        } else if (expressionElement != null && expressionElement.getParameter("expression") == null) {
            Element expNode = this.selectedEP.createElement(language, this.selectedEP != null && this.selectedEP.getXmlNode() != null ? this.selectedEP.getXmlNode().getPrefix() : null);
            uiExpressionElement = new CamelBasicModelElement(expressionElement, (Node)expNode);
            expressionElement.getXmlNode().appendChild(expNode);
            expressionElement.setParameter("expression", (Object)uiExpressionElement);
        } else if (expressionElement == null && language.trim().length() > 0) {
            Element expContainerNode = this.selectedEP.createElement(prop.getName(), this.selectedEP != null && this.selectedEP.getXmlNode() != null ? this.selectedEP.getXmlNode().getPrefix() : null);
            Element expNode = this.selectedEP.createElement(language, this.selectedEP != null && this.selectedEP.getXmlNode() != null ? this.selectedEP.getXmlNode().getPrefix() : null);
            CamelBasicModelElement expContainerElement = new CamelBasicModelElement(this.selectedEP, (Node)expContainerNode);
            expressionElement = new CamelBasicModelElement((AbstractCamelModelElement)expContainerElement, (Node)expNode);
            expContainerElement.getXmlNode().appendChild(expNode);
            this.selectedEP.getXmlNode().insertBefore(expContainerNode, this.selectedEP.getXmlNode().getFirstChild());
            expContainerElement.setParameter("expression", (Object)expressionElement);
            this.selectedEP.setParameter(prop.getName(), (Object)expContainerElement);
            uiExpressionElement = expressionElement;
        }
        this.prepareExpressionUIForLanguage(language, uiExpressionElement, client);
        page.layout(true);
        this.refresh();
        eform.layout(true);
        this.aTabbedPropertySheetPage.resizeScrolledComposite();
    }

    protected void prepareExpressionUIForLanguage(String language, AbstractCamelModelElement expressionElement, Composite parent) {
        block3: {
            Language lang;
            CamelModel model;
            block2: {
                model = this.getCamelModel(expressionElement);
                lang = model.getLanguageModel().getLanguageByName(language);
                if (lang == null) break block2;
                ArrayList props = lang.getParameters();
                props.sort(new ParameterPriorityComparator());
                for (Parameter p : props) {
                    this.createPropertyLabel(this.toolkit, parent, p);
                    Control field = this.getControlForParameter(p, parent, expressionElement, (IParameterContainer)lang);
                    field.setToolTipText(p.getDescription());
                }
                break block3;
            }
            Eip eip = model.getEipModel().getEIPByName(language);
            if (eip == null) break block3;
            ArrayList props = eip.getParameters();
            props.sort(new ParameterPriorityComparator());
            for (Parameter p : props) {
                this.createPropertyLabel(this.toolkit, parent, p);
                Control field = this.getControlForParameter(p, parent, expressionElement, (IParameterContainer)lang);
                field.setToolTipText(p.getDescription());
            }
        }
    }

    protected void dataFormatChanged(String dataformat, Composite eform, AbstractCamelModelElement dataFormatElement, Composite page, Parameter prop) {
        Control[] controlArray = eform.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control co = controlArray[n2];
            if (co.getData("fuseDataFormatClient") != null) {
                co.dispose();
            }
            ++n2;
        }
        Composite client = this.getWidgetFactory().createComposite(eform);
        client.setData("fuseDataFormatClient", (Object)true);
        client.setLayoutData((Object)new GridData(1808));
        client.setLayout((Layout)new GridLayout(4, false));
        if (dataFormatElement != null && !dataFormatElement.getTranslatedNodeName().equals(dataformat)) {
            Node oldExpNode = null;
            int i = 0;
            while (i < this.selectedEP.getXmlNode().getChildNodes().getLength()) {
                Node childNode = this.selectedEP.getXmlNode().getChildNodes().item(i);
                if (CamelUtils.getTranslatedNodeName((Node)childNode).equalsIgnoreCase(dataFormatElement.getTranslatedNodeName())) {
                    oldExpNode = childNode;
                    break;
                }
                ++i;
            }
            if (dataformat.trim().length() > 0) {
                Element expNode = this.selectedEP.createElement(dataformat, this.selectedEP != null && this.selectedEP.getXmlNode() != null ? this.selectedEP.getXmlNode().getPrefix() : null);
                dataFormatElement = new CamelBasicModelElement(this.selectedEP, (Node)expNode);
                this.selectedEP.setParameter(prop.getName(), (Object)dataFormatElement);
                this.selectedEP.getXmlNode().replaceChild(expNode, oldExpNode);
            } else {
                this.selectedEP.getXmlNode().removeChild(oldExpNode);
                this.selectedEP.removeParameter(prop.getName());
            }
        } else if (dataFormatElement == null && dataformat.trim().length() > 0) {
            Element expNode = this.selectedEP.createElement(dataformat, this.selectedEP != null && this.selectedEP.getXmlNode() != null ? this.selectedEP.getXmlNode().getPrefix() : null);
            dataFormatElement = new CamelBasicModelElement(this.selectedEP, (Node)expNode);
            this.selectedEP.getXmlNode().insertBefore(expNode, this.selectedEP.getXmlNode().getFirstChild());
            this.selectedEP.setParameter(prop.getName(), (Object)dataFormatElement);
        }
        this.prepareDataFormatUIForDataFormat(dataformat, dataFormatElement, client);
        page.layout(true);
        this.refresh();
        eform.layout(true);
        this.aTabbedPropertySheetPage.resizeScrolledComposite();
    }

    protected void prepareDataFormatUIForDataFormat(String dataformat, AbstractCamelModelElement dataFormatElement, Composite parent) {
        CamelModel model = this.getCamelModel(dataFormatElement);
        DataFormat df = model.getDataformatModel().getDataFormatByName(dataformat);
        if (df != null) {
            ArrayList props = df.getParameters();
            props.sort(new ParameterPriorityComparator());
            for (Parameter p : props) {
                this.createPropertyLabel(this.toolkit, parent, p);
                Control field = this.getControlForParameter(p, parent, dataFormatElement, (IParameterContainer)df);
                field.setToolTipText(p.getDescription());
            }
        }
    }

    protected Control getControlForParameter(final Parameter p, Composite parent, final AbstractCamelModelElement camelModelElement, IParameterContainer parameterContainer) {
        Text c = null;
        if (CamelComponentUtils.isBooleanProperty((Parameter)p)) {
            final Button checkBox = this.getWidgetFactory().createButton(parent, "", 32);
            Boolean b = false;
            if (camelModelElement != null && camelModelElement.getParameter(p.getName()) != null) {
                Object paramValue = camelModelElement.getParameter(p.getName());
                b = paramValue instanceof String ? Boolean.valueOf((String)paramValue) : (Boolean)paramValue;
            } else if (parameterContainer != null) {
                b = Boolean.parseBoolean(parameterContainer.getParameter(p.getName()).getDefaultValue());
            }
            checkBox.setSelection(b.booleanValue());
            checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    camelModelElement.setParameter(p.getName(), (Object)checkBox.getSelection());
                }
            });
            checkBox.setLayoutData((Object)this.createPropertyFieldLayoutData());
            c = checkBox;
        } else if (CamelComponentUtils.isTextProperty((Parameter)p)) {
            String initialTextValue = null;
            if (camelModelElement != null && camelModelElement.getParameter(p.getName()) != null) {
                initialTextValue = (String)camelModelElement.getParameter(p.getName());
            } else if (parameterContainer != null) {
                initialTextValue = parameterContainer.getParameter(p.getName()).getDefaultValue();
            }
            Text txtField = this.getWidgetFactory().createText(parent, initialTextValue, 16388);
            txtField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Text txt = (Text)e.getSource();
                    camelModelElement.setParameter(p.getName(), (Object)txt.getText());
                }
            });
            txtField.setLayoutData((Object)this.createPropertyFieldLayoutData());
            c = txtField;
        } else if (CamelComponentUtils.isNumberProperty((Parameter)p)) {
            String initialValue = null;
            if (camelModelElement != null && camelModelElement.getParameter(p.getName()) != null) {
                initialValue = (String)camelModelElement.getParameter(p.getName());
            } else if (parameterContainer != null) {
                initialValue = parameterContainer.getParameter(p.getName()).getDefaultValue();
            }
            Text txtField = this.getWidgetFactory().createText(parent, initialValue, 131076);
            txtField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Text txt = (Text)e.getSource();
                    String val = txt.getText();
                    try {
                        Double.parseDouble(val);
                        txt.setBackground(ColorConstants.white);
                        camelModelElement.setParameter(p.getName(), (Object)txt.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        txt.setBackground(ColorConstants.red);
                        return;
                    }
                }
            });
            txtField.setLayoutData((Object)this.createPropertyFieldLayoutData());
            c = txtField;
        } else {
            String initialValue = null;
            if (camelModelElement != null && camelModelElement.getParameter(p.getName()) != null) {
                initialValue = (String)camelModelElement.getParameter(p.getName());
            } else if (parameterContainer != null) {
                initialValue = parameterContainer.getParameter(p.getName()).getDefaultValue();
            }
            Text txtField = this.getWidgetFactory().createText(parent, initialValue, 16388);
            txtField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Text txt = (Text)e.getSource();
                    camelModelElement.setParameter(p.getName(), (Object)txt.getText());
                }
            });
            txtField.setLayoutData((Object)this.createPropertyFieldLayoutData());
            c = txtField;
        }
        return c;
    }

    protected void createHelpDecoration(Parameter parameter, Control control) {
        String description = parameter.getDescription();
        if (description != null) {
            ControlDecoration helpDecoration = new ControlDecoration(control, 17408);
            helpDecoration.setShowOnlyOnFocus(true);
            FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
            helpDecoration.setImage(fieldDecoration.getImage());
            helpDecoration.setDescriptionText(description);
            control.setToolTipText(description);
        }
    }

    protected GridData createPropertyFieldLayoutData() {
        return GridDataFactory.fillDefaults().indent(5, 0).span(3, 1).grab(true, false).create();
    }
}

