/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.properties.creators;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.catalog.components.Component;
import org.fusesource.ide.camel.model.service.core.catalog.eips.Eip;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.util.PropertiesUtils;

public abstract class AbstractParameterPropertyUICreator {
    private Control control = null;
    private IValidator validator = null;
    private ISWTObservableValue uiObservable = null;
    private TabbedPropertySheetWidgetFactory widgetFactory;
    protected AbstractCamelModelElement camelModelElement;
    protected Eip eip;
    protected Parameter parameter;
    private DataBindingContext dbc;
    protected IObservableMap modelMap;
    protected Component component = null;
    private Composite parent;

    public AbstractParameterPropertyUICreator(DataBindingContext dbc, IObservableMap modelMap, Eip eip, AbstractCamelModelElement camelModelElement, Parameter parameter, Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        this.dbc = dbc;
        this.modelMap = modelMap;
        this.widgetFactory = widgetFactory;
        this.eip = eip;
        this.camelModelElement = camelModelElement;
        this.parameter = parameter;
        if (camelModelElement.isEndpointElement()) {
            this.component = PropertiesUtils.getComponentFor((AbstractCamelModelElement)camelModelElement);
        }
        this.parent = parent;
    }

    public void create() {
        this.initAndBind(this.parent);
    }

    private void initAndBind(Composite parent) {
        this.init(parent);
        this.bind();
        this.createHelpDecoration(this.parameter, this.getControl());
    }

    private void bind() {
        this.modelMap.put((Object)this.parameter.getName(), this.getInitialValue());
        IObservableValue modelObservable = Observables.observeMapEntry((IObservableMap)this.modelMap, (Object)this.parameter.getName());
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setBeforeSetValidator(this.validator);
        Binding bindValue = this.dbc.bindValue((IObservableValue)this.uiObservable, modelObservable, strategy, null);
        ControlDecorationSupport.create((ValidationStatusProvider)bindValue, (int)16512);
    }

    protected abstract void init(Composite var1);

    public abstract Object getInitialValue();

    public Control getControl() {
        return this.control;
    }

    public IValidator getValidator() {
        return this.validator;
    }

    public ISWTObservableValue getUiObservable() {
        return this.uiObservable;
    }

    protected TabbedPropertySheetWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    protected void setUiObservable(ISWTObservableValue uiObservable) {
        this.uiObservable = uiObservable;
    }

    protected void setControl(Control control) {
        this.control = control;
    }

    protected void setValidator(IValidator validator) {
        this.validator = validator;
    }

    protected GridData createPropertyFieldLayoutData() {
        return GridDataFactory.fillDefaults().indent(5, 0).span(3, 1).grab(true, false).create();
    }

    protected void createHelpDecoration(Parameter parameter, Control control) {
        String description = parameter.getDescription();
        if (description != null) {
            ControlDecoration helpDecoration = new ControlDecoration(control, 17408);
            helpDecoration.setShowOnlyOnFocus(true);
            FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
            helpDecoration.setImage(fieldDecoration.getImage());
            helpDecoration.setDescriptionText(description);
            control.setToolTipText(description);
        }
    }
}

