/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.properties.creators;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.fusesource.ide.camel.editor.properties.creators.AbstractParameterPropertyUICreator;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.catalog.eips.Eip;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.util.PropertiesUtils;

public abstract class AbstractTextFieldParameterPropertyUICreator
extends AbstractParameterPropertyUICreator {
    private ModifyListener modifyListener;

    public AbstractTextFieldParameterPropertyUICreator(DataBindingContext dbc, IObservableMap modelMap, Eip eip, AbstractCamelModelElement camelModelElement, Parameter parameter, Composite parent, TabbedPropertySheetWidgetFactory widgetFactory, ModifyListener modifyListener) {
        super(dbc, modelMap, eip, camelModelElement, parameter, parent, widgetFactory);
        this.modifyListener = modifyListener;
    }

    @Override
    protected void init(Composite parent) {
        Text txtField = this.getWidgetFactory().createText(parent, this.getInitialValue(), this.createTextStyle());
        txtField.addModifyListener(this.modifyListener);
        txtField.setLayoutData((Object)this.createPropertyFieldLayoutData());
        this.setControl((Control)txtField);
        this.setUiObservable(WidgetProperties.text((int)24).observe((Widget)txtField));
        this.setValidator(this.createValidator());
    }

    protected int createTextStyle() {
        return 18436;
    }

    protected IValidator createValidator() {
        return new IValidator(){

            public IStatus validate(Object value) {
                if (PropertiesUtils.isRequired((Parameter)AbstractTextFieldParameterPropertyUICreator.this.parameter) && (value == null || value.toString().trim().length() < 1)) {
                    return ValidationStatus.error((String)("Parameter " + AbstractTextFieldParameterPropertyUICreator.this.parameter.getName() + " is a mandatory field and cannot be empty."));
                }
                return ValidationStatus.ok();
            }
        };
    }

    @Override
    public String getInitialValue() {
        String parameterName = this.parameter.getName();
        Object parameterValue = this.camelModelElement.getParameter(parameterName);
        return (String)(parameterValue != null ? parameterValue : this.eip.getParameter(parameterName).getDefaultValue());
    }

    public Text getControl() {
        return (Text)super.getControl();
    }
}

