/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.fusesource.ide.camel.editor.features.create.ext.CreateEndpointFigureFeature;
import org.fusesource.ide.camel.editor.provider.ActiveMQPaletteEntryDependenciesManager;
import org.fusesource.ide.camel.editor.provider.ext.ICustomPaletteEntry;
import org.fusesource.ide.camel.editor.utils.CamelUtils;
import org.fusesource.ide.camel.model.service.core.catalog.Dependency;

public class ActiveMQPaletteEntry
implements ICustomPaletteEntry {
    private static final String PROTOCOL = "activemq";

    @Override
    public ICreateFeature newCreateFeature(IFeatureProvider fp) {
        return new CreateEndpointFigureFeature(fp, "ActiveMQ", "Creates an ActiveMQ endpoint...", "activemq:queue:foo", this.getRequiredDependencies());
    }

    @Override
    public String getProtocol() {
        return PROTOCOL;
    }

    @Override
    public boolean providesProtocol(String protocol) {
        return PROTOCOL.equalsIgnoreCase(protocol);
    }

    @Override
    public List<Dependency> getRequiredDependencies() {
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        deps.add(this.createDependency("org.apache.activemq", "activemq-camel", new ActiveMQPaletteEntryDependenciesManager().getActiveMQVersion(CamelUtils.getCurrentProjectCamelVersion())));
        deps.add(this.createDependency("org.apache.camel", "camel-jms", CamelUtils.getCurrentProjectCamelVersion()));
        return deps;
    }

    private Dependency createDependency(String groupId, String artifactId, String version) {
        Dependency dep = new Dependency();
        dep.setGroupId(groupId);
        dep.setArtifactId(artifactId);
        dep.setVersion(version);
        return dep;
    }
}

