/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.provider;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.fusesource.ide.camel.editor.provider.ext.IDependenciesManager;
import org.fusesource.ide.foundation.core.util.Strings;

public class ActiveMQPaletteEntryDependenciesManager
implements IDependenciesManager {
    public static final String RED_HAT_SUFFIX = ".redhat-";
    public static final Map<String, String> camelToAMQVersionMapping = new HashMap<String, String>();
    public static final String LATEST_AMQ_VERSION = "5.11.0";
    static final String ACTIVEMQ_CAMEL = "activemq-camel";
    static final String ORG_APACHE_ACTIVEMQ = "org.apache.activemq";

    static {
        camelToAMQVersionMapping.put("2.15.1", LATEST_AMQ_VERSION);
        camelToAMQVersionMapping.put("2.17.0", LATEST_AMQ_VERSION);
        camelToAMQVersionMapping.put("2.17.3", LATEST_AMQ_VERSION);
    }

    @Override
    public void updatePluginDependencies(List<Plugin> currentPlugins, String camelVersion) {
    }

    @Override
    public void updateDependencies(List<Dependency> currentDependencies, String camelVersion) {
        for (Dependency dependency : currentDependencies) {
            if (!this.isActiveMQCamelDependency(dependency)) continue;
            dependency.setVersion(this.getActiveMQVersion(camelVersion));
            return;
        }
    }

    private boolean isActiveMQCamelDependency(Dependency dependency) {
        return ORG_APACHE_ACTIVEMQ.equals(dependency.getGroupId()) && ACTIVEMQ_CAMEL.equals(dependency.getArtifactId());
    }

    String getActiveMQVersion(String camelVersion) {
        boolean productizedVersion = camelVersion.indexOf(RED_HAT_SUFFIX) != -1;
        String key = this.getVersionWithoutIdentifier(camelVersion);
        String amqVersion = camelToAMQVersionMapping.get(key);
        if (amqVersion != null) {
            if (productizedVersion) {
                return String.format("%s%s%s", amqVersion, RED_HAT_SUFFIX, this.getBuildNumberFromVersion(camelVersion));
            }
            return amqVersion;
        }
        return LATEST_AMQ_VERSION;
    }

    String getBuildNumberFromVersion(String camelVersion) {
        if (camelVersion.split("\\.").length > 3) {
            return camelVersion.substring(camelVersion.lastIndexOf(45) + 1);
        }
        throw new IllegalArgumentException("Camel version " + camelVersion + " has no valid format for retrieving the build number.");
    }

    String getVersionWithoutIdentifier(String camelVersion) {
        String[] versionParts;
        if (!Strings.isEmpty((String)camelVersion) && (versionParts = camelVersion.split("\\.")).length > 2) {
            return String.format("%s.%s.%s", versionParts[0], versionParts[1], versionParts[2]);
        }
        throw new IllegalArgumentException("Given Camel Version " + camelVersion + " doesn't contain a valid value");
    }
}

