/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.provider;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.tb.IContextMenuEntry;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.DiagramEditorContextMenuProvider;
import org.eclipse.graphiti.ui.internal.action.CustomAction;
import org.eclipse.graphiti.ui.platform.IConfigurationProvider;
import org.eclipse.graphiti.util.ILocationInfo;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;

public class CamelDiagramEditorContextMenuProvider
extends DiagramEditorContextMenuProvider {
    private IConfigurationProvider configurationProvider;

    public CamelDiagramEditorContextMenuProvider(EditPartViewer viewer, ActionRegistry registry, IConfigurationProvider configurationProvider) {
        super(viewer, registry, configurationProvider);
        this.configurationProvider = configurationProvider;
    }

    protected void addDefaultMenuGroupRest(IMenuManager manager) {
        this.addAlignmentSubMenu(manager, "org.eclipse.gef.group.rest");
        PictogramElement[] pes = this.getBehavior().getSelectedPictogramElements();
        CustomContext context = new CustomContext(pes);
        IToolBehaviorProvider tb = this.getConfigurationProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
        IContextMenuEntry[] contextMenuEntries = tb.getContextMenu((ICustomContext)context);
        int lastIndex = contextMenuEntries.length - 1;
        IContextMenuEntry addEntries = contextMenuEntries[lastIndex];
        this.addEntry(manager, addEntries, (ICustomContext)context, "group.add", null);
        this.addActionToMenuIfAvailable(manager, "predefined remove action", "group.add");
        this.getConfigurationProvider().getFeatureProvider();
        IContextMenuEntry[] otherEntries = new IContextMenuEntry[lastIndex];
        System.arraycopy(contextMenuEntries, 0, otherEntries, 0, lastIndex);
        this.addEntries(manager, otherEntries, (ICustomContext)context, "org.eclipse.gef.group.rest", null);
        if (pes.length == 1) {
            this.extendCustomContext(pes[0], context);
        }
    }

    private IConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    private DiagramBehavior getBehavior() {
        return this.getConfigurationProvider().getDiagramBehavior();
    }

    private void addEntries(IMenuManager manager, IContextMenuEntry[] contextMenuEntries, ICustomContext context, String groupID, String textParentEntry) {
        int i = 0;
        while (i < contextMenuEntries.length) {
            IContextMenuEntry cmEntry = contextMenuEntries[i];
            this.addEntry(manager, cmEntry, context, groupID, textParentEntry);
            ++i;
        }
    }

    protected void addEntry(IMenuManager manager, IContextMenuEntry cmEntry, ICustomContext context, String groupID, String textParentEntry) {
        String text = cmEntry.getText();
        IContextMenuEntry[] children = cmEntry.getChildren();
        if (children.length == 0) {
            IFeature feature = cmEntry.getFeature();
            if (feature instanceof ICustomFeature && feature.isAvailable((IContext)context)) {
                CustomAction action = new CustomAction((ICustomFeature)feature, context, this.getBehavior());
                if (textParentEntry != null) {
                    text = String.valueOf(textParentEntry) + " " + text;
                }
                action.setText(text);
                action.setDescription(cmEntry.getDescription());
                ImageDescriptor image = CamelEditorUIActivator.getDefault().getImageDescriptor(cmEntry.getIconId());
                action.setImageDescriptor(image);
                this.appendContributionItem(manager, groupID, (IContributionItem)new ActionContributionItem((IAction)action));
            }
        } else if (cmEntry.isSubmenu()) {
            MenuManager subMenu = new MenuManager(text);
            this.addEntries((IMenuManager)subMenu, children, context, null, null);
            if (!subMenu.isEmpty()) {
                this.appendContributionItem(manager, groupID, (IContributionItem)subMenu);
            }
        } else {
            this.appendContributionItem(manager, groupID, (IContributionItem)new Separator());
            this.addEntries(manager, children, context, groupID, text);
            this.appendContributionItem(manager, groupID, (IContributionItem)new Separator());
        }
    }

    private void appendContributionItem(IMenuManager manager, String groupID, IContributionItem contributionItem) {
        if (groupID != null) {
            manager.appendToGroup(groupID, contributionItem);
        } else {
            manager.add(contributionItem);
        }
    }

    private void extendCustomContext(PictogramElement pe, CustomContext context) {
        GraphicsAlgorithm ga;
        Point location = this.getBehavior().getMouseLocation();
        int mX = location.x;
        int mY = location.y;
        context.setX(mX);
        context.setY(mY);
        if (pe instanceof Shape && !(pe instanceof Diagram) && (ga = pe.getGraphicsAlgorithm()) != null) {
            ILocation relLocation = Graphiti.getPeService().getLocationRelativeToDiagram((Shape)pe);
            int x = relLocation.getX();
            int y = relLocation.getY();
            int width = ga.getWidth();
            int height = ga.getHeight();
            if (mX > x && mX < x + width && mY > y && mY < y + height) {
                int relativeX = mX - x;
                int relativeY = mY - y;
                ILocationInfo locationInfo = Graphiti.getLayoutService().getLocationInfo((Shape)pe, relativeX, relativeY);
                context.setInnerPictogramElement((PictogramElement)locationInfo.getShape());
                context.setInnerGraphicsAlgorithm(locationInfo.getGraphicsAlgorithm());
            }
        }
    }
}

