/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.model.Resource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.swt.widgets.Display;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.editor.internal.UIMessages;
import org.fusesource.ide.camel.editor.utils.CamelUtils;
import org.fusesource.ide.camel.model.service.core.catalog.Dependency;

public class MavenUtils {
    private static final String CAMEL_GROUP_ID = "org.apache.camel";
    private static final String CAMEL_CORE_ARTIFACT_ID = "camel-core";
    private static final String SCOPE_PROVIDED = "provided";
    private static final String MAIN_PATH = "src/main/";
    public static final String RESOURCES_PATH = "src/main/resources/";
    private static final String JAVA_PATH = "src/main/java/";

    public String javaSourceFolder() throws CoreException {
        String name = this.readMavenModel(this.getPomFile(CamelUtils.project())).getBuild().getSourceDirectory();
        if (name == null) {
            return JAVA_PATH;
        }
        return name.endsWith("/") ? name : String.valueOf(name) + "/";
    }

    public void updateMavenDependencies(final List<Dependency> compDeps) throws CoreException {
        final IProject project = CamelUtils.project();
        if (project == null) {
            CamelEditorUIActivator.pluginLog().logWarning("Unable to add component dependencies because selected project can't be determined. Maybe this is a remote camel context.");
            return;
        }
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(UIMessages.updatePomDependenciesProgressDialogLabel, 100);
                    try {
                        MavenUtils.this.updateMavenDependencies(compDeps, project);
                    }
                    catch (CoreException ex) {
                        CamelEditorUIActivator.pluginLog().logError((Throwable)ex);
                    }
                    monitor.done();
                }
            });
        }
        catch (Exception ex) {
            CamelEditorUIActivator.pluginLog().logError((Throwable)ex);
        }
    }

    protected void updateMavenDependencies(List<Dependency> compDeps, IProject project) throws CoreException {
        File pomFile = this.getPomFile(project);
        Model model = this.readMavenModel(pomFile);
        List<org.apache.maven.model.Dependency> deps = this.getDependencies(project, model);
        ArrayList<Dependency> missingDeps = new ArrayList<Dependency>();
        String scope = null;
        for (Dependency conDep : compDeps) {
            boolean found = false;
            for (org.apache.maven.model.Dependency pomDep : deps) {
                if (scope == null && pomDep.getGroupId().equalsIgnoreCase(CAMEL_GROUP_ID) && pomDep.getArtifactId().equalsIgnoreCase(CAMEL_CORE_ARTIFACT_ID) && SCOPE_PROVIDED.equalsIgnoreCase(pomDep.getScope())) {
                    scope = pomDep.getScope();
                }
                if (!pomDep.getGroupId().equalsIgnoreCase(conDep.getGroupId()) || !pomDep.getArtifactId().equalsIgnoreCase(conDep.getArtifactId())) continue;
                if (pomDep.getVersion() == null || !pomDep.getVersion().equalsIgnoreCase(conDep.getVersion())) {
                    pomDep.setVersion(conDep.getVersion());
                }
                found = true;
                break;
            }
            if (found) continue;
            missingDeps.add(conDep);
        }
        this.addDependency(model, missingDeps, scope);
        if (missingDeps.size() > 0) {
            this.writeNewPomFile(project, pomFile, model);
        }
    }

    Model readMavenModel(File pomFile) throws CoreException {
        return MavenPlugin.getMaven().readModel(pomFile);
    }

    File getPomFile(IProject project) {
        IPath pomPathValue = project.getProject().getRawLocation() != null ? project.getProject().getRawLocation().append("pom.xml") : ResourcesPlugin.getWorkspace().getRoot().getLocation().append(project.getFullPath().append("pom.xml"));
        String pomPath = pomPathValue.toOSString();
        return new File(pomPath);
    }

    void writeNewPomFile(IProject project, File pomFile, Model model) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(pomFile));){
                MavenPlugin.getMaven().writeModel(model, (OutputStream)os);
                IFile pomIFile2 = project.getProject().getFile("pom.xml");
                if (pomIFile2 != null) {
                    pomIFile2.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            CamelEditorUIActivator.pluginLog().logError((Throwable)ex);
        }
    }

    void addDependency(Model model, List<Dependency> missingDeps, String scope) {
        for (Dependency missDep : missingDeps) {
            org.apache.maven.model.Dependency dep = new org.apache.maven.model.Dependency();
            dep.setGroupId(missDep.getGroupId());
            dep.setArtifactId(missDep.getArtifactId());
            dep.setVersion(missDep.getVersion());
            if (scope != null) {
                dep.setScope(scope);
            }
            model.addDependency(dep);
        }
    }

    private List<org.apache.maven.model.Dependency> getDependencies(IProject project, Model model) {
        List deps;
        IMavenProjectFacade projectFacade = this.getMavenProjectFacade(project);
        if (projectFacade != null) {
            try {
                deps = projectFacade.getMavenProject((IProgressMonitor)new NullProgressMonitor()).getDependencies();
            }
            catch (CoreException e) {
                CamelEditorUIActivator.pluginLog().logError("Maven project has not been found (not imported?). Managed Dependencies won't be resolved.", (Throwable)e);
                deps = model.getDependencies();
            }
        } else {
            deps = model.getDependencies();
        }
        return deps;
    }

    IMavenProjectFacade getMavenProjectFacade(IProject project) {
        IMavenProjectRegistry projectRegistry = MavenPlugin.getMavenProjectRegistry();
        IFile pomIFile = project.getFile((IPath)new Path("pom.xml"));
        return projectRegistry.create(pomIFile, false, (IProgressMonitor)new NullProgressMonitor());
    }

    public void addResourceFolder(IProject project, File pomFile, String resourceFolderName) throws CoreException {
        Model model = this.readMavenModel(pomFile);
        List resources = model.getBuild().getResources();
        boolean exists = false;
        for (Resource resource : resources) {
            if (!resource.getDirectory().equals(resourceFolderName)) continue;
            exists = true;
            break;
        }
        if (!exists) {
            Resource resource;
            resource = new Resource();
            resource.setDirectory(resourceFolderName);
            model.getBuild().addResource(resource);
            try {
                Object object = null;
                Object var9_11 = null;
                try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(pomFile));){
                    MavenPlugin.getMaven().writeModel(model, (OutputStream)os);
                    IFile pomIFile = project.getFile("pom.xml");
                    if (pomIFile != null) {
                        pomIFile.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    throw object;
                }
            }
            catch (Exception ex) {
                CamelEditorUIActivator.pluginLog().logError((Throwable)ex);
            }
        }
    }
}

