/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.utils;

import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.internal.parts.ContainerShapeEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.fusesource.ide.camel.editor.utils.CamelUtils;
import org.fusesource.ide.camel.editor.utils.DiagramUtils;
import org.fusesource.ide.camel.model.service.core.catalog.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.CamelModelFactory;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.catalog.eips.Eip;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelContextElement;
import org.fusesource.ide.camel.model.service.core.model.CamelElementConnection;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteElement;
import org.fusesource.ide.foundation.ui.tree.HasOwner;

public class NodeUtils {
    public static String getPropertyName(Object id) {
        String propertyName = id.toString();
        int idx = propertyName.indexOf(46);
        if (idx > 0) {
            propertyName = propertyName.substring(idx + 1);
        }
        propertyName = String.valueOf(propertyName.substring(0, 1).toLowerCase()) + propertyName.substring(1);
        return propertyName;
    }

    public static boolean isMandatory(Object bean, String propertyName) {
        AbstractCamelModelElement node;
        Eip eip;
        Parameter p;
        if (bean instanceof AbstractCamelModelElement && (p = (eip = (node = (AbstractCamelModelElement)bean).getUnderlyingMetaModelObject()).getParameter(propertyName)) != null) {
            return p.getRequired().equals("true");
        }
        return false;
    }

    public static boolean isValidChild(AbstractCamelModelElement parent, AbstractCamelModelElement child) {
        if (parent != null && child != null) {
            String camelVersion = CamelUtils.getCurrentProjectCamelVersion();
            CamelModel metaModel = CamelModelFactory.getModelForVersion((String)camelVersion);
            if ("choice".equalsIgnoreCase(parent.getNodeTypeId())) {
                return "when".equalsIgnoreCase(child.getNodeTypeId()) || "otherwise".equalsIgnoreCase(child.getNodeTypeId()) && (parent.getParameter("otherwise") == null || parent.getParameter("otherwise") == child);
            }
            if ("route".equalsIgnoreCase(parent.getNodeTypeId())) {
                return !"route".equalsIgnoreCase(child.getNodeTypeId());
            }
            Eip containerEip = parent.getUnderlyingMetaModelObject();
            if (containerEip == null) {
                containerEip = metaModel.getEipModel().getEIPByName(parent.getNodeTypeId());
            }
            return containerEip != null && containerEip.canHaveChildren() && containerEip.getAllowedChildrenNodeTypes().contains(child.getNodeTypeId());
        }
        return false;
    }

    public static boolean isValidChild(AbstractCamelModelElement parent, Eip child) {
        return parent.getUnderlyingMetaModelObject().canHaveChildren() && (parent.getUnderlyingMetaModelObject().getAllowedChildrenNodeTypes().contains(child.getName()) || child.getName().equalsIgnoreCase("otherwise") && parent.getUnderlyingMetaModelObject().getName().equalsIgnoreCase("choice"));
    }

    public static void getAllContainers(IFeatureProvider fp, AbstractCamelModelElement context, List<PictogramElement> pes) {
        if (context instanceof CamelRouteElement) {
            pes.add(fp.getDiagramTypeProvider().getFeatureProvider().getPictogramElementForBusinessObject((Object)context));
        }
        for (AbstractCamelModelElement cme : context.getChildElements()) {
            if (cme.getUnderlyingMetaModelObject() != null && cme.getUnderlyingMetaModelObject().canHaveChildren()) {
                pes.add(fp.getDiagramTypeProvider().getFeatureProvider().getPictogramElementForBusinessObject((Object)cme));
            }
            if (cme.getChildElements().size() <= 0) continue;
            NodeUtils.getAllContainers(fp, cme, pes);
        }
    }

    public static AbstractCamelModelElement toCamelElement(Object input) {
        ContainerShapeEditPart editPart;
        Object answer = null;
        if (input instanceof AbstractCamelModelElement) {
            return (AbstractCamelModelElement)input;
        }
        if (input instanceof ContainerShapeEditPart) {
            editPart = (ContainerShapeEditPart)input;
            PictogramElement element = editPart.getPictogramElement();
            if (CamelUtils.getDiagramEditor() != null) {
                answer = element != null && element instanceof Diagram ? (CamelUtils.getDiagramEditor().getSelectedContainer() != null ? CamelUtils.getDiagramEditor().getSelectedContainer() : CamelUtils.getDiagramEditor().getModel()) : (AbstractCamelModelElement)CamelUtils.getDiagramEditor().getFeatureProvider().getBusinessObjectForPictogramElement(element);
            }
        } else if (input instanceof AbstractEditPart) {
            editPart = (AbstractEditPart)input;
            Object model = editPart.getModel();
            answer = NodeUtils.toCamelElement(model);
        } else if (input instanceof ContainerShape) {
            ContainerShape shape = (ContainerShape)input;
            answer = (AbstractCamelModelElement)CamelUtils.getDiagramEditor().getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)shape);
        }
        if (input != null && answer == null) {
            answer = (AbstractCamelModelElement)Platform.getAdapterManager().getAdapter(input, AbstractCamelModelElement.class);
        }
        if (answer == null && input instanceof HasOwner) {
            HasOwner ho = (HasOwner)input;
            answer = NodeUtils.toCamelElement(ho.getOwner());
        }
        return answer;
    }

    public static AbstractCamelModelElement getSelectedNode(ISelection selection) {
        AbstractCamelModelElement answer = null;
        if (selection instanceof IStructuredSelection) {
            Object input = ((IStructuredSelection)selection).getFirstElement();
            answer = NodeUtils.toCamelElement(input);
        }
        return answer;
    }

    public static void setSelectedNode(final AbstractCamelModelElement node, final IFeatureProvider fp) {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                PictogramElement pe = fp.getPictogramElementForBusinessObject((Object)node);
                fp.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer().selectPictogramElements(new PictogramElement[]{pe});
            }
        });
    }

    public static AbstractCamelModelElement getNode(IFeatureProvider fp, Anchor anchor) {
        Object obj;
        if (anchor != null && (obj = fp.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent())) instanceof AbstractCamelModelElement) {
            return (AbstractCamelModelElement)obj;
        }
        return null;
    }

    public static void deleteBOFromModel(IFeatureProvider fp, AbstractCamelModelElement nodeToRemove) {
        if (nodeToRemove == null || nodeToRemove instanceof CamelContextElement) {
            return;
        }
        if (nodeToRemove.getParent() != null) {
            nodeToRemove.getParent().removeChildElement(nodeToRemove);
        }
        if (nodeToRemove.getInputElement() != null && nodeToRemove.getOutputElement() != null) {
            AbstractCamelModelElement src = nodeToRemove.getInputElement();
            AbstractCamelModelElement dest = nodeToRemove.getOutputElement();
            nodeToRemove.setInputElement(null);
            nodeToRemove.setOutputElement(null);
            src.setOutputElement(null);
            dest.setInputElement(null);
        } else if (nodeToRemove.getInputElement() != null) {
            nodeToRemove.getInputElement().setOutputElement(null);
        } else if (nodeToRemove.getOutputElement() != null) {
            nodeToRemove.getOutputElement().setInputElement(null);
        }
    }

    public static void deleteFlowFromModel(CamelElementConnection bo) {
        bo.disconnect();
    }

    public static void reconnectNodes(IFeatureProvider fp, AbstractCamelModelElement oldInput, AbstractCamelModelElement oldOutput) {
        PictogramElement srcState = fp.getPictogramElementForBusinessObject((Object)oldInput);
        PictogramElement destState = fp.getPictogramElementForBusinessObject((Object)oldOutput);
        Anchor srcAnchor = DiagramUtils.getAnchor(srcState);
        Anchor destAnchor = DiagramUtils.getAnchor(destState);
        CreateConnectionContext ctx = new CreateConnectionContext();
        ctx.setSourcePictogramElement(srcState);
        ctx.setSourceAnchor(srcAnchor);
        ctx.setTargetPictogramElement(destState);
        ctx.setTargetAnchor(destAnchor);
        if (fp.getCreateConnectionFeatures()[0] != null && fp.getCreateConnectionFeatures()[0].canExecute((IContext)ctx)) {
            fp.getCreateConnectionFeatures()[0].execute((IContext)ctx);
        }
    }
}

