/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.file;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.ui.wizards.ConnectionProfileDetailsPage;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizard;
import org.eclipse.datatools.enablement.oda.xml.util.XMLSourceFromPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.datatools.profiles.file.FlatFileUrlConnectionProfileWizard;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;

public class FlatFileUrlProfileDetailsWizardPage
extends ConnectionProfileDetailsPage
implements Listener,
DatatoolsUiConstants {
    private Composite scrolled;
    private Label profileLabel;
    private CLabel profileText;
    private Label descriptionLabel;
    private Text descriptionText;
    private Label urlLabel;
    private Text urlText;

    public FlatFileUrlProfileDetailsWizardPage(String pageName) {
        super(pageName, UTIL.getString("FlatFileUrlProfileDetailsWizardPage.Name", new Object[0]), AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.teiid.designer.datatools.ui", (String)"icons/ldap.gif"));
    }

    public void createCustomControl(Composite parent) {
        Group group = WidgetFactory.createSimpleGroup((Composite)parent, (String)UTIL.getString("Common.Properties.Label", new Object[0]));
        this.scrolled = new Composite((Composite)group, 2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.scrolled.setLayout((Layout)gridLayout);
        this.profileLabel = new Label(this.scrolled, 0);
        this.profileLabel.setText(UTIL.getString("Common.Profile.Label", new Object[0]));
        this.profileText = WidgetFactory.createLabel((Composite)this.scrolled, (int)2052);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        this.profileText.setLayoutData((Object)gd);
        this.profileText.setText(((FlatFileUrlConnectionProfileWizard)this.getWizard()).getProfileName());
        this.descriptionLabel = new Label(this.scrolled, 0);
        this.descriptionLabel.setText(UTIL.getString("Common.Description.Label", new Object[0]));
        gd = new GridData();
        this.descriptionLabel.setLayoutData((Object)gd);
        this.descriptionText = WidgetFactory.createTextBox((Composite)this.scrolled, (int)2060, (int)4);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.descriptionText.setLayoutData((Object)gd);
        String description = ((FlatFileUrlConnectionProfileWizard)this.getWizard()).getProfileDescription();
        this.descriptionText.setText(description);
        this.descriptionText.setBackground(Display.getCurrent().getSystemColor(19));
        this.urlLabel = new Label(this.scrolled, 0);
        this.urlLabel.setText(UTIL.getString("Common.URL.Label", new Object[0]));
        this.urlLabel.setToolTipText(UTIL.getString("Common.URL.ToolTip", new Object[0]));
        gd = new GridData();
        this.urlLabel.setLayoutData((Object)gd);
        this.urlText = new Text(this.scrolled, 2052);
        this.urlText.setToolTipText(UTIL.getString("Common.URL.ToolTip", new Object[0]));
        gd = new GridData(768);
        this.urlText.setLayoutData((Object)gd);
        Group descriptionGroup = WidgetFactory.createGroup((Composite)this.scrolled, (String)UTIL.getString("Common.Description", new Object[0]), (int)768, (int)3);
        Text descriptionText = new Text((Composite)descriptionGroup, 72);
        gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = 150;
        gd.widthHint = 300;
        descriptionText.setLayoutData((Object)gd);
        descriptionText.setText(UTIL.getString("FlatFileUrlProfileDetailsWizardPage.descriptionMessage", new Object[0]));
        descriptionText.setBackground(this.scrolled.getBackground());
        descriptionText.setForeground(Display.getCurrent().getSystemColor(10));
        this.setPingButtonVisible(true);
        this.setPingButtonEnabled(false);
        this.setAutoConnectOnFinishDefault(false);
        this.setCreateAutoConnectControls(false);
        this.setShowAutoConnect(false);
        this.setShowAutoConnectOnFinish(false);
        this.setPageComplete(false);
        this.addListeners();
    }

    private void addListeners() {
        this.urlText.addListener(24, (Listener)this);
    }

    public void handleEvent(Event event) {
        if (event.widget == this.urlText) {
            Properties properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
            properties.setProperty("URL", this.urlText.getText());
        }
        this.updateState();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.updateState();
    }

    void updateState() {
        this.setPingButtonVisible(true);
        this.setPingButtonEnabled(false);
        this.profileText.setText(((NewConnectionProfileWizard)this.getWizard()).getProfileName());
        this.descriptionText.setText(((NewConnectionProfileWizard)this.getWizard()).getProfileDescription());
        final Properties properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
        String urlStr = (String)properties.get("URL");
        if (CoreStringUtil.isEmpty((String)urlStr)) {
            this.setErrorMessage(UTIL.getString("Common.URL.Error.Message", new Object[0]));
            return;
        }
        this.setErrorMessage(null);
        final Display display = this.getControl().getDisplay();
        UiBusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            @Override
            public void run() {
                String urlString = properties.get("URL").toString();
                final String[] errorMessage = new String[1];
                try {
                    new URL(urlString);
                }
                catch (Exception exception) {
                    errorMessage[0] = UTIL.getString("FlatFileUrlProfileDetailsWizardPage.InvalidFile.Message", (Object)urlString);
                }
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        FlatFileUrlProfileDetailsWizardPage.this.setPingButtonEnabled(true);
                        if (errorMessage[0] != null) {
                            FlatFileUrlProfileDetailsWizardPage.this.setErrorMessage(errorMessage[0]);
                            return;
                        }
                        FlatFileUrlProfileDetailsWizardPage.this.setErrorMessage(null);
                        FlatFileUrlProfileDetailsWizardPage.this.setPageComplete(true);
                        FlatFileUrlProfileDetailsWizardPage.this.setMessage(UTIL.getString("Click.Next.or.Finish", new Object[0]));
                    }
                });
            }
        });
    }

    public boolean canFlipToNextPage() {
        return this.internalComplete(super.canFlipToNextPage());
    }

    private boolean internalComplete(boolean complete) {
        Properties properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
        String urlStr = (String)properties.get("URL");
        if (complete && CoreStringUtil.isEmpty((String)urlStr)) {
            complete = false;
        }
        return complete;
    }

    public List getSummaryData() {
        List result = super.getSummaryData();
        result.add(new String[]{UTIL.getString("Common.URL.Label", new Object[0]), this.urlText.getText()});
        return result;
    }

    public void testConnection() {
        super.testConnection();
    }

    protected Runnable createTestConnectionRunnable(IConnectionProfile profile) {
        final URLPingJob pingJob = new URLPingJob(this.getShell(), profile);
        pingJob.schedule();
        return new Runnable(){

            @Override
            public void run() {
                try {
                    pingJob.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        };
    }

    public class URLPingJob
    extends Job {
        private IConnectionProfile icp;
        private Shell shell;

        public URLPingJob(Shell shell, IConnectionProfile profile) {
            super(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.job"));
            this.setSystem(false);
            this.setUser(true);
            this.shell = shell;
            this.icp = profile;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.title"), -1);
            Exception exception = this.testUrlConnection(this.icp);
            monitor.done();
            new UrlPingUIJob(this.shell, exception).schedule();
            return Status.OK_STATUS;
        }

        public Exception testUrlConnection(IConnectionProfile icp) {
            Properties connProperties = icp.getBaseProperties();
            String xmlFile = connProperties == null ? null : (String)connProperties.get("URL");
            try {
                InputStream is = new XMLSourceFromPath(xmlFile, null).openInputStream();
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            catch (OdaException odaEx) {
                return odaEx;
            }
            return null;
        }

        public Throwable getTestConnectionException(IConnection conn) {
            return conn != null ? conn.getConnectException() : new RuntimeException(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.failure"));
        }

        public class UrlPingUIJob
        extends UIJob {
            private Shell shell;
            private Throwable exception;

            public UrlPingUIJob(Shell shell, Throwable exception) {
                super(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.uijob"));
                this.setSystem(false);
                this.exception = exception;
                this.shell = shell;
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                this.showTestConnectionMessage(this.shell, this.exception);
                return Status.OK_STATUS;
            }

            public void showTestConnectionMessage(Shell shell, Throwable exception) {
                if (exception == null) {
                    MessageDialog.openInformation((Shell)shell, (String)ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.success"), (String)ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.success"));
                    FlatFileUrlProfileDetailsWizardPage.this.updateState();
                } else {
                    ExceptionHandler.showException((Shell)shell, (String)ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), (String)ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.failure"), (Throwable)exception);
                    FlatFileUrlProfileDetailsWizardPage.this.setErrorMessage(exception.getMessage());
                    FlatFileUrlProfileDetailsWizardPage.this.updateState();
                }
            }
        }
    }
}

