/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.ldap;

import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.ui.wizards.ProfileDetailsPropertyPage;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.designer.datatools.profiles.ldap.ILdapProfileConstants;
import org.teiid.designer.datatools.profiles.ldap.widget.LdapAuthenticationWidget;
import org.teiid.designer.datatools.profiles.ldap.widget.LdapSettingsWidget;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.datatools.ui.DatatoolsUiPlugin;

public class PropertyPage
extends ProfileDetailsPropertyPage
implements IContextProvider,
DatatoolsUiConstants,
IChangeListener,
ILdapProfileConstants {
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(DatatoolsUiPlugin.getDefault().getBundle().getSymbolicName());
    private TabFolder tabFolder;
    private Properties newProperties = new Properties();

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.setPingButtonEnabled(true);
        this.setPingButtonVisible(true);
        return result;
    }

    protected void createCustomContents(Composite parent) {
        Properties oldProperties = this.getConnectionProfile().getBaseProperties();
        for (Map.Entry<Object, Object> entry : oldProperties.entrySet()) {
            this.newProperties.put(entry.getKey(), entry.getValue());
        }
        this.tabFolder = new TabFolder(parent, 128);
        TabItem[] tabs = new TabItem[2];
        tabs[0] = new TabItem(this.tabFolder, 0);
        LdapSettingsWidget settingsWidget = new LdapSettingsWidget((Composite)this.tabFolder, 0, this.newProperties);
        settingsWidget.addChangeListener(this);
        tabs[0].setText(settingsWidget.getTitle());
        tabs[0].setControl((Control)settingsWidget);
        tabs[0] = new TabItem(this.tabFolder, 0);
        LdapAuthenticationWidget authWidget = new LdapAuthenticationWidget((Composite)this.tabFolder, 0, this.newProperties);
        authWidget.addChangeListener(this);
        tabs[0].setText(authWidget.getTitle());
        tabs[0].setControl((Control)authWidget);
    }

    protected void validate() {
        boolean hasUser;
        String errorMessage = null;
        boolean valid = true;
        if (this.newProperties.get("LdapUrl") == null || this.newProperties.getProperty("LdapUrl").isEmpty()) {
            errorMessage = UTIL.getString("Common.URL.Error.Message", new Object[0]);
            valid = false;
        }
        if (this.newProperties.get("LdapContextFactory") == null || this.newProperties.getProperty("LdapContextFactory").isEmpty()) {
            this.setErrorMessage(UTIL.getString("Common.Context.Factory.Error.Message", new Object[0]));
            valid = false;
        }
        boolean authSimple = "simple".equals(this.newProperties.getProperty("LdapAuthenticationMethod"));
        boolean hasPassword = this.newProperties.get("LdapAdminUserPassword") != null && !this.newProperties.getProperty("LdapAdminUserPassword").isEmpty();
        boolean bl = hasUser = this.newProperties.get("LdapAdminUserDN") != null && !this.newProperties.getProperty("LdapAdminUserDN").isEmpty();
        if (authSimple && !hasPassword) {
            this.setErrorMessage(UTIL.getString("Common.Password.Error.Message", new Object[0]));
            valid = false;
        } else if (authSimple && !hasUser) {
            this.setErrorMessage(UTIL.getString("Common.Username.Error.Message", new Object[0]));
            valid = false;
        }
        this.setErrorMessage(errorMessage);
        this.setValid(valid);
    }

    public void stateChanged(IChangeNotifier theSource) {
        this.validate();
    }

    protected Properties collectProperties() {
        return this.newProperties;
    }
}

