/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.ldap.widget;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;

public class LdapAuthenticationWidget
extends Composite
implements Listener,
IChangeNotifier {
    private Composite scrolled;
    private Label authenticationMethodLabel;
    private Combo authenticationMethodCombo;
    private Label usernameLabel;
    private Text usernameText;
    private Label passwordLabel;
    private Text passwordText;
    private Properties connProperties;
    private Set<IChangeListener> listeners = new HashSet<IChangeListener>();

    public LdapAuthenticationWidget(Composite parent, int style, Properties connProperties) {
        super(parent, style);
        this.connProperties = connProperties;
        this.createComposite();
    }

    public String getTitle() {
        return DatatoolsUiConstants.UTIL.getString("LdapAuthenticationWidget.Label", new Object[0]);
    }

    private void setProperty(String key, String value) {
        this.connProperties.setProperty(key, value);
    }

    private String getAuthenticationMethod() {
        switch (this.authenticationMethodCombo.getSelectionIndex()) {
            case 1: {
                return "simple";
            }
        }
        return "none";
    }

    public void handleEvent(Event event) {
        this.setProperty("LdapAuthenticationMethod", this.getAuthenticationMethod());
        if (event.widget == this.usernameText) {
            this.setProperty("LdapAdminUserDN", this.usernameText.getText());
        }
        if (event.widget == this.passwordText) {
            this.setProperty("LdapAdminUserPassword", this.passwordText.getText());
        }
        boolean authSimple = "simple".equals(this.getAuthenticationMethod());
        this.usernameText.setEnabled(authSimple);
        this.passwordText.setEnabled(authSimple);
        this.notifyListeners();
    }

    private void addListeners() {
        this.authenticationMethodCombo.addListener(24, (Listener)this);
        this.usernameText.addListener(24, (Listener)this);
        this.passwordText.addListener(24, (Listener)this);
    }

    private void initControls() {
        String authMethod = this.connProperties.getProperty("LdapAuthenticationMethod");
        int index = 1;
        if ("none".equals(authMethod)) {
            index = 0;
        } else if ("simple".equals(authMethod)) {
            index = 1;
        } else {
            this.setProperty("LdapAuthenticationMethod", "simple");
            index = 1;
        }
        this.authenticationMethodCombo.select(index);
        if (this.connProperties.get("LdapAdminUserDN") != null) {
            this.usernameText.setText(this.connProperties.getProperty("LdapAdminUserDN"));
        }
        if (this.connProperties.get("LdapAdminUserPassword") != null) {
            this.passwordText.setText(this.connProperties.getProperty("LdapAdminUserPassword"));
        }
    }

    private void createComposite() {
        GridLayoutFactory.fillDefaults().applyTo((Composite)this);
        this.scrolled = new Composite((Composite)this, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.scrolled);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).applyTo(this.scrolled);
        this.authenticationMethodLabel = new Label(this.scrolled, 0);
        this.authenticationMethodLabel.setText(DatatoolsUiConstants.UTIL.getString("LdapAuthenticationWidget.Auth.Label", new Object[0]));
        this.authenticationMethodLabel.setToolTipText(DatatoolsUiConstants.UTIL.getString("LdapAuthenticationWidget.Auth.ToolTip", new Object[0]));
        GridDataFactory.swtDefaults().align(1, 1).applyTo((Control)this.authenticationMethodLabel);
        String[] authMethods = new String[]{DatatoolsUiConstants.UTIL.getString("LdapAuthenticationWidget.AnonymousAuthentication", new Object[0]), DatatoolsUiConstants.UTIL.getString("LdapAuthenticationWidget.SimpleAuthentication", new Object[0])};
        this.authenticationMethodCombo = new Combo(this.scrolled, 2060);
        this.authenticationMethodCombo.setItems(authMethods);
        this.authenticationMethodCombo.select(1);
        this.authenticationMethodCombo.setEnabled(false);
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo((Control)this.authenticationMethodCombo);
        this.usernameLabel = new Label(this.scrolled, 0);
        this.usernameLabel.setText(DatatoolsUiConstants.UTIL.getString("LdapAuthenticationWidget.User.Label", new Object[0]));
        this.usernameLabel.setToolTipText(DatatoolsUiConstants.UTIL.getString("LdapAuthenticationWidget.User.ToolTip", new Object[0]));
        GridDataFactory.swtDefaults().align(1, 1).applyTo((Control)this.usernameLabel);
        this.usernameText = new Text(this.scrolled, 2052);
        this.usernameText.setToolTipText(DatatoolsUiConstants.UTIL.getString("LdapAuthenticationWidget.User.ToolTip", new Object[0]));
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo((Control)this.usernameText);
        this.passwordLabel = new Label(this.scrolled, 0);
        this.passwordLabel.setText(DatatoolsUiConstants.UTIL.getString("LdapAuthenticationWidget.Password.Label", new Object[0]));
        this.passwordLabel.setToolTipText(DatatoolsUiConstants.UTIL.getString("LdapAuthenticationWidget.Password.ToolTip", new Object[0]));
        GridDataFactory.swtDefaults().align(1, 1).applyTo((Control)this.passwordLabel);
        this.passwordText = new Text(this.scrolled, 0x400804);
        this.passwordText.setToolTipText(DatatoolsUiConstants.UTIL.getString("LdapAuthenticationWidget.Password.ToolTip", new Object[0]));
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo((Control)this.passwordText);
        this.addListeners();
        this.initControls();
    }

    private void notifyListeners() {
        for (IChangeListener listener : this.listeners) {
            listener.stateChanged((IChangeNotifier)this);
        }
    }

    public void addChangeListener(IChangeListener theListener) {
        this.listeners.add(theListener);
    }

    public void removeChangeListener(IChangeListener theListener) {
        this.listeners.remove(theListener);
    }
}

