/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.ws;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.ui.wizards.ConnectionProfileDetailsPage;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.teiid.designer.datatools.profiles.ws.ODataConnectionProfileWizard;
import org.teiid.designer.datatools.profiles.ws.WSWizardUtils;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.ui.common.ICredentialsCommon;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.CredentialsComposite;

public class ODataProfileDetailsWizardPage
extends ConnectionProfileDetailsPage
implements DatatoolsUiConstants {
    private Composite scrolled;
    private Label profileLabel;
    private CLabel profileText;
    private Label descriptionLabel;
    private Text descriptionText;
    private Label urlLabel;
    private Text urlText;
    private CredentialsComposite credentialsComposite;

    public ODataProfileDetailsWizardPage(String pageName) {
        super(pageName, UTIL.getString("WSProfileDetailsWizardPage.Name", new Object[0]), AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.teiid.designer.datatools.ui", (String)"icons/full/obj16/web-service-cp.png"));
    }

    public void createCustomControl(Composite parent) {
        Group group = WidgetFactory.createSimpleGroup((Composite)parent, (String)UTIL.getString("Common.Properties.Label", new Object[0]));
        this.scrolled = new Composite((Composite)group, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 10;
        this.scrolled.setLayout((Layout)gridLayout);
        this.profileLabel = new Label(this.scrolled, 0);
        this.profileLabel.setText(UTIL.getString("Common.Profile.Label", new Object[0]));
        this.profileText = WidgetFactory.createLabel((Composite)this.scrolled, (int)2052);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        this.profileText.setLayoutData((Object)gd);
        this.profileText.setText(((ODataConnectionProfileWizard)this.getWizard()).getProfileName());
        this.descriptionLabel = new Label(this.scrolled, 0);
        this.descriptionLabel.setText(UTIL.getString("Common.Description.Label", new Object[0]));
        gd = new GridData();
        this.descriptionLabel.setLayoutData((Object)gd);
        this.descriptionText = WidgetFactory.createTextBox((Composite)this.scrolled, (int)2060, (int)4);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.descriptionText.setLayoutData((Object)gd);
        String description = ((ODataConnectionProfileWizard)this.getWizard()).getProfileDescription();
        this.descriptionText.setText(description);
        this.descriptionText.setBackground(Display.getCurrent().getSystemColor(19));
        this.urlLabel = new Label(this.scrolled, 0);
        this.urlLabel.setText(UTIL.getString("Common.URL.Label", new Object[0]));
        this.urlLabel.setToolTipText(UTIL.getString("Common.URL.ToolTip", new Object[0]));
        gd = new GridData();
        this.urlLabel.setLayoutData((Object)gd);
        this.urlText = new Text(this.scrolled, 2052);
        this.urlText.setToolTipText(UTIL.getString("Common.URL.ToolTip", new Object[0]));
        gd = new GridData(768);
        gd.widthHint = 500;
        this.urlText.setLayoutData((Object)gd);
        Label spacerLabel = new Label(this.scrolled, 0);
        spacerLabel.setVisible(false);
        GridDataFactory.swtDefaults().grab(false, false).applyTo((Control)spacerLabel);
        this.credentialsComposite = new CredentialsComposite(this.scrolled, 2048, "odata");
        gd = new GridData(768);
        this.credentialsComposite.setLayoutData((Object)gd);
        this.setPingButtonVisible(true);
        this.setPingButtonEnabled(false);
        this.setAutoConnectOnFinishDefault(false);
        this.setCreateAutoConnectControls(false);
        this.setShowAutoConnect(false);
        this.setShowAutoConnectOnFinish(false);
        this.setPageComplete(false);
        this.addListeners();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        String description = ((ODataConnectionProfileWizard)this.getWizard()).getProfileDescription();
        this.descriptionText.setText(description);
        this.profileText.setText(((ODataConnectionProfileWizard)this.getWizard()).getProfileName());
    }

    private void addListeners() {
        this.urlText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String urlStr = ODataProfileDetailsWizardPage.this.urlText.getText();
                if (urlStr != null) {
                    urlStr = urlStr.trim();
                }
                ODataProfileDetailsWizardPage.this.setProperty("EndPoint", urlStr);
            }
        });
        this.credentialsComposite.addSecurityOptionListener(24, new Listener(){

            public void handleEvent(Event event) {
                ODataProfileDetailsWizardPage.this.setProperty("SecurityType", ODataProfileDetailsWizardPage.this.credentialsComposite.getSecurityOption().name());
            }
        });
        this.credentialsComposite.addUserNameListener(24, new Listener(){

            public void handleEvent(Event event) {
                ODataProfileDetailsWizardPage.this.setProperty("AuthUserName", ODataProfileDetailsWizardPage.this.credentialsComposite.getUserName());
            }
        });
        this.credentialsComposite.addPasswordListener(24, new Listener(){

            public void handleEvent(Event event) {
                ODataProfileDetailsWizardPage.this.setProperty("AuthPassword", ODataProfileDetailsWizardPage.this.credentialsComposite.getPassword());
            }
        });
    }

    private void setProperty(String propertyId, String value) {
        Properties properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
        properties.setProperty(propertyId, value);
        this.updateState();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.updateState();
    }

    void updateState() {
        this.setPingButtonVisible(true);
        this.setPingButtonEnabled(false);
        this.profileText.setText(((NewConnectionProfileWizard)this.getWizard()).getProfileName());
        this.descriptionText.setText(((NewConnectionProfileWizard)this.getWizard()).getProfileDescription());
        Properties properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
        if (properties.get("EndPoint") == null || properties.get("EndPoint").toString().isEmpty()) {
            this.setErrorMessage(UTIL.getString("Common.URL.Error.Message", new Object[0]));
            return;
        }
        this.setErrorMessage(null);
        try {
            new URL(properties.get("EndPoint").toString());
        }
        catch (MalformedURLException e) {
            this.setErrorMessage(String.valueOf(UTIL.getString("Common.URL.Invalid.Message", new Object[0])) + e.getMessage());
            return;
        }
        if (properties.get("SecurityType") != null && !ICredentialsCommon.SecurityType.None.name().equals(properties.get("SecurityType"))) {
            if (properties.get("AuthUserName") == null || properties.get("AuthUserName").toString().isEmpty()) {
                this.setErrorMessage(UTIL.getString("Common.Username.Error.Message", new Object[0]));
                return;
            }
            this.setErrorMessage(null);
            if (properties.get("AuthPassword") == null || properties.get("AuthPassword").toString().isEmpty()) {
                this.setErrorMessage(UTIL.getString("Common.Password.Error.Message", new Object[0]));
                return;
            }
        }
        this.setPingButtonEnabled(true);
        this.setErrorMessage(null);
        this.setPageComplete(true);
        this.setMessage(UTIL.getString("Click.Next.or.Finish", new Object[0]));
    }

    public boolean canFlipToNextPage() {
        return this.internalComplete(super.canFlipToNextPage());
    }

    private boolean internalComplete(boolean complete) {
        Properties properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
        if (complete && (properties.get("EndPoint") == null || properties.get("EndPoint").toString().isEmpty())) {
            complete = false;
        }
        if (complete && properties.get("SecurityType") != null && !ICredentialsCommon.SecurityType.None.name().equals(properties.get("SecurityType").toString())) {
            if (complete && (properties.get("AuthUserName") == null || properties.get("AuthUserName").toString().isEmpty())) {
                complete = false;
            }
            if (complete && (properties.get("AuthPassword") == null || properties.get("AuthPassword").toString().isEmpty())) {
                complete = false;
            }
        }
        return complete;
    }

    public List getSummaryData() {
        List result = super.getSummaryData();
        result.add(new String[]{UTIL.getString("Common.URL.Label", new Object[0]), this.urlText.getText()});
        result.add(new String[]{UTIL.getString("Common.Username.Label", new Object[0]), this.credentialsComposite.getUserName()});
        result.add(new String[]{UTIL.getString("Common.Security.Type.Label", new Object[0]), this.credentialsComposite.getSecurityOption().name()});
        return result;
    }

    public void testConnection() {
        super.testConnection();
    }

    protected Runnable createTestConnectionRunnable(IConnectionProfile profile) {
        final URLPingJob pingJob = new URLPingJob(this.getShell(), profile);
        pingJob.schedule();
        return new Runnable(){

            @Override
            public void run() {
                try {
                    pingJob.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        };
    }

    public class URLPingJob
    extends Job {
        private IConnectionProfile icp;
        private Shell shell;

        public URLPingJob(Shell shell, IConnectionProfile profile) {
            super(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.job"));
            this.setSystem(false);
            this.setUser(true);
            this.shell = shell;
            this.icp = profile;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.title"), -1);
            Exception exception = this.testXmlUrlConnection(this.icp);
            monitor.done();
            new XmlUrlPingUIJob(this.shell, exception).schedule();
            return Status.OK_STATUS;
        }

        public Exception testXmlUrlConnection(IConnectionProfile icp) {
            return WSWizardUtils.testURLConnection(icp, "EndPoint");
        }

        public Throwable getTestConnectionException(IConnection conn) {
            return conn != null ? conn.getConnectException() : new RuntimeException(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.failure"));
        }

        public class XmlUrlPingUIJob
        extends UIJob {
            private Shell shell;
            private Throwable exception;

            public XmlUrlPingUIJob(Shell shell, Throwable exception) {
                super(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.uijob"));
                this.setSystem(false);
                this.exception = exception;
                this.shell = shell;
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                this.showTestConnectionMessage(this.shell, this.exception);
                return Status.OK_STATUS;
            }

            public void showTestConnectionMessage(Shell shell, Throwable exception) {
                if (exception == null) {
                    MessageDialog.openInformation((Shell)shell, (String)ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.success"), (String)ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.success"));
                    ODataProfileDetailsWizardPage.this.updateState();
                } else {
                    ExceptionHandler.showException((Shell)shell, (String)ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), (String)ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.failure"), (Throwable)exception);
                    ODataProfileDetailsWizardPage.this.setErrorMessage(exception.getMessage());
                    ODataProfileDetailsWizardPage.this.updateState();
                }
            }
        }
    }
}

