/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.ws;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.datatools.connectivity.model.Parameter;
import org.teiid.designer.datatools.profiles.ws.PropertyPage;
import org.teiid.designer.datatools.profiles.ws.WSProfileDetailsWizardPage;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.datatools.ui.DatatoolsUiPlugin;
import org.teiid.designer.ui.common.table.ComboBoxEditingSupport;
import org.teiid.designer.ui.common.table.TableViewerBuilder;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class ParameterPanel
implements DatatoolsUiConstants {
    static final String PREFIX = I18nUtil.getPropertyPrefix(ParameterPanel.class);
    TableViewerBuilder propertiesViewer;
    Button addPropertyButton;
    Button removePropertyButton;
    Button upPropertyButton;
    Button downPropertyButton;
    private Map<String, Parameter> parameterMap;
    private int visibleTableRows;
    private WSProfileDetailsWizardPage wsProfileDetailsWizardPage;
    private PropertyPage propertyPage;

    public ParameterPanel(WSProfileDetailsWizardPage wsProfileDetailsWizardPage, Composite parent, Map<String, Parameter> parameterMap, int visibleTableRows) {
        this.parameterMap = parameterMap;
        this.visibleTableRows = visibleTableRows;
        this.wsProfileDetailsWizardPage = wsProfileDetailsWizardPage;
        this.createPanel(parent);
    }

    public ParameterPanel(PropertyPage propertyPage, Composite parent, Map<String, Parameter> parameterMap, int visibleTableRows) {
        this.parameterMap = parameterMap;
        this.visibleTableRows = visibleTableRows;
        this.propertyPage = propertyPage;
        this.createPanel(parent);
    }

    private void createPanel(Composite parent) {
        Group panel = WidgetFactory.createGroup((Composite)parent, (String)"", (int)4, (int)2, (int)1);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        panel.setLayoutData((Object)gd);
        Composite toolbarPanel = WidgetFactory.createPanel((Composite)panel, (int)0, (int)2, (int)1, (int)4);
        ((GridLayout)toolbarPanel.getLayout()).marginHeight = 0;
        this.addPropertyButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
        this.addPropertyButton.setImage(DatatoolsUiPlugin.getDefault().getImage("icons/full/obj16/add_property.png"));
        this.addPropertyButton.setToolTipText(UTIL.getString("ParametersPanel_addNewParameterButton_tooltip", new Object[0]));
        this.addPropertyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ParameterPanel.this.handleAddProperty();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removePropertyButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
        this.removePropertyButton.setImage(DatatoolsUiPlugin.getDefault().getImage("icons/full/obj16/remove_property.png"));
        this.removePropertyButton.setToolTipText(UTIL.getString("ParametersPanel_removeParameterButton_tooltip", new Object[0]));
        this.removePropertyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ParameterPanel.this.handleRemoveProperty();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removePropertyButton.setEnabled(false);
        this.upPropertyButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
        this.upPropertyButton.setImage(DatatoolsUiPlugin.getDefault().getImage("icons/full/obj16/up.gif"));
        this.upPropertyButton.setToolTipText(UTIL.getString("ParametersPanel_upParameterButton_tooltip", new Object[0]));
        this.upPropertyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterPanel.this.handleMoveColumnUp();
            }
        });
        this.upPropertyButton.setEnabled(false);
        this.downPropertyButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
        this.downPropertyButton.setImage(DatatoolsUiPlugin.getDefault().getImage("icons/full/obj16/down.gif"));
        this.downPropertyButton.setToolTipText(UTIL.getString("ParametersPanel_downParameterButton_tooltip", new Object[0]));
        this.downPropertyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ParameterPanel.this.handleMoveColumnDown();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.downPropertyButton.setEnabled(false);
        this.propertiesViewer = new TableViewerBuilder((Composite)panel, 68352);
        GridDataFactory.fillDefaults().grab(true, true).span(3, 1).hint(360, 100).applyTo((Control)this.propertiesViewer.getTableComposite());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.propertiesViewer.getTableViewer());
        this.propertiesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (ParameterPanel.this.parameterMap == null || ParameterPanel.this.parameterMap.isEmpty()) {
                    return new Object[0];
                }
                LinkedHashMap<String, Parameter> parameterValues = new LinkedHashMap<String, Parameter>();
                for (Parameter parameter : ParameterPanel.this.parameterMap.values()) {
                    if (parameter.getType().equals((Object)Parameter.Type.Header)) continue;
                    parameterValues.put(parameter.getPropertyKey(), parameter);
                }
                return parameterValues.values().toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.propertiesViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return 0;
            }
        });
        Table table = this.propertiesViewer.getTable();
        ((GridData)table.getLayoutData()).heightHint = table.getItemHeight() * this.visibleTableRows;
        TableViewerColumn column = this.propertiesViewer.createColumn(16384, 30, 40, true);
        column.getColumn().setText(String.valueOf(UTIL.getString("ParametersPanel_name", new Object[0])) + "                   ");
        column.setLabelProvider((CellLabelProvider)new PropertyLabelProvider(0));
        column = this.propertiesViewer.createColumn(16384, 30, 40, true);
        column.getColumn().setText(UTIL.getString("ParametersPanel_type", new Object[0]));
        column.getColumn().setToolTipText(UTIL.getString("AddParameterDialog_txtType_toolTip", new Object[0]));
        column.setLabelProvider((CellLabelProvider)new PropertyLabelProvider(1));
        column.setEditingSupport((EditingSupport)new ParameterTypeComboEditingSupport((ColumnViewer)this.propertiesViewer.getTableViewer()));
        column = this.propertiesViewer.createColumn(16384, 30, 40, true);
        column.getColumn().setText(UTIL.getString("ParametersPanel_default_value", new Object[0]));
        column.getColumn().setToolTipText(UTIL.getString("AddParameterDialog_txtDefaultValue_toolTip", new Object[0]));
        column.setLabelProvider((CellLabelProvider)new PropertyLabelProvider(2));
        column.setEditingSupport((EditingSupport)new PropertyNameEditingSupport((ColumnViewer)this.propertiesViewer.getTableViewer(), 2));
        this.propertiesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ParameterPanel.this.handlePropertySelected();
            }
        });
        this.propertiesViewer.setInput((Object)this);
    }

    void handlePropertySelected() {
        boolean hasSelection = !this.propertiesViewer.getSelection().isEmpty();
        this.removePropertyButton.setEnabled(hasSelection);
        boolean sel = this.propertiesViewer.getTable().getSelectionIndex() > 0;
        this.upPropertyButton.setEnabled(sel);
        this.downPropertyButton.setEnabled(this.propertiesViewer.getTable().getSelectionIndex() + 1 < this.propertiesViewer.getTable().getItemCount());
    }

    public void handleMoveColumnUp() {
        int startIndex = this.propertiesViewer.getTable().getSelectionIndex();
        if (startIndex > 0) {
            TableItem[] existingColumns = this.propertiesViewer.getTable().getItems();
            TableItem priorColumn = existingColumns[startIndex - 1];
            existingColumns[startIndex - 1] = this.propertiesViewer.getTable().getItem(startIndex);
            existingColumns[startIndex] = priorColumn;
            ArrayList<TableItem> newColumns = new ArrayList<TableItem>(existingColumns.length);
            LinkedHashMap<String, Parameter> oldParameterMap = new LinkedHashMap<String, Parameter>(this.parameterMap);
            this.parameterMap.clear();
            TableItem[] tableItemArray = existingColumns;
            int n = existingColumns.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem info = tableItemArray[n2];
                newColumns.add(info);
                this.parameterMap.put("rest_param:" + ((Parameter)info.getData()).getName(), (Parameter)oldParameterMap.get("rest_param:" + ((Parameter)info.getData()).getName()));
                ++n2;
            }
            this.propertiesViewer.getTable().setData(newColumns);
            this.propertiesViewer.refresh();
            this.updatePreviewUrl();
            this.handlePropertySelected();
        }
    }

    public void handleMoveColumnDown() {
        int startIndex = this.propertiesViewer.getTable().getSelectionIndex();
        if (startIndex < this.propertiesViewer.getTable().getItems().length) {
            TableItem[] existingColumns = this.propertiesViewer.getTable().getItems();
            TableItem afterColumn = existingColumns[startIndex + 1];
            existingColumns[startIndex + 1] = this.propertiesViewer.getTable().getItem(startIndex);
            existingColumns[startIndex] = afterColumn;
            ArrayList<TableItem> newColumns = new ArrayList<TableItem>(existingColumns.length);
            LinkedHashMap<String, Parameter> oldParameterMap = new LinkedHashMap<String, Parameter>(this.parameterMap);
            this.parameterMap.clear();
            TableItem[] tableItemArray = existingColumns;
            int n = existingColumns.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem info = tableItemArray[n2];
                newColumns.add(info);
                this.parameterMap.put("rest_param:" + ((Parameter)info.getData()).getName(), (Parameter)oldParameterMap.get("rest_param:" + ((Parameter)info.getData()).getName()));
                ++n2;
            }
            this.propertiesViewer.getTable().setData(newColumns);
            this.propertiesViewer.refresh();
            this.updatePreviewUrl();
            this.handlePropertySelected();
        }
    }

    private Parameter getSelectedProperty() {
        IStructuredSelection selection = (IStructuredSelection)this.propertiesViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (Parameter)selection.getFirstElement();
    }

    void handleAddProperty() {
        assert (!this.propertiesViewer.getSelection().isEmpty());
        if (this.parameterMap == null) {
            this.parameterMap = new LinkedHashMap<String, Parameter>();
        }
        HashSet<String> keys = new HashSet<String>();
        for (String key : this.parameterMap.keySet()) {
            keys.add(key);
        }
        AddParameterDialog dialog = new AddParameterDialog(this.propertiesViewer.getControl().getShell(), keys);
        if (dialog.open() == 0) {
            String name = dialog.getName();
            String type = dialog.getType() != null ? dialog.getType() : "Query";
            String defaultValue = dialog.getDefaultValue();
            Parameter parameter = new Parameter(name, defaultValue, Parameter.Type.fromValue((String)type));
            this.parameterMap.put("rest_param:" + name, parameter);
            this.propertiesViewer.refresh();
            Parameter prop = null;
            TableItem[] tableItemArray = this.propertiesViewer.getTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getData() instanceof Parameter && ((Parameter)item.getData()).getName().equals(name)) {
                    prop = (Parameter)item.getData();
                    break;
                }
                ++n2;
            }
            if (prop != null) {
                this.propertiesViewer.setSelection((ISelection)new StructuredSelection(prop), true);
            }
            this.updatePreviewUrl();
        }
    }

    private void updatePreviewUrl() {
        if (this.wsProfileDetailsWizardPage != null) {
            for (String key : this.parameterMap.keySet()) {
                Parameter para = this.parameterMap.get(key);
                this.wsProfileDetailsWizardPage.getProfileProperties().put(para.getPropertyKey(), para.getPropertyValue());
            }
            this.wsProfileDetailsWizardPage.setParameterMap(this.parameterMap);
            this.wsProfileDetailsWizardPage.urlPreviewText.setText(this.wsProfileDetailsWizardPage.updateUrlPreview().toString());
        } else {
            for (String key : this.parameterMap.keySet()) {
                Parameter para = this.parameterMap.get(key);
                this.propertyPage.getExtraProperties().put(para.getPropertyKey(), para.getPropertyValue());
            }
            this.propertyPage.setParameterMap(this.parameterMap);
            this.propertyPage.urlPreviewText.setText(this.propertyPage.updateUrlPreview().toString());
        }
    }

    void handleRemoveProperty() {
        Parameter selectedProperty = this.getSelectedProperty();
        assert (selectedProperty != null);
        this.parameterMap.remove("rest_param:" + selectedProperty.getName());
        this.propertiesViewer.refresh();
        this.updatePreviewUrl();
    }

    class AddParameterDialog
    extends MessageDialog {
        private Button btnOk;
        private final Set<String> existingNames;
        private String name;
        private String type;
        private String defaultValue;

        public AddParameterDialog(Shell parentShell, Set<String> existingPropertyNames) {
            super(parentShell, UTIL.getString("AddParameterDialog_title", new Object[0]), null, UTIL.getString("AddParameterDialog_message", new Object[0]), 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.existingNames = existingPropertyNames == null ? new HashSet<String>(0) : existingPropertyNames;
        }

        protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
            Button btn = super.createButton(parent, id, label, defaultButton);
            if (id == 0) {
                this.btnOk = btn;
                btn.setEnabled(false);
            }
            return btn;
        }

        protected Control createCustomArea(Composite parent) {
            Composite pnl = new Composite(parent, 0);
            pnl.setLayout((Layout)new GridLayout(2, false));
            pnl.setLayoutData((Object)new GridData(4, 4, true, true));
            Label lblName = new Label(pnl, 0);
            lblName.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            lblName.setText(UTIL.getString("AddParameterDialog_lblName_text", new Object[0]));
            Text txtName = new Text(pnl, 2048);
            txtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            txtName.setToolTipText(UTIL.getString("AddParameterDialog_txtName_toolTip", new Object[0]));
            txtName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddParameterDialog.this.handleNameChanged(((Text)e.widget).getText());
                }
            });
            Label lblValue = new Label(pnl, 0);
            lblValue.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            lblValue.setText(UTIL.getString("AddParameterDialog_lblType_text", new Object[0]));
            Combo txtValue = WidgetFactory.createCombo((Composite)pnl, (int)64, (int)768);
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            txtValue.setLayoutData((Object)gd);
            txtValue.add("Query");
            txtValue.add("URI");
            txtValue.select(0);
            txtValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            txtValue.setToolTipText(UTIL.getString("AddParameterDialog_txtType_toolTip", new Object[0]));
            txtValue.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    AddParameterDialog.this.handleTypeChanged(((Combo)e.widget).getText());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            txtValue.setVisibleItemCount(2);
            Label lblDefaultValue = new Label(pnl, 0);
            lblDefaultValue.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            lblDefaultValue.setText(UTIL.getString("AddParameterDialog_lblDefaultValue_text", new Object[0]));
            Text txtDefaultValue = new Text(pnl, 2048);
            txtDefaultValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            txtDefaultValue.setToolTipText(UTIL.getString("AddParameterDialog_txtDefaultValue_toolTip", new Object[0]));
            txtDefaultValue.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddParameterDialog.this.handleDefaultValueChanged(((Text)e.widget).getText());
                }
            });
            return pnl;
        }

        public String getName() {
            CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
            return this.name;
        }

        public String getType() {
            CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
            return this.type;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        protected int getShellStyle() {
            return super.getShellStyle() | 0x10;
        }

        void handleNameChanged(String newName) {
            this.name = newName;
            this.updateState();
        }

        void handleDefaultValueChanged(String newDefaultValue) {
            this.setDefaultValue(newDefaultValue);
            this.updateState();
        }

        void handleTypeChanged(Object type) {
            this.type = (String)type;
            this.updateState();
            ParameterPanel.this.updatePreviewUrl();
        }

        private void updateState() {
            String msg = this.validateName();
            if (StringUtilities.isEmpty((String)msg)) {
                String string = msg = StringUtilities.isEmpty((String)this.defaultValue) ? UTIL.getString("AddParameterDialog_emptyDefaultValue", new Object[0]) : msg;
            }
            if (StringUtilities.isEmpty((String)msg)) {
                if (!this.btnOk.isEnabled()) {
                    this.btnOk.setEnabled(true);
                }
                if (this.imageLabel.getImage() != null) {
                    this.imageLabel.setImage(null);
                }
                this.imageLabel.setImage(this.getInfoImage());
            } else {
                if (this.btnOk.isEnabled()) {
                    this.btnOk.setEnabled(false);
                }
                this.imageLabel.setImage(this.getErrorImage());
            }
            if (!StringUtilities.isEmpty((String)msg)) {
                this.messageLabel.setText(msg);
            }
            this.messageLabel.pack();
        }

        private String validateName() {
            String errorMsg = this.validateName(this.name);
            if (errorMsg == null) {
                for (String existingName : this.existingNames) {
                    if (!existingName.equals(this.name)) continue;
                    errorMsg = UTIL.getString("AddParameterDialog_customParameterAlreadyExists", (Object)this.name);
                    break;
                }
            }
            return errorMsg;
        }

        public String validateName(String proposedName) {
            if (StringUtilities.isEmpty((String)proposedName)) {
                return UTIL.getString("AddParameterDialog_emptyParameterName", new Object[0]);
            }
            char[] cArray = proposedName.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (!this.isValidChar(c)) {
                    return UTIL.getString("AddParameterDialog_invalidParameterName", new Object[0]);
                }
                ++n2;
            }
            return null;
        }

        private boolean isValidChar(char c) {
            return Character.isLetter(c) || Character.isDigit(c);
        }
    }

    class ParameterTypeComboEditingSupport
    extends ComboBoxEditingSupport {
        private String[] datatypes;

        public ParameterTypeComboEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.datatypes = new String[]{"Query", "URI"};
        }

        protected String getElementValue(Object element) {
            return ((Parameter)element).getType().toString();
        }

        protected String[] refreshItems(Object element) {
            return this.datatypes;
        }

        protected void setElementValue(Object element, String newValue) {
            Parameter param = (Parameter)element;
            String key = param.getPropertyKey();
            String oldType = param.getType().toString();
            String newType = newValue;
            if (newType != null && newType.length() > 0 && !newType.equalsIgnoreCase(oldType)) {
                param.setType(Parameter.Type.fromValue((String)newType));
                ParameterPanel.this.parameterMap.put(key, param);
                ParameterPanel.this.propertiesViewer.refresh((Object)param);
                if (ParameterPanel.this.wsProfileDetailsWizardPage != null) {
                    ParameterPanel.this.wsProfileDetailsWizardPage.setParameterMap(ParameterPanel.this.parameterMap);
                } else {
                    ParameterPanel.this.propertyPage.setParameterMap(ParameterPanel.this.parameterMap);
                }
            }
        }
    }

    class PropertyLabelProvider
    extends ColumnLabelProvider {
        private final int columnID;

        public PropertyLabelProvider(int columnID) {
            this.columnID = columnID;
        }

        public String getText(Object element) {
            if (element instanceof Parameter) {
                if (this.columnID == 0) {
                    return ((Parameter)element).getName();
                }
                if (this.columnID == 1) {
                    return ((Parameter)element).getType().toString();
                }
                if (this.columnID == 2) {
                    return ((Parameter)element).getDefaultValue();
                }
            }
            return super.getText(element);
        }
    }

    class PropertyNameEditingSupport
    extends EditingSupport {
        int columnID;
        private TextCellEditor editor;

        public PropertyNameEditingSupport(ColumnViewer viewer, int columnID) {
            super(viewer);
            this.columnID = columnID;
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof Parameter) {
                if (this.columnID == 0) {
                    return ((Parameter)element).getName();
                }
                if (this.columnID == 1) {
                    return ((Parameter)element).getType().toString();
                }
                if (this.columnID == 2) {
                    return ((Parameter)element).getDefaultValue();
                }
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            Parameter para;
            if (element instanceof Parameter) {
                String key = ((Parameter)element).getPropertyKey();
                if (this.columnID == 2) {
                    String newDefaultValue;
                    String oldDefaultValue = "";
                    if (((Parameter)element).getDefaultValue() != null) {
                        oldDefaultValue = ((Parameter)element).getDefaultValue();
                    }
                    if ((newDefaultValue = (String)value) != null && newDefaultValue.length() > 0 && !newDefaultValue.equalsIgnoreCase(oldDefaultValue)) {
                        ((Parameter)element).setDefaultValue(newDefaultValue);
                        ParameterPanel.this.parameterMap.put(key, (Parameter)element);
                        ParameterPanel.this.propertiesViewer.refresh(element);
                    }
                }
            }
            if (ParameterPanel.this.wsProfileDetailsWizardPage != null) {
                for (String key : ParameterPanel.this.parameterMap.keySet()) {
                    para = (Parameter)ParameterPanel.this.parameterMap.get(key);
                    ParameterPanel.this.wsProfileDetailsWizardPage.getProfileProperties().put(para.getPropertyKey(), para.getPropertyValue());
                }
                ParameterPanel.this.wsProfileDetailsWizardPage.setParameterMap(ParameterPanel.this.parameterMap);
                ((ParameterPanel)ParameterPanel.this).wsProfileDetailsWizardPage.urlPreviewText.setText(ParameterPanel.this.wsProfileDetailsWizardPage.updateUrlPreview().toString());
            } else {
                for (String key : ParameterPanel.this.parameterMap.keySet()) {
                    para = (Parameter)ParameterPanel.this.parameterMap.get(key);
                    ParameterPanel.this.propertyPage.getExtraProperties().put(para.getPropertyKey(), para.getPropertyValue());
                }
                ParameterPanel.this.propertyPage.setParameterMap(ParameterPanel.this.parameterMap);
                ((ParameterPanel)ParameterPanel.this).propertyPage.urlPreviewText.setText(ParameterPanel.this.propertyPage.updateUrlPreview().toString());
            }
        }
    }
}

