/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.ws;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.ui.wizards.ConnectionProfileDetailsPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.designer.datatools.profiles.ws.WSSoapConnectionProfileWizard;
import org.teiid.designer.datatools.profiles.ws.WSWizardUtils;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.modelgenerator.wsdl.WSDLReader;
import org.teiid.designer.ui.common.ICredentialsCommon;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.wizards.wsdl.WsdlFileSelectionComposite;

public class WSSoapProfileDetailsWizardPage
extends ConnectionProfileDetailsPage
implements DatatoolsUiConstants {
    private IStatus testStatus = Status.OK_STATUS;
    private Composite scrolled;
    private Label profileLabel;
    private CLabel profileText;
    private Label descriptionLabel;
    private Text descriptionText;
    private Label urlLabel;
    private Text urlText;
    private Composite parent;
    private WSSoapConnectionProfileWizard wizard;
    private Properties profileProperties;

    public WSSoapProfileDetailsWizardPage(String pageName) {
        super(pageName, UTIL.getString("WSSoapProfileDetailsWizardPage.Name", new Object[0]), AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.teiid.designer.datatools.ui", (String)"icons/full/obj16/web-service-cp.png"));
    }

    public void createCustomControl(Composite parent) {
        this.wizard = (WSSoapConnectionProfileWizard)this.getWizard();
        this.profileProperties = this.wizard.getProfileProperties();
        Group group = WidgetFactory.createSimpleGroup((Composite)parent, null);
        this.scrolled = new Composite((Composite)group, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).applyTo(this.scrolled);
        Label title = new Label(this.scrolled, 0);
        title.setText(UTIL.getString("Common.Properties.Label", new Object[0]));
        title.setFont(JFaceResources.getBannerFont());
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).align(0x1000000, 0x1000000).applyTo((Control)title);
        this.profileLabel = new Label(this.scrolled, 0);
        this.profileLabel.setText(UTIL.getString("Common.Profile.Label", new Object[0]));
        GridDataFactory.swtDefaults().applyTo((Control)this.profileLabel);
        this.profileText = WidgetFactory.createLabel((Composite)this.scrolled, (String)this.wizard.getProfileName(), (int)4);
        GridDataFactory.swtDefaults().applyTo((Control)this.profileText);
        this.descriptionLabel = new Label(this.scrolled, 0);
        this.descriptionLabel.setText(UTIL.getString("Common.Description.Label", new Object[0]));
        GridDataFactory.swtDefaults().applyTo((Control)this.descriptionLabel);
        this.descriptionText = WidgetFactory.createTextBox((Composite)this.scrolled, (int)2060, (int)4);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.descriptionText);
        this.descriptionText.setText(this.wizard.getProfileDescription());
        this.descriptionText.setBackground(Display.getCurrent().getSystemColor(19));
        this.urlLabel = new Label(this.scrolled, 0);
        this.urlLabel.setText(UTIL.getString("Common.URLorFILE.Label", new Object[0]));
        this.urlLabel.setToolTipText(UTIL.getString("Common.URLorFILE.ToolTip", new Object[0]));
        GridDataFactory.swtDefaults().applyTo((Control)this.urlLabel);
        this.urlText = new Text(this.scrolled, 2060);
        this.urlText.setEditable(false);
        this.urlText.setToolTipText(UTIL.getString("Common.URLorFILE.ToolTip", new Object[0]));
        this.urlText.setBackground(Display.getCurrent().getSystemColor(19));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.urlText);
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String urlStr = WSSoapProfileDetailsWizardPage.this.urlText.getText();
                if (urlStr != null) {
                    urlStr = urlStr.trim();
                }
                WSSoapProfileDetailsWizardPage.this.setProperty("wsdlURI", urlStr);
                WSSoapProfileDetailsWizardPage.this.updateState();
            }
        });
        Label spacerLabel = new Label(this.scrolled, 0);
        spacerLabel.setVisible(false);
        GridDataFactory.swtDefaults().grab(false, false).applyTo((Control)spacerLabel);
        WsdlFileSelectionComposite wsdlFileSelectionComposite = new WsdlFileSelectionComposite(this.scrolled, 0);
        GridDataFactory.fillDefaults().applyTo((Control)wsdlFileSelectionComposite);
        WsdlFileSelectionComposite.IFileSelectionCallback fileSelectionCallback = new WsdlFileSelectionComposite.IFileSelectionCallback(){

            public void execute(File wsdlFile) {
                try {
                    WSSoapProfileDetailsWizardPage.this.urlText.setText(wsdlFile.toURI().toURL().toString());
                }
                catch (MalformedURLException ex) {
                    UTIL.log((Throwable)ex);
                }
            }

            public Display getDisplay() {
                return WSSoapProfileDetailsWizardPage.this.getShell().getDisplay();
            }
        };
        WsdlFileSelectionComposite.IURLSelectionCallback urlSelectionCallback = new WsdlFileSelectionComposite.IURLSelectionCallback(){

            public void execute(URL url, ICredentialsCommon.SecurityType securityType, String userName, String password) {
                WSSoapProfileDetailsWizardPage.this.setProperty("SecurityType", securityType.name());
                WSSoapProfileDetailsWizardPage.this.setProperty("AuthUserName", userName);
                WSSoapProfileDetailsWizardPage.this.setProperty("AuthPassword", password);
                WSSoapProfileDetailsWizardPage.this.urlText.setText(url.toString());
            }

            public Display getDisplay() {
                return WSSoapProfileDetailsWizardPage.this.getShell().getDisplay();
            }
        };
        wsdlFileSelectionComposite.setCallbacks(fileSelectionCallback, fileSelectionCallback, urlSelectionCallback);
        Group descriptionGroup = new Group(this.scrolled, 2048);
        GridLayoutFactory.fillDefaults().applyTo((Composite)descriptionGroup);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)descriptionGroup);
        Label descTitle = new Label((Composite)descriptionGroup, 0);
        descTitle.setText(UTIL.getString("Common.Description", new Object[0]));
        descTitle.setFont(JFaceResources.getBannerFont());
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).applyTo((Control)descTitle);
        Text descriptionText = new Text((Composite)descriptionGroup, 72);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).hint(500, -1).applyTo((Control)descriptionText);
        descriptionText.setText(UTIL.getString("WSSoapProfileDetailsWizardPage.descriptionMessage", new Object[0]));
        descriptionText.setBackground(this.scrolled.getBackground());
        descriptionText.setForeground(Display.getCurrent().getSystemColor(10));
        this.setPingButtonVisible(true);
        this.setPingButtonEnabled(false);
        this.setAutoConnectOnFinishDefault(false);
        this.setCreateAutoConnectControls(false);
        this.setShowAutoConnect(false);
        this.setShowAutoConnectOnFinish(false);
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.profileText.setText(this.wizard.getProfileName());
        this.descriptionText.setText(this.wizard.getProfileDescription());
        this.setProperty("SecurityType", ICredentialsCommon.SecurityType.None.name());
    }

    public void createControl(Composite parent) {
        this.parent = parent;
        super.createControl(parent);
        this.updateState();
    }

    private void setProperty(String key, String value) {
        if (value != null) {
            this.profileProperties.setProperty(key, value);
        }
    }

    private void updateState() {
        File file;
        this.setPingButtonVisible(true);
        this.setPingButtonEnabled(false);
        String wsdlUrl = this.profileProperties.getProperty("wsdlURI");
        if (wsdlUrl == null || wsdlUrl.isEmpty()) {
            this.setErrorMessage(UTIL.getString("Common.URL.Error.Message", new Object[0]));
            return;
        }
        this.setErrorMessage(null);
        boolean urlError = true;
        try {
            new URL(wsdlUrl);
            urlError = false;
        }
        catch (MalformedURLException malformedURLException) {}
        if (urlError && !(file = new File(wsdlUrl)).exists()) {
            this.setErrorMessage(UTIL.getString("Common.URLorFILE.Invalid.Message", new Object[0]));
            return;
        }
        this.setPingButtonEnabled(true);
        this.setErrorMessage(null);
        this.setMessage(UTIL.getString("Click.Next", new Object[0]));
        this.testStatus = Status.OK_STATUS;
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isPageComplete() {
        WSSoapConnectionProfileWizard wizard = (WSSoapConnectionProfileWizard)this.getWizard();
        Properties properties = wizard.getProfileProperties();
        String wsdlUrl = properties.getProperty("wsdlURI");
        if (wsdlUrl == null || wsdlUrl.toString().isEmpty()) {
            return false;
        }
        if (!this.testStatus.isOK()) {
            return false;
        }
        WSDLReader wsdlReader = wizard.getWsdlReader();
        String securityTypeValue = properties.getProperty("SecurityType");
        String userName = properties.getProperty("AuthUserName");
        String password = properties.getProperty("AuthPassword");
        if (securityTypeValue != null) {
            ICredentialsCommon.SecurityType securityType = ICredentialsCommon.SecurityType.valueOf((String)securityTypeValue);
            wsdlReader.setAuthenticationCredentials(securityType, userName, password);
        }
        wsdlReader.setWSDLUri(wsdlUrl);
        return true;
    }

    public List getSummaryData() {
        List result = super.getSummaryData();
        String securityType = this.profileProperties.getProperty("SecurityType");
        if (securityType == null) {
            securityType = ICredentialsCommon.SecurityType.None.name();
        }
        result.add(new String[]{UTIL.getString("Common.URL.Label", new Object[0]), this.profileProperties.getProperty("wsdlURI")});
        if (!ICredentialsCommon.SecurityType.None.name().equals(securityType)) {
            result.add(new String[]{UTIL.getString("Common.SecurityType.Label", new Object[0]), securityType});
            result.add(new String[]{UTIL.getString("Common.Username.Label", new Object[0]), this.profileProperties.getProperty("AuthUserName")});
            String password = this.profileProperties.getProperty("AuthPassword");
            StringBuffer masked = new StringBuffer(password.length());
            int i = 0;
            while (i < password.length()) {
                masked.append("*");
                ++i;
            }
            result.add(new String[]{UTIL.getString("Common.Password.Label", new Object[0]), masked.toString()});
        }
        return result;
    }

    protected void testConnection() {
        this.setErrorMessage(null);
        super.testConnection();
    }

    protected Runnable createTestConnectionRunnable(IConnectionProfile profile) {
        final URLPingJob pingJob = new URLPingJob(profile);
        pingJob.schedule();
        return new Runnable(){

            @Override
            public void run() {
                try {
                    pingJob.join();
                    WSSoapProfileDetailsWizardPage.this.testStatus = pingJob.getResult();
                    if (!WSSoapProfileDetailsWizardPage.this.testStatus.isOK()) {
                        Throwable exception = WSSoapProfileDetailsWizardPage.this.testStatus.getException();
                        WSSoapProfileDetailsWizardPage.this.setErrorMessage(exception.getMessage());
                    } else {
                        WSSoapProfileDetailsWizardPage.this.setMessage(UTIL.getString("WSSoapProfileDetailsWizardPage.validatingWsdlMessage", new Object[0]));
                        UiBusyIndicator.showWhile((Display)WSSoapProfileDetailsWizardPage.this.parent.getDisplay(), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                WSSoapProfileDetailsWizardPage.this.testStatus = (IStatus)WSSoapProfileDetailsWizardPage.this.wizard.getWsdlReader().validateWSDL((IProgressMonitor)new NullProgressMonitor());
                            }
                        });
                        if (WSSoapProfileDetailsWizardPage.this.testStatus.isOK()) {
                            WSSoapProfileDetailsWizardPage.this.setMessage(UTIL.getString("WSSoapProfileDetailsWizardPage.validationSuccessfulWsdlMessage", new Object[0]));
                        } else {
                            WSSoapProfileDetailsWizardPage.this.setErrorMessage(UTIL.getString("WSSoapProfileDetailsWizardPage.validationErrorWsdlMessage", new Object[0]));
                        }
                    }
                    WSSoapProfileDetailsWizardPage.this.setPageComplete(WSSoapProfileDetailsWizardPage.this.isPageComplete());
                }
                catch (InterruptedException interruptedException) {}
            }
        };
    }

    public class URLPingJob
    extends Job {
        private IConnectionProfile icp;

        public URLPingJob(IConnectionProfile profile) {
            super(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.job"));
            this.setSystem(false);
            this.setUser(true);
            this.icp = profile;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.title"), -1);
            Exception exception = WSWizardUtils.testURLConnection(this.icp, "wsdlURI");
            monitor.done();
            if (exception == null) {
                return Status.OK_STATUS;
            }
            return new Status(4, "org.teiid.designer.datatools.ui", ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.failure"), (Throwable)exception);
        }
    }
}

