/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.ws;

import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ui.wizards.ProfileDetailsPropertyPage;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.datatools.ui.DatatoolsUiPlugin;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.CredentialsComposite;

public class WSSoapPropertyPage
extends ProfileDetailsPropertyPage
implements IContextProvider,
DatatoolsUiConstants {
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(DatatoolsUiPlugin.getDefault().getBundle().getSymbolicName());
    private Composite scrolled;
    private Label urlLabel;
    private Text urlText;
    private CredentialsComposite credentialsComposite;
    private Label endPointLabel;
    private Text endPointText;
    private Label endPointNameLabel;
    private Text endPointNameText;
    private Label bindingTypeLabel;
    private Text bindingTypeText;

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.setPingButtonEnabled(false);
        this.setPingButtonVisible(false);
        return result;
    }

    protected void createCustomContents(Composite parent) {
        Group group = WidgetFactory.createSimpleGroup((Composite)parent, (String)UTIL.getString("Common.Properties.Label", new Object[0]));
        this.scrolled = new Composite((Composite)group, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.scrolled.setLayout((Layout)gridLayout);
        this.urlLabel = new Label(this.scrolled, 0);
        this.urlLabel.setText(UTIL.getString("Common.URL.Label", new Object[0]));
        this.urlLabel.setToolTipText(UTIL.getString("Common.URL.ToolTip", new Object[0]));
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        this.urlLabel.setLayoutData((Object)gd);
        this.urlText = new Text(this.scrolled, 2052);
        this.urlText.setToolTipText(UTIL.getString("Common.URL.ToolTip", new Object[0]));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.urlText.setLayoutData((Object)gd);
        Label spacerLabel = new Label(this.scrolled, 0);
        spacerLabel.setVisible(false);
        GridDataFactory.swtDefaults().grab(false, false).applyTo((Control)spacerLabel);
        this.credentialsComposite = new CredentialsComposite(this.scrolled, 2048, "soap");
        gd = new GridData(768);
        this.credentialsComposite.setLayoutData((Object)gd);
        this.endPointLabel = new Label(this.scrolled, 0);
        this.endPointLabel.setText(UTIL.getString("WSSoapPropertyPage.endPointName", new Object[0]));
        this.endPointLabel.setToolTipText(UTIL.getString("WSSoapPropertyPage.endPoint.ToolTip", new Object[0]));
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.endPointLabel.setLayoutData((Object)gd);
        this.endPointText = new Text(this.scrolled, 2052);
        this.endPointText.setToolTipText(UTIL.getString("WSSoapPropertyPage.endPoint.ToolTip", new Object[0]));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.endPointText.setLayoutData((Object)gd);
        this.endPointNameLabel = new Label(this.scrolled, 0);
        this.endPointNameLabel.setText(UTIL.getString("WSSoapPropertyPage.endPointNameName", new Object[0]));
        this.endPointNameLabel.setToolTipText(UTIL.getString("WSSoapPropertyPage.endPoint.ToolTip", new Object[0]));
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.endPointNameLabel.setLayoutData((Object)gd);
        this.endPointNameText = new Text(this.scrolled, 2052);
        this.endPointNameText.setToolTipText(UTIL.getString("WSSoapPropertyPage.endPoint.ToolTip", new Object[0]));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.endPointNameText.setLayoutData((Object)gd);
        this.bindingTypeLabel = new Label(this.scrolled, 0);
        this.bindingTypeLabel.setText(UTIL.getString("WSSoapPropertyPage.endPointBindingLabel", new Object[0]));
        this.bindingTypeLabel.setToolTipText(UTIL.getString("WSSoapPropertyPage.endPointBinding.ToolTip", new Object[0]));
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.bindingTypeLabel.setLayoutData((Object)gd);
        this.bindingTypeText = new Text(this.scrolled, 2052);
        this.bindingTypeText.setToolTipText(UTIL.getString("WSSoapPropertyPage.endPointBinding.ToolTip", new Object[0]));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.bindingTypeText.setLayoutData((Object)gd);
        this.initControls();
        this.addlisteners();
    }

    private void addlisteners() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                WSSoapPropertyPage.this.validate();
            }
        };
        this.urlText.addListener(24, listener);
        this.endPointText.addListener(24, listener);
        this.endPointNameText.addListener(24, listener);
        this.bindingTypeText.addListener(24, listener);
        this.credentialsComposite.addSecurityOptionListener(24, listener);
        this.credentialsComposite.addUserNameListener(24, listener);
        this.credentialsComposite.addPasswordListener(24, listener);
    }

    protected void validate() {
        String errorMessage = null;
        boolean valid = true;
        if (this.urlText.getText() == null || this.urlText.getText().isEmpty()) {
            errorMessage = UTIL.getString("Common.URL.Error.Message", new Object[0]);
            valid = false;
        }
        if (valid && (this.endPointText.getText() == null || this.endPointText.getText().isEmpty())) {
            errorMessage = UTIL.getString("Common.EndPoint.Error.Message", new Object[0]);
            valid = false;
        }
        if (valid && (this.endPointNameText.getText() == null || this.endPointNameText.getText().isEmpty())) {
            errorMessage = UTIL.getString("Common.EndPointName.Error.Message", new Object[0]);
            valid = false;
        }
        if (valid && (this.bindingTypeText.getText() == null || this.bindingTypeText.getText().isEmpty())) {
            errorMessage = UTIL.getString("Common.EndPointBinding.Error.Message", new Object[0]);
            valid = false;
        }
        this.setErrorMessage(errorMessage);
        this.setValid(valid);
    }

    private void initControls() {
        String bindingType;
        String endPointName;
        String endPoint;
        String password;
        String username;
        String securityType;
        IConnectionProfile profile = this.getConnectionProfile();
        Properties props = profile.getBaseProperties();
        String url = props.getProperty("wsdlURI");
        if (url != null) {
            this.urlText.setText(url);
        }
        if ((securityType = props.getProperty("SecurityType")) != null) {
            this.credentialsComposite.setSecurityOption(securityType);
        }
        if ((username = props.getProperty("AuthUserName")) != null) {
            this.credentialsComposite.setUserName(username);
        }
        if ((password = props.getProperty("AuthPassword")) != null) {
            this.credentialsComposite.setPassword(password);
        }
        if ((endPoint = ConnectionInfoHelper.readEndPointProperty((Properties)props)) != null) {
            this.endPointText.setText(endPoint);
        }
        if ((endPointName = props.getProperty("EndPointName")) != null) {
            this.endPointNameText.setText(endPointName);
        }
        if ((bindingType = props.getProperty("DefaultBinding")) != null) {
            this.bindingTypeText.setText(bindingType);
        }
    }

    protected Properties collectProperties() {
        Properties result = super.collectProperties();
        if (result == null) {
            IConnectionProfile profile = this.getConnectionProfile();
            result = (Properties)profile.getBaseProperties().clone();
        }
        result.setProperty("wsdlURI", this.urlText.getText());
        result.setProperty("SecurityType", this.credentialsComposite.getSecurityOption().name());
        if (this.credentialsComposite.getUserName() != null) {
            result.setProperty("AuthUserName", this.credentialsComposite.getUserName());
        }
        if (this.credentialsComposite.getPassword() != null) {
            result.setProperty("AuthPassword", this.credentialsComposite.getPassword());
        }
        result.setProperty("EndPoint", this.endPointText.getText());
        result.setProperty("EndPointName", this.endPointNameText.getText());
        result.setProperty("DefaultBinding", this.bindingTypeText.getText());
        return result;
    }
}

