/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.ws;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.teiid.designer.core.util.URLHelper;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.ui.common.ICredentialsCommon;

public class WSWizardUtils {
    private WSWizardUtils() {
    }

    public static Exception testRestURLConnection(IConnectionProfile connectionProfile, String propertyKey) {
        Properties connProperties = connectionProfile.getBaseProperties();
        String xmlFile = connProperties == null ? null : (String)connProperties.get(propertyKey);
        String responseType = "XML";
        if (connProperties != null && connProperties.get("responseType") != null) {
            responseType = (String)connProperties.get("responseType");
        }
        try {
            URL url = URLHelper.buildURL((String)xmlFile);
            String userName = null;
            String password = null;
            userName = connProperties.getProperty("AuthUserName");
            password = connProperties.getProperty("AuthPassword");
            URI uri = url.toURI();
            GetMethod httpget = new GetMethod(uri.toString());
            String securityType = null;
            boolean secure = userName != null && !userName.isEmpty();
            HttpClient client = new HttpClient();
            if (secure) {
                securityType = (String)connProperties.get("SecurityType");
                client.getState().setCredentials(new AuthScope(uri.getHost(), uri.getPort()), (Credentials)new UsernamePasswordCredentials(userName, password));
                ArrayList<String> authPrefs = new ArrayList<String>(1);
                if (securityType.equals(ICredentialsCommon.SecurityType.HTTPBasic.toString())) {
                    authPrefs.add("Basic");
                } else if (securityType.equals(ICredentialsCommon.SecurityType.Digest.toString())) {
                    authPrefs.add("Digest");
                }
                client.getParams().setParameter("http.auth.scheme-priority", authPrefs);
            }
            if (connProperties.get("Accept") != null) {
                httpget.addRequestHeader("Accept", (String)connProperties.get("Accept"));
            } else if (responseType.equalsIgnoreCase("JSON")) {
                httpget.addRequestHeader("Accept", "application/json");
            } else {
                httpget.addRequestHeader("Accept", "application/xml");
            }
            if (connProperties.get("Content-Type") != null) {
                httpget.addRequestHeader("Content-Type", (String)connProperties.get("Content-Type"));
            } else {
                httpget.addRequestHeader("Content-Type", "application/xml");
            }
            int code = 0;
            if (secure) {
                client.getParams().setAuthenticationPreemptive(true);
                httpget.setDoAuthentication(true);
                code = client.executeMethod((HttpMethod)httpget);
            } else {
                client.getParams().setAuthenticationPreemptive(false);
                httpget.setDoAuthentication(false);
                code = client.executeMethod((HttpMethod)httpget);
            }
            if (code != 200) {
                throw new Exception(DatatoolsUiConstants.UTIL.getString("WSWizardUtils.connectionFailureMessage", new Object[0]));
            }
        }
        catch (Exception ex) {
            return ex;
        }
        return null;
    }

    public static Exception testURLConnection(IConnectionProfile connectionProfile, String propertyKey) {
        Properties connProperties = connectionProfile.getBaseProperties();
        String xmlFile = connProperties == null ? null : (String)connProperties.get(propertyKey);
        String responseType = "XML";
        if (connProperties != null && connProperties.get("responseType") != null) {
            responseType = (String)connProperties.get("responseType");
        }
        try {
            URL url = URLHelper.buildURL((String)xmlFile);
            boolean resolved = false;
            HashMap<String, String> connPropMap = new HashMap<String, String>();
            if (connProperties.get("Accept") != null) {
                connPropMap.put("Accept", (String)connProperties.get("Accept"));
            } else if (responseType.equalsIgnoreCase("JSON")) {
                connPropMap.put("Accept", "application/json");
            } else {
                connPropMap.put("Accept", "application/xml");
            }
            if (connProperties.get("Content-Type") != null) {
                connPropMap.put("Content-Type", (String)connProperties.get("Content-Type"));
            } else {
                connPropMap.put("Content-Type", "application/xml");
            }
            for (Object key : connPropMap.keySet()) {
                String keyStr = (String)key;
                if ("Authorization".equalsIgnoreCase(keyStr) || "AuthPassword".equalsIgnoreCase(keyStr) || "SecurityType".equalsIgnoreCase(keyStr) || "AuthUserName".equalsIgnoreCase(keyStr) || "EndPoint".equalsIgnoreCase(keyStr) || "Content-Type".equalsIgnoreCase(keyStr) || "Accept".equalsIgnoreCase(keyStr)) continue;
                connPropMap.put(keyStr, connProperties.getProperty(keyStr));
            }
            String userName = null;
            String password = null;
            userName = connProperties.getProperty("AuthUserName");
            resolved = URLHelper.resolveUrl((URL)url, (String)userName, (String)(password = connProperties.getProperty("AuthPassword")), connPropMap, (boolean)true);
            if (!resolved) {
                throw new Exception(DatatoolsUiConstants.UTIL.getString("WSWizardUtils.connectionFailureMessage", new Object[0]));
            }
        }
        catch (Exception ex) {
            return ex;
        }
        return null;
    }
}

