/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.xml;

import java.io.File;
import java.util.Properties;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ui.wizards.ProfileDetailsPropertyPage;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.datatools.ui.DatatoolsUiPlugin;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class XmlLocalFileProfilePropertyPage
extends ProfileDetailsPropertyPage
implements IContextProvider,
DatatoolsUiConstants {
    private static final String FILE_IMPORT_MASK = "*.xml;";
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(DatatoolsUiPlugin.getDefault().getBundle().getSymbolicName());
    private Composite scrolled;
    private Label localFilePathLabel;
    private Text localFilePathText;
    private Button fileSystemSourceBrowseButton;

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.setPingButtonEnabled(false);
        this.setPingButtonVisible(false);
        return result;
    }

    protected void createCustomContents(Composite parent) {
        Group group = WidgetFactory.createSimpleGroup((Composite)parent, (String)UTIL.getString("Common.Properties.Label", new Object[0]));
        this.scrolled = new Composite((Composite)group, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.scrolled.setLayout((Layout)gridLayout);
        this.localFilePathLabel = new Label(this.scrolled, 0);
        this.localFilePathLabel.setText(UTIL.getString("Common.URL.Label", new Object[0]));
        this.localFilePathLabel.setToolTipText(UTIL.getString("Common.URL.ToolTip", new Object[0]));
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        this.localFilePathLabel.setLayoutData((Object)gd);
        this.localFilePathText = new Text(this.scrolled, 2052);
        this.localFilePathText.setToolTipText(UTIL.getString("Common.URL.ToolTip", new Object[0]));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.localFilePathText.setLayoutData((Object)gd);
        this.fileSystemSourceBrowseButton = new Button(this.scrolled, 8);
        this.fileSystemSourceBrowseButton.setText(UTIL.getString("Common.BROWSE_BUTTON_LBL_UI_", new Object[0]));
        this.fileSystemSourceBrowseButton.setLayoutData((Object)new GridData(256));
        this.initControls();
        this.addlisteners();
    }

    private void addlisteners() {
        this.localFilePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XmlLocalFileProfilePropertyPage.this.validate();
            }
        });
        this.fileSystemSourceBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                XmlLocalFileProfilePropertyPage.this.handleFileSystemSourceBrowseButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void handleFileSystemSourceBrowseButtonPressed() {
        int lastSeparatorIndex;
        String selectedFilePath = null;
        FileDialog dialog = new FileDialog(this.localFilePathText.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{FILE_IMPORT_MASK});
        String currentSourceString = this.localFilePathText.getText();
        if (currentSourceString != null && (lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator)) != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
        }
        if ((selectedFilePath = dialog.open()) != null) {
            if (!selectedFilePath.equals(this.localFilePathText.getText())) {
                this.localFilePathText.setText(selectedFilePath);
            }
        } else {
            this.localFilePathText.setText("");
        }
    }

    protected void validate() {
        String errorMessage = null;
        boolean valid = true;
        if (this.localFilePathText.getText() == null || this.localFilePathText.getText().isEmpty()) {
            errorMessage = UTIL.getString("Common.URL.Error.Message", new Object[0]);
            valid = false;
        }
        this.setErrorMessage(errorMessage);
        this.setValid(valid);
    }

    private void initControls() {
        IConnectionProfile profile = this.getConnectionProfile();
        Properties props = profile.getBaseProperties();
        if (props.get("LocalFilePath") != null) {
            this.localFilePathText.setText((String)props.get("LocalFilePath"));
        }
    }

    protected Properties collectProperties() {
        Properties result = super.collectProperties();
        if (result == null) {
            result = new Properties();
        }
        String fileUrl = this.localFilePathText.getText();
        result.setProperty("LocalFilePath", fileUrl);
        Path fullPath = new Path(fileUrl);
        String directoryUrl = fullPath.removeLastSegments(1).toString();
        result.setProperty("ParentDirectory", directoryUrl);
        return result;
    }
}

