/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.ui.actions;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.datatools.connection.ConnectionInfoProviderFactory;
import org.teiid.designer.datatools.connection.IConnectionInfoProvider;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.datatools.ui.DatatoolsUiPlugin;
import org.teiid.designer.datatools.ui.dialogs.SelectConnectionProfileDialog;
import org.teiid.designer.jdbc.JdbcSource;
import org.teiid.designer.jdbc.impl.JdbcFactoryImpl;
import org.teiid.designer.ui.actions.IConnectionAction;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;

public class SetConnectionProfileAction
extends SortableSelectionAction
implements IConnectionAction {
    private static final String label = DatatoolsUiConstants.UTIL.getString("SetConnectionProfileAction.title", new Object[0]);
    private static final String NO_PROFILE_PROVIDER_FOUND_KEY = "NoProfileProviderFound";
    private Properties designerProperties;
    private IConnectionProfile connectionProfile;

    public SetConnectionProfileAction() {
        super(label, -1);
        this.setImageDescriptor(DatatoolsUiPlugin.getDefault().getImageDescriptor("icons/full/obj16/set-connection.png"));
    }

    public boolean isValidSelection(ISelection selection) {
        return this.sourceModelSelected(selection);
    }

    public void run() {
        IFile modelFile = (IFile)SelectionUtilities.getSelectedObjects((ISelection)this.getSelection()).get(0);
        boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Set Connection Profile", (Object)((Object)this));
        boolean succeeded = false;
        try {
            try {
                ModelEditor editor = ModelEditorManager.getModelEditorForFile((IFile)modelFile, (boolean)true);
                if (editor != null) {
                    boolean isDirty = editor.isDirty();
                    SetConnectionProfileAction.setConnectionProfile(modelFile);
                    if (!isDirty && editor.isDirty()) {
                        editor.doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                    succeeded = true;
                }
            }
            catch (Exception e) {
                this.logException(e);
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                return;
            }
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    private void logException(Exception e) {
        String msg = e.getMessage();
        if (msg != null && msg.equalsIgnoreCase(NO_PROFILE_PROVIDER_FOUND_KEY)) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)DatatoolsUiConstants.UTIL.getString("SetConnectionProfileAction.noProvileProviderTitle", new Object[0]), (String)DatatoolsUiConstants.UTIL.getString("SetConnectionProfileAction.noProvileProviderMessage", new Object[0]));
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)DatatoolsUiConstants.UTIL.getString("SetConnectionProfileAction.exceptionMessage", new Object[0]), (String)e.getMessage());
            Status status = new Status(4, "org.teiid.designer.datatools.ui", DatatoolsUiConstants.UTIL.getString("SetConnectionProfileAction.exceptionMessage", new Object[0]), (Throwable)e);
            DatatoolsUiConstants.UTIL.log((IStatus)status);
        }
    }

    public static boolean setConnectionProfile(IFile modelFile) throws Exception {
        Object[] result;
        SelectConnectionProfileDialog dialog = new SelectConnectionProfileDialog(Display.getCurrent().getActiveShell());
        dialog.open();
        if (dialog.getReturnCode() == 0 && (result = dialog.getResult()) != null && result.length == 1) {
            IConnectionProfile profile = (IConnectionProfile)result[0];
            SetConnectionProfileAction.updateJdbcSourceAndConnectionInfo(modelFile, profile);
            return true;
        }
        return false;
    }

    public boolean setConnectionProfile() {
        ISelection selection = this.getSelection();
        if (selection == null || selection.isEmpty()) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)DatatoolsUiConstants.UTIL.getString("SetConnectionProfileAction.sourceModelUndefined.title", new Object[0]), (String)DatatoolsUiConstants.UTIL.getString("SetConnectionProfileAction.sourceModelUndefined.title", new Object[0]));
            return false;
        }
        IFile modelFile = (IFile)SelectionUtilities.getSelectedObjects((ISelection)selection).get(0);
        if (this.connectionProfile == null) {
            Object[] result;
            SelectConnectionProfileDialog dialog = new SelectConnectionProfileDialog(Display.getCurrent().getActiveShell());
            dialog.open();
            if (dialog.getReturnCode() == 0 && (result = dialog.getResult()) != null && result.length == 1) {
                this.connectionProfile = (IConnectionProfile)result[0];
            }
        }
        if (this.connectionProfile != null) {
            try {
                SetConnectionProfileAction.updateJdbcSourceAndConnectionInfo(modelFile, this.connectionProfile);
            }
            catch (Exception e) {
                this.logException(e);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isApplicable(ISelection selection) {
        return this.sourceModelSelected(selection);
    }

    private boolean sourceModelSelected(ISelection theSelection) {
        boolean result = false;
        List allObjs = SelectionUtilities.getSelectedObjects((ISelection)theSelection);
        if (!allObjs.isEmpty() && allObjs.size() == 1) {
            Iterator iter = allObjs.iterator();
            result = true;
            Object nextObj = null;
            while (iter.hasNext() && result) {
                nextObj = iter.next();
                result = nextObj instanceof IFile ? ModelIdentifier.isRelationalSourceModel((IResource)((IFile)nextObj)) : false;
            }
        }
        return result;
    }

    public static void setConnectionInfo(IFile model, IConnectionProfile connectionProfile, boolean driverClassChanged) throws Exception {
        ModelResource mr = ModelUtil.getModelResource((IFile)model, (boolean)true);
        ConnectionInfoProviderFactory manager = new ConnectionInfoProviderFactory();
        IConnectionInfoProvider provider = manager.getProvider(connectionProfile);
        if (provider == null) {
            throw new Exception(NO_PROFILE_PROVIDER_FOUND_KEY);
        }
        provider.setConnectionInfo(mr, connectionProfile);
    }

    private Shell getShell() {
        return Display.getCurrent().getActiveShell();
    }

    private static void updateJdbcSourceAndConnectionInfo(IFile model, IConnectionProfile profile) throws Exception {
        boolean driverClassChanged = false;
        ModelResource modelResc = ModelUtil.getModelResource((IFile)model, (boolean)true);
        JdbcSource jdbcSource = null;
        if (modelResc != null) {
            jdbcSource = SetConnectionProfileAction.getJdbcSource(modelResc);
            if (jdbcSource != null) {
                String userName;
                String driverClass;
                String url;
                String driverName;
                String profileName;
                Properties profileProps = profile.getBaseProperties();
                String driverClassCP = profileProps.getProperty("org.eclipse.datatools.connectivity.db.driverClass");
                String driverClassJdbcSrc = jdbcSource.getDriverClass();
                if (driverClassCP != null && !driverClassCP.equalsIgnoreCase(driverClassJdbcSrc)) {
                    String title = DatatoolsUiConstants.UTIL.getString("SetConnectionProfileAction.confirmDriverclassChangeDialogTitle", new Object[0]);
                    String msg = DatatoolsUiConstants.UTIL.getString("SetConnectionProfileAction.confirmDriverclassChangeDialogMsg", new Object[0]);
                    if (!MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)msg)) {
                        return;
                    }
                    driverClassChanged = true;
                }
                if (!CoreStringUtil.isEmpty((String)(profileName = profile.getName()))) {
                    jdbcSource.setName(profileName);
                }
                String driverID = profileProps.getProperty("org.eclipse.datatools.connectivity.driverDefinitionID");
                DriverInstance driver = DriverManager.getInstance().getDriverInstanceByID(driverID);
                if (driver != null && !CoreStringUtil.isEmpty((String)(driverName = driver.getName()))) {
                    jdbcSource.setDriverName(driverName);
                }
                if (!CoreStringUtil.isEmpty((String)(url = profileProps.getProperty("org.eclipse.datatools.connectivity.db.URL")))) {
                    jdbcSource.setUrl(url);
                }
                if (!CoreStringUtil.isEmpty((String)(driverClass = profileProps.getProperty("org.eclipse.datatools.connectivity.db.driverClass")))) {
                    jdbcSource.setDriverClass(driverClass);
                }
                if (!CoreStringUtil.isEmpty((String)(userName = profileProps.getProperty("org.eclipse.datatools.connectivity.db.username")))) {
                    jdbcSource.setUsername(userName);
                }
                if (driverClassChanged) {
                    JdbcFactoryImpl jdbcFactory = new JdbcFactoryImpl();
                    jdbcSource.setImportSettings(jdbcFactory.createJdbcImportSettings());
                }
            }
            SetConnectionProfileAction.setConnectionInfo(model, profile, driverClassChanged);
            if (driverClassChanged) {
                ModelUtil.setModelAnnotationPropertyValue((ModelResource)modelResc, (String)"jdbcConnection:allowAutoUpdate", (String)"false");
                ModelUtil.setModelAnnotationPropertyValue((ModelResource)modelResc, (String)"jdbcConnection:allowCostUpdate", (String)"false");
            }
        }
        modelResc.save(null, true);
    }

    private static JdbcSource getJdbcSource(ModelResource modelResc) {
        JdbcSource jdbcSource = null;
        if (modelResc != null) {
            List rootObjs = null;
            try {
                rootObjs = modelResc.getAllRootEObjects();
            }
            catch (Exception ex) {
                DatatoolsUiConstants.UTIL.log((Throwable)ex);
                return null;
            }
            if (rootObjs != null) {
                for (Object obj : rootObjs) {
                    if (!(obj instanceof JdbcSource)) continue;
                    jdbcSource = (JdbcSource)obj;
                }
            }
        }
        return jdbcSource;
    }

    public boolean setProperties(Properties properties) {
        this.designerProperties = properties;
        if (properties != null) {
            IFile model;
            String profileName = DesignerPropertiesUtil.getConnectionProfileName((Properties)this.designerProperties);
            if (profileName != null) {
                this.connectionProfile = ProfileManager.getInstance().getProfileByName(profileName);
            }
            if ((model = DesignerPropertiesUtil.getSourceModel((Properties)this.designerProperties)) != null) {
                this.setSelection((ISelection)new StructuredSelection((Object)model));
                return true;
            }
        }
        return false;
    }
}

