/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.ui.dialogs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.wizards.NewCPWizard;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.datatools.ui.actions.EditConnectionProfileAction;
import org.teiid.designer.datatools.ui.dialogs.IProfileChangedListener;
import org.teiid.designer.datatools.ui.dialogs.NewTeiidFilteredCPWizard;

public class ConnectionProfileWorker {
    private String categoryID;
    private IConnectionProfile selectedProfile;
    private Set<IConnectionProfile> allProfiles;
    private Shell shell;
    private IProfileChangedListener listener;
    private static final ProfileManager profileManager = ProfileManager.getInstance();

    public ConnectionProfileWorker(Shell shell, String categoryID, IProfileChangedListener listener) {
        this.shell = shell;
        this.categoryID = categoryID;
        this.listener = listener;
        this.allProfiles = new HashSet<IConnectionProfile>();
        this.reloadProfiles();
    }

    public void create() {
        Object wiz = null;
        wiz = this.categoryID == null ? new NewCPWizard() : new NewTeiidFilteredCPWizard(this.categoryID);
        WizardDialog wizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wiz);
        wizardDialog.setBlockOnOpen(true);
        CPListener listener = new CPListener();
        ProfileManager.getInstance().addProfileListener((IProfileListener)listener);
        if (wizardDialog.open() == 0) {
            this.selectedProfile = listener.getChangedProfile();
            this.reloadProfiles();
            this.notifyProfileChanged();
        }
        ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
    }

    public void edit() {
        if (this.selectedProfile != null) {
            EditConnectionProfileAction action = new EditConnectionProfileAction(this.shell, this.selectedProfile);
            CPListener listener = new CPListener();
            ProfileManager.getInstance().addProfileListener((IProfileListener)listener);
            action.run();
            this.reloadProfiles();
            ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
            this.notifyProfileChanged();
        }
    }

    public IConnectionProfile getConnectionProfile() {
        return this.selectedProfile;
    }

    public IConnectionProfile getProfile(String name) {
        return profileManager.getProfileByName(name);
    }

    public List<IConnectionProfile> getProfiles() {
        return new ArrayList<IConnectionProfile>(this.allProfiles);
    }

    private void notifyProfileChanged() {
        if (this.listener != null) {
            this.listener.profileChanged(this.selectedProfile);
        }
    }

    private void reloadProfiles() {
        this.allProfiles.clear();
        if (this.categoryID == null) {
            IConnectionProfile[] iConnectionProfileArray = profileManager.getProfiles();
            int n = iConnectionProfileArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConnectionProfile prof = iConnectionProfileArray[n2];
                this.allProfiles.add(prof);
                ++n2;
            }
        } else {
            IConnectionProfile prof;
            IConnectionProfile[] iConnectionProfileArray = profileManager.getProfilesByCategory(this.categoryID);
            int n = iConnectionProfileArray.length;
            int n3 = 0;
            while (n3 < n) {
                prof = iConnectionProfileArray[n3];
                this.allProfiles.add(prof);
                ++n3;
            }
            iConnectionProfileArray = profileManager.getProfileByProviderID(this.categoryID);
            n = iConnectionProfileArray.length;
            n3 = 0;
            while (n3 < n) {
                prof = iConnectionProfileArray[n3];
                this.allProfiles.add(prof);
                ++n3;
            }
        }
    }

    public void setSelection(IConnectionProfile profile) {
        this.selectedProfile = profile;
    }

    public class CPListener
    implements IProfileListener {
        IConnectionProfile changedProfile;

        public IConnectionProfile getChangedProfile() {
            return this.changedProfile;
        }

        public void profileAdded(IConnectionProfile profile) {
            this.changedProfile = profile;
        }

        public void profileChanged(IConnectionProfile profile) {
            this.changedProfile = profile;
        }

        public void profileDeleted(IConnectionProfile profile) {
        }
    }
}

