/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.ui.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.ui.actions.AddProfileViewAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.datatools.ui.dialogs.ConnectionProfileTreeProvider;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.MessageLabel;

public class SelectConnectionProfileDialog
extends ElementTreeSelectionDialog
implements ISelectionChangedListener {
    private static final String DEFAULT_TITLE = DatatoolsUiConstants.UTIL.getString("SelectConnectionProfileDialog.title", new Object[0]);
    private static final String NEW_BUTTON_TEXT = DatatoolsUiConstants.UTIL.getString("SelectConnectionProfileDialog.newButton", new Object[0]);
    private Text fileNameText;
    private MessageLabel statusMessageLabel;
    private Button newCPButton;
    private IConnectionProfile selectedCP;
    private static final String UNKNOWN_FILE = DatatoolsUiConstants.UTIL.getString("SelectConnectionProfileDialog.unknownFileName", new Object[0]);

    public SelectConnectionProfileDialog(Shell parent) {
        this(parent, DEFAULT_TITLE, (ILabelProvider)new ConnectionProfileTreeProvider(), new ConnectionProfileTreeProvider());
    }

    public SelectConnectionProfileDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        this(parent, null, labelProvider, contentProvider);
    }

    public SelectConnectionProfileDialog(Shell parent, String title, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.setTitle(title);
        this.setMessage(DatatoolsUiConstants.UTIL.getString("SelectConnectionProfileDialog.defaultMessage", new Object[0]));
        this.setInput(ProfileManager.getInstance());
        this.setAllowMultiple(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        GridData panelData = new GridData(1808);
        panel.setLayoutData((Object)panelData);
        Group selectedGroup = WidgetFactory.createGroup((Composite)panel, (String)DatatoolsUiConstants.UTIL.getString("SelectConnectionProfileDialog.selectedGroupTitle", new Object[0]), (int)768);
        selectedGroup.setLayout((Layout)new GridLayout(2, false));
        this.fileNameText = WidgetFactory.createTextField((Composite)selectedGroup, (int)768, (String)UNKNOWN_FILE);
        GridData data = new GridData(768);
        data.heightHint = this.convertHeightInCharsToPixels(1);
        this.fileNameText.setLayoutData((Object)data);
        this.fileNameText.setEditable(false);
        this.fileNameText.setBackground(panel.getBackground());
        this.fileNameText.setText(UNKNOWN_FILE);
        this.newCPButton = WidgetFactory.createButton((Composite)selectedGroup, (String)NEW_BUTTON_TEXT);
        this.newCPButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddProfileViewAction action = new AddProfileViewAction();
                action.run();
                SelectConnectionProfileDialog.this.selectedCP = action.getAddedProfile();
                if (SelectConnectionProfileDialog.this.selectedCP != null) {
                    SelectConnectionProfileDialog.this.setInput(ProfileManager.getInstance());
                    SelectConnectionProfileDialog.this.getTreeViewer().refresh();
                    SelectConnectionProfileDialog.this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)SelectConnectionProfileDialog.this.selectedCP));
                }
            }
        });
        super.createDialogArea(panel);
        this.statusMessageLabel = new MessageLabel(panel);
        GridData statusData = new GridData(768);
        data.heightHint = this.convertHeightInCharsToPixels(1);
        this.statusMessageLabel.setLayoutData((Object)statusData);
        this.statusMessageLabel.setEnabled(false);
        this.statusMessageLabel.setText(UNKNOWN_FILE);
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        return panel;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        TreeSelection selection = (TreeSelection)event.getSelection();
        if (selection.isEmpty()) {
            this.selectedCP = null;
            this.fileNameText.setText(UNKNOWN_FILE);
            this.updateOnSelection(null);
            return;
        }
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof ICategory) {
            this.selectedCP = null;
            this.fileNameText.setText(UNKNOWN_FILE);
        } else {
            this.selectedCP = (IConnectionProfile)selection.getFirstElement();
            this.fileNameText.setText(this.selectedCP.getName());
        }
        this.updateOnSelection(firstElement);
    }

    private void updateOnSelection(Object selectedObject) {
        Status status = new Status(1, "org.teiid.designer.datatools.ui", DatatoolsUiConstants.UTIL.getString("SelectConnectionProfileDialog.okSelectionMessage", new Object[0]));
        if (selectedObject != null) {
            if (selectedObject instanceof ICategory) {
                status = new Status(4, "org.teiid.designer.datatools.ui", DatatoolsUiConstants.UTIL.getString("SelectConnectionProfileDialog.categorySelectionMessage", new Object[0]));
                this.getOkButton().setEnabled(false);
            } else {
                this.getOkButton().setEnabled(true);
            }
        } else {
            status = new Status(4, "org.teiid.designer.datatools.ui", DatatoolsUiConstants.UTIL.getString("SelectConnectionProfileDialog.invalidSelectionMessage", new Object[0]));
            this.getOkButton().setEnabled(false);
        }
        this.statusMessageLabel.setErrorStatus((IStatus)status);
    }

    public IConnectionProfile getSelectedCP() {
        return this.selectedCP;
    }
}

