/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.ui.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;

public class PingJobWithoutPopup
extends Job {
    private IConnectionProfile icp;
    private Throwable exception;
    IStatus result = Status.OK_STATUS;

    public PingJobWithoutPopup(Shell shell, IConnectionProfile profile) {
        super(DatatoolsUiConstants.UTIL.getStringOrKey("PingJobWithoutPopup.ping.job"));
        this.setSystem(false);
        this.setUser(true);
        this.icp = profile;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.title"), -1);
        IConnection con = PingJobWithoutPopup.createTestConnection(this.icp);
        monitor.done();
        this.exception = PingJobWithoutPopup.getTestConnectionException(con);
        if (con != null) {
            con.close();
        }
        if (this.exception != null) {
            Object[] params = new Object[]{this.icp.getName(), this.exception.getMessage()};
            String errorMessage = DatatoolsUiConstants.UTIL.getString("PingJobWithoutPopup.errorPingingConnectionProfile", params);
            this.result = new Status(4, "org.teiid.designer.datatools", errorMessage);
        }
        return this.result;
    }

    public static IConnection createTestConnection(IConnectionProfile icp) {
        if (icp == null) {
            return null;
        }
        return icp.createConnection("org.eclipse.datatools.connectivity.connectionFactory.pingFactory");
    }

    public static Throwable getTestConnectionException(IConnection conn) {
        return conn != null ? conn.getConnectException() : new RuntimeException(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.failure"));
    }
}

