/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.utils;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.emf.compare.internal.utils.Graph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReadOnlyGraph<E> {
    private final Graph<E> graph;

    private ReadOnlyGraph(Graph<E> graph) {
        this.graph = graph;
    }

    public static <E> ReadOnlyGraph<E> toReadOnlyGraph(Graph<E> graph) {
        return new ReadOnlyGraph<E>(graph);
    }

    public boolean contains(E element) {
        return this.graph.contains(element);
    }

    public boolean hasChild(E parent, E potentialChild) {
        return this.graph.hasChild(parent, potentialChild);
    }

    public ImmutableSet<E> getDirectParents(E element) {
        return ImmutableSet.copyOf(this.graph.getDirectParents(element));
    }

    public E getParentData(E element) {
        return this.graph.getParentData(element);
    }

    public ImmutableSet<E> getSubgraphContaining(E element) {
        return this.getSubgraphContaining(element, ImmutableSet.of());
    }

    public ImmutableSet<E> getSubgraphContaining(E element, ImmutableSet<E> endPoints) {
        return ImmutableSet.copyOf(this.graph.getSubgraphContaining(element, (Set<E>)endPoints));
    }

    public ImmutableSet<E> getTreeFrom(E root) {
        return this.getTreeFrom(root, (Set<E>)ImmutableSet.of());
    }

    public ImmutableSet<E> getTreeFrom(E root, Set<E> endPoints) {
        return ImmutableSet.copyOf(this.graph.getTreeFrom(root, endPoints));
    }
}

