/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.model.lines;

import org.apache.directory.studio.ldifparser.LdifParserConstants;
import org.apache.directory.studio.ldifparser.model.lines.LdifValueLineBase;

public class LdifChangeTypeLine
extends LdifValueLineBase {
    public LdifChangeTypeLine(int offset, String rawChangeTypeSpec, String rawValueType, String rawChangeType, String rawNewLine) {
        super(offset, rawChangeTypeSpec, rawValueType, rawChangeType, rawNewLine);
    }

    public String getRawChangeTypeSpec() {
        return super.getRawLineStart();
    }

    public String getUnfoldedChangeTypeSpec() {
        return super.getUnfoldedLineStart();
    }

    public String getRawChangeType() {
        return super.getRawValue();
    }

    public String getUnfoldedChangeType() {
        return super.getUnfoldedValue();
    }

    @Override
    public String toRawString() {
        return super.toRawString();
    }

    public boolean isAdd() {
        return this.getUnfoldedChangeType().equals("add");
    }

    public boolean isDelete() {
        return this.getUnfoldedChangeType().equals("delete");
    }

    public boolean isModify() {
        return this.getUnfoldedChangeType().equals("modify");
    }

    public boolean isModDn() {
        String unfoldedChangeType = this.getUnfoldedChangeType();
        return "moddn".equalsIgnoreCase(unfoldedChangeType) || "modrdn".equalsIgnoreCase(unfoldedChangeType);
    }

    @Override
    public String getInvalidString() {
        if (this.getUnfoldedChangeTypeSpec().length() == 0) {
            return "Missing spec 'changetype'";
        }
        if (this.getUnfoldedChangeType().length() == 0) {
            return "Missing changetype";
        }
        return super.getInvalidString();
    }

    public static LdifChangeTypeLine createDelete() {
        return new LdifChangeTypeLine(0, "changetype", ":", "delete", LdifParserConstants.LINE_SEPARATOR);
    }

    public static LdifChangeTypeLine createAdd() {
        return new LdifChangeTypeLine(0, "changetype", ":", "add", LdifParserConstants.LINE_SEPARATOR);
    }

    public static LdifChangeTypeLine createModify() {
        return new LdifChangeTypeLine(0, "changetype", ":", "modify", LdifParserConstants.LINE_SEPARATOR);
    }

    public static LdifChangeTypeLine createModDn() {
        return new LdifChangeTypeLine(0, "changetype", ":", "moddn", LdifParserConstants.LINE_SEPARATOR);
    }

    public static LdifChangeTypeLine createModRdn() {
        return new LdifChangeTypeLine(0, "changetype", ":", "modrdn", LdifParserConstants.LINE_SEPARATOR);
    }
}

